/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.project;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.service.internal.repository.ProjectTemplateDao;
import org.squashtest.tm.service.project.CustomProjectTemplateManagerService;
import org.squashtest.tm.service.project.GenericProjectCopyParameter;
import org.squashtest.tm.service.project.GenericProjectManagerService;

@Service(value="CustomProjectTemplateManagerService")
@Transactional
public class CustomProjectTemplateManagerServiceImpl
implements CustomProjectTemplateManagerService {
    @Inject
    private ProjectTemplateDao projectTemplateDao;
    @Inject
    private GenericProjectManagerService genericProjectManager;

    @Override
    @Transactional(readOnly=true)
    public List<ProjectTemplate> findAll() {
        return this.projectTemplateDao.findAll();
    }

    @Override
    public ProjectTemplate addTemplateFromProject(ProjectTemplate newTemplate, long sourceGenericProjectId, GenericProjectCopyParameter params) {
        this.genericProjectManager.persist((GenericProject)newTemplate);
        GenericProject source = this.genericProjectManager.findById(sourceGenericProjectId);
        this.genericProjectManager.synchronizeGenericProject((GenericProject)newTemplate, source, params);
        this.genericProjectManager.createAttachmentFromDescription((GenericProject)newTemplate);
        return newTemplate;
    }
}

