/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.milestone;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.EnumUtils;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;
import org.squashtest.tm.service.milestone.MilestoneModelService;

@Service
@Transactional(readOnly=true)
public class MilestoneModelServiceImpl
implements MilestoneModelService {
    @Inject
    private DSLContext dsl;

    @Override
    public Map<Long, JsonMilestone> findUsedMilestones(List<Long> readableProjectIds) {
        List<Long> usedMilestonesIds = this.findUsedMilestoneIds(readableProjectIds);
        return this.findJsonMilestones(usedMilestonesIds);
    }

    @Override
    public JsonMilestone findMilestoneModel(Long milestoneId) {
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        milestoneIds.add(milestoneId);
        Map<Long, JsonMilestone> jsonMilestones = this.findJsonMilestones(milestoneIds);
        return jsonMilestones.get(milestoneId);
    }

    @Override
    public Map<Long, List<JsonMilestone>> findMilestoneByProject(List<Long> readableProjectIds) {
        Map<Long, JsonMilestone> milestoneMap = this.findUsedMilestones(readableProjectIds);
        return this.doFindMilestoneByProject(readableProjectIds, milestoneMap);
    }

    protected Map<Long, JsonMilestone> findJsonMilestones(List<Long> usedMilestonesIds) {
        return this.dsl.selectDistinct((SelectField)Tables.MILESTONE.MILESTONE_ID, (SelectField)Tables.MILESTONE.LABEL, (SelectField)Tables.MILESTONE.M_RANGE, (SelectField)Tables.MILESTONE.STATUS, (SelectField)Tables.MILESTONE.END_DATE, (SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.CORE_USER).on(Tables.MILESTONE.USER_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).where(Tables.MILESTONE.MILESTONE_ID.in(usedMilestonesIds)).fetch().stream().map(r -> {
            String mRangeKey = (String)r.get((Field)Tables.MILESTONE.M_RANGE);
            MilestoneRange milestoneRange = (MilestoneRange)EnumUtils.getEnum(MilestoneRange.class, (String)mRangeKey);
            String mStatusKey = (String)r.get((Field)Tables.MILESTONE.STATUS);
            MilestoneStatus milestoneStatus = (MilestoneStatus)EnumUtils.getEnum(MilestoneStatus.class, (String)mStatusKey);
            return new JsonMilestone((Long)r.get((Field)Tables.MILESTONE.MILESTONE_ID), (String)r.get((Field)Tables.MILESTONE.LABEL), milestoneStatus, milestoneRange, (Date)r.get((Field)Tables.MILESTONE.END_DATE), (String)r.get((Field)Tables.CORE_USER.LOGIN));
        }).collect(Collectors.toMap(JsonMilestone::getId, Function.identity()));
    }

    protected List<Long> findUsedMilestoneIds(List<Long> readableProjectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.MILESTONE_BINDING.MILESTONE_ID).from((TableLike)Tables.MILESTONE_BINDING).where(Tables.MILESTONE_BINDING.PROJECT_ID.in(readableProjectIds)).fetch((Field)Tables.MILESTONE_BINDING.MILESTONE_ID, Long.class);
    }

    private Map<Long, List<JsonMilestone>> doFindMilestoneByProject(List<Long> readableProjectIds, Map<Long, JsonMilestone> milestoneMap) {
        Map<Long, List<JsonMilestone>> milestoneByProjectId = this.dsl.selectDistinct((SelectField)Tables.MILESTONE_BINDING.PROJECT_ID, (SelectField)Tables.MILESTONE_BINDING.MILESTONE_ID).from((TableLike)Tables.MILESTONE_BINDING).where(Tables.MILESTONE_BINDING.PROJECT_ID.in(readableProjectIds)).fetch().stream().collect(Collectors.groupingBy(r -> (Long)r.get((Field)Tables.MILESTONE_BINDING.PROJECT_ID), Collectors.mapping(r -> {
            Long milestoneId = (Long)r.get((Field)Tables.MILESTONE_BINDING.MILESTONE_ID);
            return (JsonMilestone)milestoneMap.get(milestoneId);
        }, Collectors.toList())));
        readableProjectIds.stream().filter(id -> !milestoneByProjectId.containsKey(id)).forEach(id -> {
            ArrayList arrayList = milestoneByProjectId.put((Long)id, new ArrayList());
        });
        return milestoneByProjectId;
    }
}

