/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.milestone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.milestone.MilestoneLabelAlreadyExistsException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.display.dto.milestone.MilestoneDuplicationModel;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.CustomMilestoneDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.milestone.CustomMilestoneManager;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Transactional
@Service(value="CustomMilestoneManager")
public class CustomMilestoneManagerServiceImpl
implements CustomMilestoneManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomMilestoneManagerServiceImpl.class);
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private MilestoneDisplayDao milestoneDisplayDao;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @PersistenceContext
    private EntityManager em;

    @Override
    @PreAuthorize(value="@featureManager.isEnabled('MILESTONE')")
    public void addMilestone(Milestone milestone) {
        User owner = this.userAccountService.findCurrentUser();
        UserDto ownerDto = UserDto.fromUser(owner);
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin(ownerDto.getPartyIds());
        this.checkLabelAvailability(milestone.getLabel());
        milestone.setOwner(owner);
        this.milestoneDao.save(milestone);
    }

    @Override
    public void changeLabel(long milestoneId, String newLabel) {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        Milestone milestone = (Milestone)this.milestoneDao.getReferenceById(milestoneId);
        if (StringUtils.equals((CharSequence)milestone.getLabel(), (CharSequence)newLabel)) {
            return;
        }
        this.checkLabelAvailability(newLabel);
        milestone.setLabel(newLabel);
    }

    private void checkLabelAvailability(String label) {
        if (this.milestoneDao.findByLabel(label) != null) {
            throw new MilestoneLabelAlreadyExistsException(label);
        }
    }

    @Override
    public List<Milestone> findAll() {
        return this.milestoneDao.findAll();
    }

    @Override
    public void removeMilestones(Collection<Long> ids) {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        List milestones = this.milestoneDao.findAllById(ids);
        for (Milestone milestone : milestones) {
            if (this.canEditMilestone(milestone)) {
                this.deleteMilestoneBinding(milestone);
                this.deleteMilestone(milestone);
                continue;
            }
            LOGGER.debug("Milestone with ID {} was filtered out because the user cannot delete it.", new Object[]{milestone.getId()});
        }
    }

    private void deleteMilestoneBinding(Milestone milestone) {
        List projects = milestone.getProjects();
        for (GenericProject project : projects) {
            project.unbindMilestone(milestone);
        }
    }

    private void deleteMilestone(Milestone milestone) {
        this.milestoneDao.delete(milestone);
    }

    @Override
    @Transactional(readOnly=true)
    public Milestone findById(long milestoneId) {
        return (Milestone)this.milestoneDao.getReferenceById(milestoneId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Milestone> findAllByIds(List<Long> milestoneIds) {
        return this.milestoneDao.findAllById(milestoneIds);
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> findMilestoneLabelByIds(List<Long> milestoneIds, List<Long> projectIds) {
        return this.milestoneDao.findMilestoneLabelByIds(milestoneIds, projectIds);
    }

    @Override
    public void verifyCanEditMilestone(long milestoneId) {
        if (!this.canEditMilestone(milestoneId)) {
            throw new AccessDeniedException(HttpStatus.FORBIDDEN.getReasonPhrase());
        }
    }

    private boolean isGlobal(Milestone milestone) {
        return MilestoneRange.GLOBAL == milestone.getRange();
    }

    private boolean isCreatedBySelf(Milestone milestone) {
        String myName = UserContextHolder.getUsername();
        return myName.equals(milestone.getOwner().getLogin());
    }

    @Override
    public void verifyCanEditMilestoneRange() {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            throw new AccessDeniedException(HttpStatus.FORBIDDEN.getReasonPhrase());
        }
    }

    @Override
    public boolean canEditMilestone(long milestoneId) {
        Milestone milestone = (Milestone)this.milestoneDao.getReferenceById(milestoneId);
        return this.canEditMilestone(milestone);
    }

    private boolean canEditMilestone(Milestone milestone) {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            return !this.isGlobal(milestone) && this.isCreatedBySelf(milestone);
        }
        return true;
    }

    @Override
    public List<Long> findAllIdsOfEditableMilestone() {
        List<Milestone> milestones = this.findAll();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Milestone milestone : milestones) {
            if (!this.canEditMilestone(milestone.getId())) continue;
            ids.add(milestone.getId());
        }
        return ids;
    }

    @Override
    public List<Milestone> findAllVisibleToCurrentManager() {
        List<Milestone> allMilestones = this.findAll();
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestones.addAll(allMilestones);
        } else {
            for (Milestone milestone : allMilestones) {
                if (!this.isGlobal(milestone) && !this.isCreatedBySelf(milestone) && !this.isInAProjetICanManage(milestone)) continue;
                milestones.add(milestone);
            }
        }
        return milestones;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Milestone> findAllVisibleToCurrentUser() {
        List<Long> milestoneIds = this.findAllIdsVisibleToCurrentUser();
        return this.milestoneDao.findAllById(milestoneIds);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> findAllIdsVisibleToCurrentUser() {
        UserDto user = this.userAccountService.findCurrentUserDto();
        if (user.isAdmin()) {
            return this.milestoneDao.findAllMilestoneIds();
        }
        return this.milestoneDao.findMilestoneIdsForUsers(user.getPartyIds());
    }

    private boolean isInAProjetICanManage(Milestone milestone) {
        boolean isInAProjetICanManage = false;
        List perimeter = milestone.getPerimeter();
        for (GenericProject project : perimeter) {
            if (!this.canIManageThisProject(project)) continue;
            isInAProjetICanManage = true;
            break;
        }
        return isInAProjetICanManage;
    }

    private boolean canIManageThisProject(GenericProject project) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.MANAGE_PROJECT.name(), project);
    }

    private List<GenericProject> getProjectICanManage(Collection<GenericProject> projects) {
        ArrayList<GenericProject> manageableProjects = new ArrayList<GenericProject>();
        for (GenericProject project : projects) {
            if (!this.canIManageThisProject(project)) continue;
            manageableProjects.add(project);
        }
        return manageableProjects;
    }

    @Override
    public boolean isBoundToATemplate(long milestoneId) {
        Milestone milestone = this.findById(milestoneId);
        return milestone.isBoundToATemplate();
    }

    @Override
    public long cloneMilestone(long motherId, MilestoneDuplicationModel model) {
        UserDto user = this.userAccountService.findCurrentUserDto();
        Milestone mother = this.findById(motherId);
        if (mother.getStatus().isAllowObjectDuplication()) {
            Milestone milestone = MilestoneDuplicationModel.toMilestone(model);
            if (user.isAdmin()) {
                milestone.setRange(mother.getRange());
            } else {
                milestone.setRange(MilestoneRange.RESTRICTED);
            }
            boolean copyAllPerimeter = user.isAdmin() || !this.isGlobal(mother) && this.isCreatedBySelf(mother);
            this.bindProjectsAndPerimeter(mother, milestone, copyAllPerimeter);
            this.bindRequirements(mother, milestone, model.bindToRequirements(), copyAllPerimeter);
            this.bindTestCases(mother, milestone, model.bindToTestCases(), copyAllPerimeter);
            this.addMilestone(milestone);
            return milestone.getId();
        }
        throw new IllegalArgumentException(String.format("%s %s %s", "The milestone status: ", mother.getStatus().name(), " does not allow milestone duplication operation."));
    }

    @Override
    public void migrateMilestones(MilestoneHolder member) {
        List projectMilestones = member.getProject().getMilestones();
        Set memberMilestones = member.getMilestones();
        Iterator memberIterator = memberMilestones.iterator();
        while (memberIterator.hasNext()) {
            Milestone m = (Milestone)memberIterator.next();
            if (projectMilestones.contains(m)) continue;
            memberIterator.remove();
        }
    }

    private void bindProjectsAndPerimeter(Milestone mother, Milestone milestone, boolean copyAllPerimeter) {
        if (copyAllPerimeter) {
            milestone.bindProjects(mother.getProjects());
            milestone.addProjectsToPerimeter(mother.getPerimeter());
        } else {
            ArrayList projects = new ArrayList(mother.getProjects());
            projects.retainAll(this.projectFinder.findAllICanManage());
            ArrayList perim = new ArrayList(mother.getPerimeter());
            perim.retainAll(this.projectFinder.findAllICanManage());
            milestone.bindProjects(projects);
            milestone.addProjectsToPerimeter(perim);
        }
    }

    private void bindTestCases(Milestone mother, Milestone milestone, boolean bindToTestCases, boolean copyAllPerimeter) {
        if (bindToTestCases) {
            for (TestCase tc : mother.getTestCases()) {
                if (!copyAllPerimeter && !this.canIManageThisProject((GenericProject)tc.getProject())) continue;
                milestone.bindTestCase(tc);
            }
        }
    }

    private void bindRequirements(Milestone mother, Milestone milestone, boolean bindToRequirements, boolean copyAllPerimeter) {
        if (bindToRequirements) {
            for (RequirementVersion req : mother.getRequirementVersions()) {
                if (!copyAllPerimeter && !this.canIManageThisProject((GenericProject)req.getProject())) continue;
                milestone.bindRequirementVersion(req);
            }
        }
    }

    @Override
    public void synchronize(long sourceId, long targetId, boolean extendPerimeter, boolean isUnion) {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        Milestone source = this.findById(sourceId);
        Milestone target = this.findById(targetId);
        this.verifyCanSynchronize(source, target, isUnion);
        this.synchronizePerimeterAndProjects(source, target, extendPerimeter, isUnion);
        this.synchronizeTestCases(source, target, isUnion, extendPerimeter);
        this.synchronizeRequirementVersions(source, target, isUnion, extendPerimeter);
    }

    private void verifyCanSynchronize(Milestone source, Milestone target, boolean isUnion) {
        boolean isNotAdmin;
        boolean bl = isNotAdmin = !this.permissionEvaluationService.hasRole("ROLE_ADMIN");
        if (isUnion && (!source.getStatus().isBindableToObject() || isNotAdmin && this.isGlobal(source))) {
            throw new IllegalArgumentException("milestone can't be synchronized because it's status or range don't allow it");
        }
        if (!target.getStatus().isBindableToObject() || isNotAdmin && this.isGlobal(target)) {
            throw new IllegalArgumentException("milestone can't be synchronized because it's status or range don't allow it");
        }
    }

    private void synchronizeRequirementVersions(Milestone source, Milestone target, boolean isUnion, boolean extendPerimeter) {
        this.milestoneDao.synchronizeRequirementVersions(source.getId(), target.getId(), this.getProjectsToSynchronize(source, target, extendPerimeter, isUnion));
        if (isUnion) {
            this.milestoneDao.synchronizeRequirementVersions(target.getId(), source.getId(), this.getProjectsToSynchronize(target, source, extendPerimeter, isUnion));
        }
    }

    private void synchronizeTestCases(Milestone source, Milestone target, boolean isUnion, boolean extendPerimeter) {
        this.milestoneDao.synchronizeTestCases(source.getId(), target.getId(), this.getProjectsToSynchronize(source, target, extendPerimeter, isUnion));
        if (isUnion) {
            this.milestoneDao.synchronizeTestCases(target.getId(), source.getId(), this.getProjectsToSynchronize(target, source, extendPerimeter, isUnion));
        }
    }

    private Set<GenericProject> getProjectsToSynchronizeForProjectManager(Set<GenericProject> result, Milestone target, boolean extendPerimeter) {
        if (extendPerimeter && this.isCreatedBySelf(target)) {
            result.addAll(target.getPerimeter());
        } else {
            result.retainAll(target.getPerimeter());
            if (!this.isCreatedBySelf(target)) {
                result.retainAll(this.getProjectICanManage(result));
            }
        }
        return result;
    }

    private List<Long> getProjectsToSynchronize(Milestone source, Milestone target, boolean extendPerimeter, boolean isUnion) {
        HashSet<GenericProject> result = new HashSet<GenericProject>(source.getPerimeter());
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            this.getProjectsToSynchronizeForProjectForAdmin(result, source, target, isUnion);
        } else {
            this.getProjectsToSynchronizeForProjectManager(result, target, extendPerimeter);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (GenericProject p : result) {
            ids.add(p.getId());
        }
        return ids;
    }

    private Set<GenericProject> getProjectsToSynchronizeForProjectForAdmin(Set<GenericProject> result, Milestone source, Milestone target, boolean isUnion) {
        if (isUnion && this.isGlobal(source) && this.isGlobal(target) || !isUnion && this.isGlobal(target)) {
            result.addAll(target.getPerimeter());
        } else {
            result.retainAll(target.getPerimeter());
        }
        return result;
    }

    private void adminSynchronizePerimeterAndProjects(Milestone source, Milestone target, boolean isUnion) {
        if (isUnion) {
            this.adminSynchronizePerimeterAndProjectsForUnion(source, target);
        } else {
            this.adminSynchronizePerimeterAndProjects(source, target);
        }
    }

    private void adminSynchronizePerimeterAndProjectsForUnion(Milestone source, Milestone target) {
        if (this.isGlobal(source) && this.isGlobal(target)) {
            this.adminSynchronizePerimeterAndProjects(source, target);
            this.adminSynchronizePerimeterAndProjects(target, source);
        }
    }

    private void adminSynchronizePerimeterAndProjects(Milestone source, Milestone target) {
        if (this.isGlobal(target)) {
            target.bindProjects(source.getProjects());
            target.addProjectsToPerimeter(source.getPerimeter());
        }
    }

    private void projectManagerSynchronizePerimeterAndProjects(Milestone source, Milestone target, boolean extendPerimeter) {
        if (this.isCreatedBySelf(target) && extendPerimeter) {
            target.bindProjects(source.getProjects());
            target.addProjectsToPerimeter(source.getPerimeter());
        }
    }

    private void synchronizePerimeterAndProjects(Milestone source, Milestone target, boolean extendPerimeter, boolean isUnion) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            this.adminSynchronizePerimeterAndProjects(source, target, isUnion);
        } else {
            this.projectManagerSynchronizePerimeterAndProjects(source, target, extendPerimeter);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void enableFeature() {
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void disableFeature() {
        LOGGER.info("Disabling the Milestones feature: all milestones are going to be deleted from database", new Object[0]);
        this.milestoneDao.performBatchUpdate(new CustomMilestoneDao.HolderConsumer(){

            @Override
            public void consume(MilestoneHolder holder) {
                holder.unbindAllMilestones();
            }
        });
        Session session = (Session)this.em.unwrap(Session.class);
        List milestones = session.createQuery("from Milestone").list();
        for (Milestone milestone : milestones) {
            milestone.unbindAllProjects();
            milestone.clearPerimeter();
            session.delete((Object)milestone);
        }
    }

    @Override
    public boolean isBoundToAtleastOneObject(long milestoneId) {
        return this.milestoneDao.isBoundToAtleastOneObject(milestoneId);
    }

    @Override
    public void unbindAllObjects(long milestoneId) {
        this.milestoneDao.unbindAllObjects(milestoneId);
        Milestone milestone = this.findById(milestoneId);
        milestone.clearObjects();
    }

    @Override
    @Transactional(readOnly=true)
    public Milestone findByName(String name) {
        return this.milestoneDao.findByName(name);
    }

    @Override
    public boolean isMilestoneBoundToOneObjectOfProject(Milestone milestone, GenericProject project) {
        return this.milestoneDao.isMilestoneBoundToOneObjectOfProject(milestone.getId(), project.getId());
    }

    @Override
    public boolean hasMilestone(List<Long> userdIds) {
        long result = this.milestoneDao.countMilestonesForUsers(userdIds);
        return result > 0L;
    }

    @Override
    public boolean canManageMilestonesOrAdmin(Collection<Long> milestoneIds) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.canManageMilestonesOrAdminWithUserDto(milestoneIds, currentUser);
    }

    private boolean canManageMilestonesOrAdminWithUserDto(Collection<Long> milestoneIds, UserDto userDto) {
        if (userDto.isAdmin()) {
            return true;
        }
        List<Long> manageableProjectIds = this.projectFinder.findAllMilestoneManageableIds(userDto);
        if (manageableProjectIds.isEmpty()) {
            return false;
        }
        return this.milestoneDisplayDao.areAllMilestoneGlobalOrInOneManageableProjectPerimeterOrOwner(milestoneIds, manageableProjectIds, userDto.getUserId());
    }

    @Override
    public void checkIfCanManageMilestonesOrAdmin(Collection<Long> milestoneIds) {
        if (!this.canManageMilestonesOrAdmin(milestoneIds)) {
            throw new AccessDeniedException(HttpStatus.FORBIDDEN.getReasonPhrase());
        }
    }
}

