/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.service.internal.library.PathService;

@Service
@Transactional(readOnly=true)
public class HibernatePathService
implements PathService {
    public static final String PATH_SEPARATOR = "\u001f";
    @PersistenceContext
    private EntityManager em;

    private Session currentSession() {
        return (Session)this.em.unwrap(Session.class);
    }

    @Override
    public String buildTestCasePath(long id) {
        return this.buildPath("TestCasePathEdge.findPathById", id);
    }

    @Override
    public List<String> buildTestCasesPaths(List<Long> ids) {
        return this.buildAllPaths("TestCasePathEdge.findPathsByIds", ids);
    }

    @Override
    public String buildTestCaseFoldersPath(long id) {
        return this.buildPath("TestCasePathEdge.findFoldersPathById", id);
    }

    @Override
    @UsedInPlugin(value="API")
    public @UsedInPlugin(value="API") String buildRequirementPath(long id) {
        return this.buildPath("RequirementPathEdge.findPathById", id);
    }

    @Override
    public List<String> buildRequirementsPaths(List<Long> ids) {
        return this.buildAllPaths("RequirementPathEdge.findPathsByIds", ids);
    }

    @Override
    @UsedInPlugin(value="API")
    public @UsedInPlugin(value="API") String buildCampaignPath(long id) {
        return this.buildPath("CampaignPathEdge.findPathById", id);
    }

    public static String escapePath(String fetchedPath) {
        return fetchedPath != null ? fetchedPath.replace("/", "\\/").replace(PATH_SEPARATOR, "/") : null;
    }

    public static String substituteSpecialPathSeparator(String path) {
        return path != null ? path.replace(PATH_SEPARATOR, "/") : null;
    }

    private String buildPath(String queryname, long id) {
        List<String> paths = this.findPathById(queryname, id);
        if (paths.isEmpty()) {
            return null;
        }
        return HibernatePathService.escapePath(paths.get(0));
    }

    private List<String> buildAllPaths(String queryname, List<Long> ids) {
        if (ids.isEmpty()) {
            return new ArrayList<String>();
        }
        List<Object[]> paths = this.findPathsByIds(queryname, ids);
        String[] res = new String[ids.size()];
        for (Object[] path : paths) {
            int pos = ids.indexOf(path[0]);
            res[pos] = HibernatePathService.escapePath((String)path[1]);
        }
        return Arrays.asList(res);
    }

    private List<String> findPathById(String queryname, long id) {
        Query query = this.currentSession().getNamedQuery(queryname);
        query.setParameter("nodeId", (Object)id);
        return query.list();
    }

    private List<Object[]> findPathsByIds(String queryname, List<Long> ids) {
        Query query = this.currentSession().getNamedQuery(queryname);
        query.setParameterList("nodeIds", ids);
        return query.list();
    }
}

