/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution.automatedexecution;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.ExecutionFlag;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFlagService;
import org.squashtest.tm.service.internal.dto.AutomatedExecutionUpdateData;
import org.squashtest.tm.service.internal.repository.AutomatedExecutionExtenderDao;
import org.squashtest.tm.service.internal.repository.CustomAutomatedExecExtenderDao;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;

@Service
@Transactional
public class AutomatedExecutionFlagServiceImpl
implements AutomatedExecutionFlagService {
    private static final int RECENT_EXTENDER_ID_LIMIT = 10;
    private final AutomatedExecutionExtenderDao automatedExecutionDao;
    private final CustomAutomatedExecExtenderDao customAutomatedExecExtenderDao;
    private final PluginFinderService pluginFinderService;

    public AutomatedExecutionFlagServiceImpl(AutomatedExecutionExtenderDao automatedExecutionDao, CustomAutomatedExecExtenderDao customAutomatedExecExtenderDao, PluginFinderService pluginFinderService) {
        this.automatedExecutionDao = automatedExecutionDao;
        this.customAutomatedExecExtenderDao = customAutomatedExecExtenderDao;
        this.pluginFinderService = pluginFinderService;
    }

    @Override
    public void updateFlag(long executionExtenderId, ExecutionFlag flag) {
        AutomatedExecutionExtender extender;
        if (this.pluginFinderService.isPremiumPluginInstalled() && (extender = this.automatedExecutionDao.findById(executionExtenderId)) != null) {
            extender.setFlag(flag);
            this.automatedExecutionDao.save(extender);
        }
    }

    @Override
    public void handleFlagReset(long extenderId) {
        if (this.pluginFinderService.isPremiumPluginInstalled() && this.areAllFailureDetailLinked(extenderId)) {
            this.updateFlag(extenderId, null);
        }
    }

    @Override
    public void updateExecutionFlag(AutomatedExecutionState stateChange, AutomatedExecutionUpdateData updater) {
        org.squashtest.tm.api.testautomation.execution.dto.ExecutionStatus status = stateChange.getTfTestExecutionStatus().getStatus();
        long extenderId = updater.extenderId();
        if (org.squashtest.tm.api.testautomation.execution.dto.ExecutionStatus.FAILURE.equals((Object)status) && this.isAnyFailureDetailUnlinked(extenderId)) {
            this.updateFlag(extenderId, this.isExecutionFlaky(extenderId) ? ExecutionFlag.FLAKY : ExecutionFlag.TO_BE_ANALYSED);
        } else if (org.squashtest.tm.api.testautomation.execution.dto.ExecutionStatus.SUCCESS.equals((Object)status) && this.isLastExecutionFailureWithFailureDetailIssue(extenderId)) {
            this.updateFlag(extenderId, ExecutionFlag.FIXED);
        }
    }

    private boolean isAnyFailureDetailUnlinked(long extenderId) {
        return !this.customAutomatedExecExtenderDao.areAllFailureDetailLinkedToIssueByExtenderId(extenderId);
    }

    private boolean areAllFailureDetailLinked(long extenderId) {
        return this.customAutomatedExecExtenderDao.areAllFailureDetailLinkedToIssueByExtenderId(extenderId);
    }

    private boolean isAnyFailureDetailLinked(long extenderId) {
        return this.customAutomatedExecExtenderDao.isAnyFailureDetailLinkedToIssueByExtenderId(extenderId);
    }

    @Override
    public void updateToBeAnalysedFlag(List<Long> extenderIds) {
        if (this.pluginFinderService.isPremiumPluginInstalled()) {
            Map<Long, Boolean> isAnyFailureDetailUnlinkedMap = this.customAutomatedExecExtenderDao.getSomeFailureDetailDoesNotHaveIssueByExtenderId(extenderIds);
            for (Long extenderId : extenderIds) {
                if (!isAnyFailureDetailUnlinkedMap.get(extenderId).booleanValue()) continue;
                this.updateFlag(extenderId, ExecutionFlag.TO_BE_ANALYSED);
            }
        }
    }

    private boolean isExecutionFlaky(long extenderId) {
        List<Long> recentExtenderIds = this.customAutomatedExecExtenderDao.findRecentExtenderIdsByExtenderId(extenderId, 10);
        Map<Long, Boolean> isAnyFailureDetailLinkedMap = this.customAutomatedExecExtenderDao.getAnyFailureDetailHasIssueByExtenderIds(recentExtenderIds);
        if (this.isFlakyByDifferentFailureDetail(recentExtenderIds)) {
            return true;
        }
        for (Long recentExtenderId : recentExtenderIds) {
            if (!isAnyFailureDetailLinkedMap.get(recentExtenderId).booleanValue()) continue;
            return false;
        }
        return this.isFlakyByDifferentStatus(recentExtenderIds);
    }

    private boolean isFlakyByDifferentStatus(List<Long> recentExtenderIds) {
        Map<Long, ExecutionStatus> executionStatuses = this.customAutomatedExecExtenderDao.findExecutionStatusesByExtenderIds(recentExtenderIds);
        if (executionStatuses == null || executionStatuses.isEmpty()) {
            return false;
        }
        return this.isStatusTransitionDetected(executionStatuses);
    }

    private boolean isStatusTransitionDetected(Map<Long, ExecutionStatus> executionStatuses) {
        ExecutionStatus previousStatus = null;
        int count = 0;
        for (Map.Entry<Long, ExecutionStatus> entry : executionStatuses.entrySet()) {
            ExecutionStatus currentStatus = entry.getValue();
            if (previousStatus != null) {
                count += this.transitionCount(previousStatus, currentStatus);
            }
            previousStatus = currentStatus;
            if (count <= true) continue;
            return true;
        }
        return false;
    }

    private int transitionCount(ExecutionStatus previousStatus, ExecutionStatus currentStatus) {
        if (previousStatus == ExecutionStatus.SUCCESS && currentStatus == ExecutionStatus.FAILURE || previousStatus == ExecutionStatus.FAILURE && currentStatus == ExecutionStatus.SUCCESS) {
            return 1;
        }
        return 0;
    }

    private boolean isFlakyByDifferentFailureDetail(List<Long> recentExtenderIds) {
        Map<Long, List<Long>> failureDetailIdsMap = this.customAutomatedExecExtenderDao.findFailureDetailIdsByExtenderIds(recentExtenderIds);
        if (failureDetailIdsMap != null && !failureDetailIdsMap.isEmpty()) {
            List<Long> baseList = failureDetailIdsMap.values().iterator().next();
            for (List<Long> detailList : failureDetailIdsMap.values()) {
                if (baseList.equals(detailList)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLastExecutionFailureWithFailureDetailIssue(long extenderId) {
        Long lastExtenderId = this.customAutomatedExecExtenderDao.findLastExtenderIdByExtenderId(extenderId);
        if (lastExtenderId != null) {
            String lastStatus = this.customAutomatedExecExtenderDao.findExecutionStatusByExtenderId(lastExtenderId);
            return ExecutionStatus.FAILURE.name().equals(lastStatus) && this.isAnyFailureDetailLinked(lastExtenderId);
        }
        return false;
    }
}

