/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.execution.ConsumerForExploratoryExecution;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.jooq.domain.tables.ItemTestPlanList;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.SprintExecutionCreationService;
import org.squashtest.tm.service.campaign.SprintTestPlanItemManagerService;
import org.squashtest.tm.service.execution.ExploratorySessionOverviewModificationService;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.security.UserContextService;

@Service(value="squashtest.tm.service.ExploratorySessionOverviewModificationService")
@Transactional
public class ExploratorySessionOverviewModificationServiceImpl
implements ExploratorySessionOverviewModificationService {
    private static final String EXECUTE_OVERVIEW_OR_ADMIN = "hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')";
    private final DSLContext dslContext;
    private final IterationModificationService iterationModificationService;
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final MilestoneDao milestoneDao;
    private final UserDao userDao;
    private final UserContextService userContextService;
    private final SprintExecutionCreationService sprintExecutionCreationService;
    private final SprintTestPlanItemManagerService sprintTestPlanItemManagerService;
    private final SprintDisplayDao sprintDisplayDao;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    @PersistenceContext
    private EntityManager entityManager;

    public ExploratorySessionOverviewModificationServiceImpl(DSLContext dslContext, IterationModificationService iterationModificationService, IterationTestPlanManagerService iterationTestPlanManagerService, MilestoneDao milestoneDao, UserDao userDao, UserContextService userContextService, SprintExecutionCreationService sprintExecutionCreationService, SprintTestPlanItemManagerService sprintTestPlanItemManagerService, SprintDisplayDao sprintDisplayDao, CustomTestSuiteModificationService customTestSuiteModificationService) {
        this.dslContext = dslContext;
        this.iterationModificationService = iterationModificationService;
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.milestoneDao = milestoneDao;
        this.userDao = userDao;
        this.userContextService = userContextService;
        this.sprintExecutionCreationService = sprintExecutionCreationService;
        this.sprintTestPlanItemManagerService = sprintTestPlanItemManagerService;
        this.sprintDisplayDao = sprintDisplayDao;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void updateDueDate(Long overviewId, Date dueDate) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.updateDueDate(dueDate);
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void updateExecutionStatus(Long overviewId, String executionStatus) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        IterationTestPlanItem iterationTestPlanItem = exploratorySessionOverview.getIterationTestPlanItem();
        if (iterationTestPlanItem != null) {
            iterationTestPlanItem.setExecutionStatus(ExecutionStatus.valueOf((String)executionStatus));
            iterationTestPlanItem.setLastExecutedBy(this.userContextService.getUsername());
            iterationTestPlanItem.setLastExecutedOn(new Date());
            iterationTestPlanItem.updateLastModificationWithCurrentUser();
            List testSuitesToUpdate = iterationTestPlanItem.getTestSuites();
            this.customTestSuiteModificationService.updateExecutionStatus(testSuitesToUpdate);
        } else {
            User user = this.getCurrentUser();
            exploratorySessionOverview.getTestPlanItem().applyFastPass(ExecutionStatus.valueOf((String)executionStatus), user);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void updateSessionDuration(Long overviewId, Integer sessionDuration) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.updateSessionDuration(sessionDuration);
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public ExploratoryExecution addNewExecution(Long overviewId) {
        Execution execution;
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        IterationTestPlanItem iterationTestPlanItem = exploratorySessionOverview.getIterationTestPlanItem();
        if (iterationTestPlanItem != null) {
            execution = this.iterationModificationService.addManualExecution(iterationTestPlanItem.getId());
            iterationTestPlanItem.updateLastModificationWithCurrentUser();
            this.updateExploratoryExecutionInfoFromSessionOverview(execution, exploratorySessionOverview);
        } else {
            execution = this.sprintExecutionCreationService.createExecution(exploratorySessionOverview.getTestPlanItem().getId());
        }
        AtomicReference exploratoryExecution = new AtomicReference();
        ConsumerForExploratoryExecution consumer = new ConsumerForExploratoryExecution(exploratoryExecution::set);
        execution.accept((ExecutionVisitor)consumer);
        return (ExploratoryExecution)exploratoryExecution.get();
    }

    private void updateExploratoryExecutionInfoFromSessionOverview(Execution execution, ExploratorySessionOverview exploratorySessionOverview) {
        execution.setName(this.buildExecutionName(exploratorySessionOverview));
        execution.setReference(exploratorySessionOverview.getReference());
    }

    private String buildExecutionName(ExploratorySessionOverview exploratorySessionOverview) {
        if (exploratorySessionOverview.getReference().isEmpty()) {
            return exploratorySessionOverview.getName();
        }
        return String.valueOf(exploratorySessionOverview.getReference()) + " - " + exploratorySessionOverview.getName();
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void startSessionAndUpdateExecutionStatus(Long overviewId) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.startSession(this.getCurrentUser());
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void endSession(Long overviewId) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.endSession();
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void updateComments(Long overviewId, String comments) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        exploratorySessionOverview.updateComments(comments);
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void deleteExecutions(Long overviewId, List<Long> executionIds) {
        ExploratorySessionOverview exploratorySessionOverview = (ExploratorySessionOverview)this.entityManager.find(ExploratorySessionOverview.class, (Object)overviewId);
        this.checkBlockingMilestoneOrClosedSprint(exploratorySessionOverview);
        Long iterationId = this.findIterationId(overviewId);
        if (iterationId != null) {
            this.iterationTestPlanManagerService.removeExecutionsFromTestPlanItem(executionIds, iterationId);
            exploratorySessionOverview.getIterationTestPlanItem().updateLastModificationWithCurrentUser();
        } else {
            Long testPlanItemId = exploratorySessionOverview.getTestPlanItem().getId();
            this.sprintTestPlanItemManagerService.deleteExecutionsAndRemoveFromTestPlanItem(executionIds, testPlanItemId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#overviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void addExecutionsWithUsers(Long overviewId, List<Long> userIds) {
        List users = this.userDao.findAllById(userIds);
        users.forEach(user -> this.addNewExecutionWithAssignee(overviewId, (User)user));
    }

    private void addNewExecutionWithAssignee(Long overviewId, User user) {
        ExploratoryExecution exploratoryExecution = this.addNewExecution(overviewId);
        exploratoryExecution.setAssigneeUser(user);
    }

    private void checkBlockingMilestoneOrClosedSprint(ExploratorySessionOverview overview) {
        IterationTestPlanItem item = overview.getIterationTestPlanItem();
        if (item != null && this.milestoneDao.isIterationTestPlanItemBoundToBlockingMilestone(item.getId())) {
            throw new MilestoneForbidModificationException("This test plan item is linked to a blocking milestone and cannot be modified.");
        }
        if (SprintStatus.CLOSED.equals((Object)this.sprintDisplayDao.getSprintStatusBySessionOverviewId(overview.getId()))) {
            throw new SprintClosedException();
        }
    }

    private Long findIterationId(Long sessionOverviewId) {
        return (Long)this.dslContext.select((SelectField)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID).from((TableLike)ItemTestPlanList.ITEM_TEST_PLAN_LIST).join((TableLike)org.squashtest.tm.jooq.domain.tables.ExploratorySessionOverview.EXPLORATORY_SESSION_OVERVIEW).on(org.squashtest.tm.jooq.domain.tables.ExploratorySessionOverview.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID.eq((Field)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).where(org.squashtest.tm.jooq.domain.tables.ExploratorySessionOverview.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)sessionOverviewId)).fetchOneInto(Long.class);
    }

    private User getCurrentUser() {
        String username = this.userContextService.getUsername();
        return this.userDao.findUserByLogin(username);
    }
}

