/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.event;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.event.RequirementAuditEventVisitor;
import org.squashtest.tm.domain.event.RequirementCreation;
import org.squashtest.tm.domain.event.RequirementLargePropertyChange;
import org.squashtest.tm.domain.event.RequirementPropertyChange;
import org.squashtest.tm.domain.event.RequirementVersionModification;
import org.squashtest.tm.domain.event.SyncRequirementCreation;
import org.squashtest.tm.domain.event.SyncRequirementUpdate;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.event.RequirementAuditor;

@Service
public class StatusBasedRequirementAuditor
implements RequirementAuditor,
RequirementAuditEventVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusBasedRequirementAuditor.class);
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public void notify(RequirementAuditEvent event) {
        event.accept((RequirementAuditEventVisitor)this);
    }

    public void visit(RequirementCreation event) {
        this.entityManager.persist((Object)event);
        this.logEvent(event);
    }

    private void logEvent(RequirementCreation event) {
        LOGGER.trace("Requirement was created", new Object[]{event});
    }

    public void visit(RequirementPropertyChange event) {
        if (this.shouldAuditModification((RequirementVersionModification)event)) {
            this.entityManager.persist((Object)event);
            this.logEvent();
        }
    }

    private void logEvent() {
        LOGGER.trace("Requirement was modified", new Object[0]);
    }

    private boolean shouldAuditModification(RequirementVersionModification event) {
        if ("status".equals(event.getPropertyName())) {
            return true;
        }
        return RequirementStatus.UNDER_REVIEW == event.getRequirementVersion().getStatus();
    }

    public void visit(RequirementLargePropertyChange event) {
        if (this.shouldAuditModification((RequirementVersionModification)event)) {
            this.entityManager.persist((Object)event);
            this.logEvent();
        }
    }

    public void visit(SyncRequirementCreation event) {
    }

    public void visit(SyncRequirementUpdate event) {
    }
}

