/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.entity.testcaseworkspace;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jooq.tools.StringUtils;

public class TreeFolder {
    private final Set<TreeFolder> children = new LinkedHashSet<TreeFolder>();
    private final String data;
    private final String fullPath;
    private final boolean rootFolder;
    private Integer id;
    private Integer parentId;

    public TreeFolder() {
        this.data = "";
        this.fullPath = "";
        this.rootFolder = true;
    }

    public TreeFolder(String data, String fullPath, boolean rootFolder, Integer id, Integer parentId) {
        this.data = data;
        this.fullPath = fullPath;
        this.rootFolder = rootFolder;
        this.parentId = parentId;
        this.id = id;
    }

    public TreeFolder child(String data, AtomicInteger idGenerator) {
        for (TreeFolder child : this.children) {
            if (!child.data.equals(data)) continue;
            return child;
        }
        return this.child(new TreeFolder(data, String.format("%s/%s", this.fullPath, data), StringUtils.isEmpty((String)this.fullPath), idGenerator.incrementAndGet(), this.id));
    }

    private TreeFolder child(TreeFolder child) {
        this.children.add(child);
        return child;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public boolean isRootFolder() {
        return this.rootFolder;
    }

    public Set<TreeFolder> getChildren() {
        return this.children;
    }

    public String getData() {
        return this.data;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

