/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.dto.InputTypeModel;

@Component
public class CustomFieldModelFactory {
    @Inject
    private MessageSource messageSource;

    InputTypeModel createInputTypeModel(InputType type) {
        InputTypeModel model = new InputTypeModel();
        model.setEnumName(type.toString());
        model.setFriendlyName(this.getMessage(type.getI18nKey()));
        return model;
    }

    CustomFieldModel<?> createCustomFieldModel(CustomField customField) {
        return switch (customField.getInputType()) {
            case InputType.DATE_PICKER -> this.createDatePickerFieldModel(customField);
            case InputType.DROPDOWN_LIST -> this.createSingleSelectFieldModel((SingleSelectField)customField);
            case InputType.TAG -> this.createMultiSelectFieldModel((MultiSelectField)customField);
            default -> this.createCustomField(customField);
        };
    }

    CustomFieldModel<?> createCustomFieldModel(DenormalizedFieldValue customField) {
        return switch (customField.getInputType()) {
            case InputType.DATE_PICKER -> this.createDatePickerFieldModel(customField);
            default -> this.createCustomField(customField);
        };
    }

    private CustomFieldModel<?> createCustomField(CustomField customField) {
        SingleValuedCustomFieldModel model = new SingleValuedCustomFieldModel();
        this.populateCustomFieldModel(model, customField);
        ((CustomFieldModel)model).setDefaultValue(customField.getDefaultValue());
        return model;
    }

    private CustomFieldModel<?> createSingleSelectFieldModel(SingleSelectField customField) {
        SingleSelectFieldModel model = new SingleSelectFieldModel();
        this.populateCustomFieldModel(model, (CustomField)customField);
        model.setDefaultValue(customField.getDefaultValue());
        for (CustomFieldOption option : customField.getOptions()) {
            CustomFieldOptionModel newOption = new CustomFieldOptionModel();
            newOption.setLabel(option.getLabel());
            newOption.setCode(option.getCode());
            model.addOption(newOption);
        }
        return model;
    }

    private CustomFieldModel<?> createDatePickerFieldModel(CustomField field) {
        Locale locale = LocaleContextHolder.getLocale();
        DatePickerFieldModel model = new DatePickerFieldModel();
        this.populateCustomFieldModel(model, field);
        model.setDefaultValue(field.getDefaultValue());
        model.setFormat(this.getMessage("squashtm.dateformatShort.datepicker"));
        model.setLocale(locale.toString());
        return model;
    }

    private CustomFieldModel<?> createMultiSelectFieldModel(MultiSelectField field) {
        MultiSelectFieldModel model = new MultiSelectFieldModel();
        this.populateCustomFieldModel(model, (CustomField)field);
        for (CustomFieldOption option : field.getOptions()) {
            CustomFieldOptionModel newOption = new CustomFieldOptionModel();
            newOption.setLabel(option.getLabel());
            newOption.setCode(option.getCode());
            model.addOption(newOption);
        }
        String[] stringArray = field.getDefaultValue().split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            model.addDefaultValue(value);
            ++n2;
        }
        return model;
    }

    private <VT> CustomFieldModel<VT> populateCustomFieldModel(CustomFieldModel<VT> model, CustomField field) {
        InputTypeModel typeModel = this.createInputTypeModel(field.getInputType());
        model.setId(field.getId());
        model.setName(field.getName());
        model.setLabel(field.getLabel());
        model.setOptional(field.isOptional());
        model.setInputType(typeModel);
        model.setFriendlyOptional(field.isOptional() ? this.getMessage("label.Yes") : this.getMessage("label.No"));
        model.setCode(field.getCode());
        return model;
    }

    private CustomFieldModel<?> createCustomField(DenormalizedFieldValue customField) {
        SingleValuedCustomFieldModel model = new SingleValuedCustomFieldModel();
        this.populateCustomFieldModel(model, customField);
        return model;
    }

    private CustomFieldModel<?> createDatePickerFieldModel(DenormalizedFieldValue field) {
        Locale locale = LocaleContextHolder.getLocale();
        DatePickerFieldModel model = new DatePickerFieldModel();
        this.populateCustomFieldModel(model, field);
        model.setFormat(this.getMessage("squashtm.dateformatShort.datepicker"));
        model.setLocale(locale.toString());
        return model;
    }

    private <VT> CustomFieldModel<VT> populateCustomFieldModel(CustomFieldModel<VT> customFieldModel, DenormalizedFieldValue value) {
        InputTypeModel inputTypeModel = new InputTypeModel();
        inputTypeModel.setEnumName(value.getInputType().name());
        inputTypeModel.setFriendlyName(value.getInputType().name());
        customFieldModel.setCode(value.getCode());
        customFieldModel.setId(value.getId());
        customFieldModel.setInputType(inputTypeModel);
        customFieldModel.setLabel(value.getLabel());
        customFieldModel.setOptional(true);
        customFieldModel.setDenormalized(true);
        return customFieldModel;
    }

    private String getMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, null, locale);
    }

    public static class CustomFieldOptionModel {
        private String label;
        private String code;

        public CustomFieldOptionModel() {
        }

        public CustomFieldOptionModel(String label, String code) {
            this.label = label;
            this.code = code;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    public static class DatePickerFieldModel
    extends SingleValuedCustomFieldModel {
        private String format;
        private String locale;

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }
    }

    public static class MultiSelectFieldModel
    extends CustomFieldModel<String[]> {
        private List<String> defaultValue = new LinkedList<String>();
        private Set<CustomFieldOptionModel> options = new HashSet<CustomFieldOptionModel>();

        @Override
        public String[] getDefaultValue() {
            return this.defaultValue.toArray(new String[this.defaultValue.size()]);
        }

        @Override
        public void setDefaultValue(String[] defaultValue) {
            this.defaultValue = new ArrayList<String>(Arrays.asList(defaultValue));
        }

        public void addDefaultValue(String newValue) {
            this.defaultValue.add(newValue);
        }

        public Set<CustomFieldOptionModel> getOptions() {
            return this.options;
        }

        public void setOptions(Set<CustomFieldOptionModel> options) {
            this.options = options;
        }

        public void addOption(CustomFieldOptionModel option) {
            this.options.add(option);
        }
    }

    public static class SingleSelectFieldModel
    extends SingleValuedCustomFieldModel {
        private List<CustomFieldOptionModel> options = new LinkedList<CustomFieldOptionModel>();

        public List<CustomFieldOptionModel> getOptions() {
            return this.options;
        }

        public void setOptions(List<CustomFieldOptionModel> options) {
            this.options = options;
        }

        public void addOption(CustomFieldOptionModel option) {
            this.options.add(option);
        }
    }

    public static class SingleValuedCustomFieldModel
    extends CustomFieldModel<String> {
        private String defaultValue;

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

