/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.workspace.tree;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.jooq.TableField;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.display.workspace.tree.TreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeNodeCollectorService;
import org.squashtest.tm.service.display.workspace.tree.TreeNodeFilterDelegate;
import org.squashtest.tm.service.internal.display.dto.ProjectFilterDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.internal.display.workspace.tree.NoOpTreeNodeFilterDelegateImpl;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.display.ProjectFilterDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeBrowserDao;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.user.UserAccountService;

public abstract class AbstractTreeBrowserImpl
implements TreeBrowser {
    private final TreeNodeCollectorService treeNodeCollectorService;
    private final UserAccountService userAccountService;
    private final CustomProjectFinder projectFinder;
    private final ProjectFilterDisplayDao projectFilterDao;

    protected AbstractTreeBrowserImpl(TreeNodeCollectorService treeNodeCollectorService, UserAccountService userAccountService, CustomProjectFinder projectFinder, ProjectFilterDisplayDao projectFilterDao) {
        this.treeNodeCollectorService = treeNodeCollectorService;
        this.userAccountService = userAccountService;
        this.projectFinder = projectFinder;
        this.projectFilterDao = projectFilterDao;
    }

    protected abstract TreeBrowserDao getTreeBrowserDao();

    @Override
    public TreeGridResponse getInitialTree(NodeWorkspace workspace, Set<NodeReference> openedNodeCandidates, Set<NodeReference> selectedNodes) {
        String libraryClassName = workspace.getLibraryClassName();
        TableField libraryColumnRef = workspace.getColumnRef();
        List<Long> projectIdsByPermission = this.getProjectIdsByPermissionAndClassName(this.getPermissionMask(), libraryClassName, (TableField<ProjectRecord, Long>)libraryColumnRef);
        Set<NodeReference> ancestors = this.getTreeBrowserDao().findAncestors(new NodeReferences(selectedNodes));
        openedNodeCandidates.addAll(ancestors);
        ListMultimap<NodeReference, NodeReference> childrenReferences = this.getTreeBrowserDao().findChildrenReference(openedNodeCandidates);
        Set<NodeReference> nodesToCollect = this.getTreeBrowserDao().findLibraryReferences(workspace, projectIdsByPermission);
        nodesToCollect.addAll(childrenReferences.values());
        nodesToCollect.addAll(ancestors);
        nodesToCollect.addAll(selectedNodes);
        Map<NodeReference, DataRow> rows = this.treeNodeCollectorService.collectNodes(nodesToCollect);
        this.buildNodeHierarchy(openedNodeCandidates, childrenReferences, rows);
        List<DataRow> filteredNodes = rows.values().stream().filter(dataRow -> projectIdsByPermission.contains(dataRow.getProjectId())).sorted(Comparator.comparing(DataRow::getProjectId)).toList();
        TreeGridResponse treeGridResponse = new TreeGridResponse();
        treeGridResponse.setDataRows(filteredNodes);
        return treeGridResponse;
    }

    protected int getPermissionMask() {
        return Permissions.READ.getMask();
    }

    protected void buildNodeHierarchy(Set<NodeReference> openedNodes, ListMultimap<NodeReference, NodeReference> childrenReferences, Map<NodeReference, DataRow> rows) {
        openedNodes.forEach(nodeReference -> {
            if (rows.containsKey(nodeReference)) {
                DataRow openedNode = (DataRow)rows.get(nodeReference);
                openedNode.setState(DataRow.State.open);
                List childrenRef = childrenReferences.get(nodeReference);
                openedNode.setChildren(NodeReference.toNodeIds((Collection)childrenRef));
                childrenRef.forEach(childRef -> ((DataRow)rows.get(childRef)).setParentRowId(nodeReference.toNodeId()));
            }
        });
    }

    @Override
    public TreeGridResponse findSubHierarchy(Set<NodeReference> rootNodes, Set<NodeReference> openedNodeCandidates) {
        return this.findSubHierarchy(rootNodes, openedNodeCandidates, new NoOpTreeNodeFilterDelegateImpl());
    }

    @Override
    public TreeGridResponse findSubHierarchy(Set<NodeReference> rootNodes, Set<NodeReference> openedNodeCandidates, TreeNodeFilterDelegate treeNodeFilterDelegate) {
        ListMultimap<NodeReference, NodeReference> nodesInHierarchy = this.findHierarchy(rootNodes, openedNodeCandidates);
        Set<NodeReference> nodesToCollect = new HashSet<NodeReference>(nodesInHierarchy.values());
        nodesToCollect.addAll(rootNodes);
        nodesToCollect = treeNodeFilterDelegate.applyFiltering(nodesToCollect, rootNodes);
        Map<NodeReference, DataRow> rows = this.treeNodeCollectorService.collectNodes(new HashSet<NodeReference>(nodesToCollect));
        this.buildNodeHierarchy(nodesInHierarchy.keySet(), nodesInHierarchy, rows);
        List<DataRow> filteredNodes = this.filterDataRowByACLAndProjectFilter(rows);
        TreeGridResponse treeGridResponse = new TreeGridResponse();
        treeGridResponse.setDataRows(filteredNodes);
        return treeGridResponse;
    }

    private List<DataRow> filterDataRowByACLAndProjectFilter(Map<NodeReference, DataRow> rows) {
        List<Long> projectIdsByPermission = this.getProjectIdsByPermissionAndClassName(this.getPermissionMask(), Project.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.PROJECT_ID);
        return rows.values().stream().filter(dataRow -> projectIdsByPermission.contains(dataRow.getProjectId())).toList();
    }

    protected List<Long> getProjectIdsByPermissionAndClassName(int permission, String className, TableField<ProjectRecord, Long> libraryColumnField) {
        ProjectFilterDto filter;
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        ArrayList<Long> projectIdsByPermission = new ArrayList();
        if (permission == Permissions.READ.getMask()) {
            projectIdsByPermission = this.projectFinder.findAllReadableIdsByLibraryClassName(currentUser, className, libraryColumnField);
        }
        if (Objects.nonNull(filter = this.projectFilterDao.getProjectFilterByUserLogin(currentUser.getUsername())) && filter.getActivated()) {
            projectIdsByPermission.retainAll(this.projectFilterDao.getProjectIdsByProjectFilter(filter.getId()));
        }
        return projectIdsByPermission;
    }

    private ListMultimap<NodeReference, NodeReference> findHierarchy(Set<NodeReference> rootNodes, Set<NodeReference> openedNodeCandidates) {
        ListMultimap<NodeReference, NodeReference> childrenReferences = this.getTreeBrowserDao().findChildrenReference(openedNodeCandidates);
        Set<NodeReference> nodesInHierarchy = this.findNodeReferenceInHierarchy(rootNodes, childrenReferences);
        ArrayListMultimap multimap = ArrayListMultimap.create();
        nodesInHierarchy.forEach(arg_0 -> AbstractTreeBrowserImpl.lambda$5((ListMultimap)multimap, childrenReferences, arg_0));
        return multimap;
    }

    private Set<NodeReference> findNodeReferenceInHierarchy(Set<NodeReference> rootNodes, ListMultimap<NodeReference, NodeReference> hierarchy) {
        Stack<NodeReference> parents = new Stack<NodeReference>();
        parents.addAll(rootNodes);
        HashSet<NodeReference> nodesInHierarchy = new HashSet<NodeReference>();
        while (!parents.empty()) {
            NodeReference parent = (NodeReference)parents.pop();
            nodesInHierarchy.add(parent);
            if (!hierarchy.containsKey((Object)parent)) continue;
            parents.addAll(hierarchy.get((Object)parent));
        }
        return nodesInHierarchy;
    }

    private static /* synthetic */ void lambda$5(ListMultimap listMultimap, ListMultimap listMultimap2, NodeReference nodeReference) {
        boolean bl = listMultimap.putAll((Object)nodeReference, (Iterable)listMultimap2.get((Object)nodeReference));
    }
}

