/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class RequirementVersionHasParentFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"REQUIREMENT_VERSION_HAS_PARENT"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        HasParentFilterValue filterValue = this.extractFilterValue(filter);
        QRequirement parentRequirement = new QRequirement("parentRequirement");
        QRequirement childRequirement = new QRequirement("childRequirement");
        QRequirementVersion childVersion = new QRequirementVersion("childVersion");
        QRequirementVersion outerVersion = QRequirementVersion.requirementVersion;
        HibernateQuery subquery = (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)parentRequirement)).join((CollectionExpression)parentRequirement.children, (Path)childRequirement)).join((CollectionExpression)childRequirement.versions, (Path)childVersion)).where((Predicate)childVersion.id.eq((Expression)outerVersion.id));
        if (HasParentFilterValue.NO_PARENT.equals((Object)filterValue)) {
            query.where((Predicate)subquery.notExists());
        } else {
            query.where((Predicate)subquery.exists());
        }
    }

    private HasParentFilterValue extractFilterValue(GridFilterValue filter) {
        List<String> values = filter.getValues();
        if (values.size() != 1) {
            throw new IllegalArgumentException("Invalid value for filter REQUIREMENT_VERSION_HAS_PARENT");
        }
        return HasParentFilterValue.valueOf(values.get(0));
    }

    public static enum HasParentFilterValue {
        HAS_PARENT,
        NO_PARENT;

    }
}

