/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.display.search.TestCaseSearchInputData;
import org.squashtest.tm.service.display.search.TestCaseSearchInputDataProvider;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.search.TestCaseSearchInputDataProviderImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.project.ProjectFinder;

@Component
@Transactional(readOnly=true)
public class TestCaseSearchInputDataProviderImpl
implements TestCaseSearchInputDataProvider {
    private ProjectFinder projectFinder;
    private ProjectDao projectDao;
    private UserDao userDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public TestCaseSearchInputDataProviderImpl(ProjectFinder projectFinder, ProjectDao projectDao, UserDao userDao) {
        this.projectFinder = projectFinder;
        this.projectDao = projectDao;
        this.userDao = userDao;
    }

    @Override
    public TestCaseSearchInputData provideTestCaseResearchInputData() {
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIds();
        TestCaseSearchInputData researchInputData = new TestCaseSearchInputData();
        List<UserView> createdUsers = this.findCreatedUserViews(readableProjectIds);
        researchInputData.setUsersWhoCreatedTestCases(createdUsers);
        List<UserView> modifiedUsers = this.findModifiedUserViews(readableProjectIds);
        researchInputData.setUsersWhoModifiedTestCases(modifiedUsers);
        return researchInputData;
    }

    private List<UserView> findCreatedUserViews(List<Long> readableProjectIds) {
        List<String> usersWhoCreatedTestCases = this.projectDao.findUsersWhoCreatedTestCases(readableProjectIds);
        return this.findUserViewsByLogin(usersWhoCreatedTestCases);
    }

    private List<UserView> findModifiedUserViews(List<Long> readableProjectIds) {
        List<String> usersWhoModifiedTestCases = this.projectDao.findUsersWhoModifiedTestCases(readableProjectIds);
        return this.findUserViewsByLogin(usersWhoModifiedTestCases);
    }

    private List<UserView> findUserViewsByLogin(List<String> usersWhoCreatedTestCases) {
        List<String> list = usersWhoCreatedTestCases;
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        TestCaseSearchInputDataProviderImpl$AjcClosure1 testCaseSearchInputDataProviderImpl$AjcClosure1 = new TestCaseSearchInputDataProviderImpl$AjcClosure1(objectArray);
        List users = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testCaseSearchInputDataProviderImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        Map userViews = users.stream().map(user -> {
            UserView userView = new UserView();
            userView.setId(user.getId());
            userView.setFirstName(user.getFirstName());
            userView.setLastName(user.getLastName());
            userView.setLogin(user.getLogin());
            return userView;
        }).collect(Collectors.toMap(UserView::getLogin, Function.identity()));
        return usersWhoCreatedTestCases.stream().map(login -> userViews.getOrDefault(login, new UserView((String)login))).toList();
    }

    static {
        TestCaseSearchInputDataProviderImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findUsersByLoginList_aroundBody0(TestCaseSearchInputDataProviderImpl testCaseSearchInputDataProviderImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginList(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestCaseSearchInputDataProviderImpl.java", TestCaseSearchInputDataProviderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findUsersByLoginList", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "loginList", "", "java.util.List"), 78);
    }
}

