/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.jooq.DSLContext;
import org.jooq.TableField;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.display.search.RequirementSearchService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.AbstractSearchService;
import org.squashtest.tm.service.internal.display.search.HighLevelRequirementScopeExtender;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandlers;
import org.squashtest.tm.service.internal.display.search.filter.FilterValueHandlers;
import org.squashtest.tm.service.internal.repository.ColumnPrototypeDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.query.QueryProcessingService;

@Service
@Transactional(readOnly=true)
public class RequirementSearchServiceImpl
extends AbstractSearchService
implements RequirementSearchService {
    private final HighLevelRequirementScopeExtender highLevelRequirementPerimeterExtender;

    public RequirementSearchServiceImpl(QueryProcessingService queryService, ColumnPrototypeDao columnPrototypeDao, EntityManager entityManager, ProjectFinder projectFinder, FilterHandlers filterHandlers, FilterValueHandlers gridFilterValueHandlers, DSLContext dslContext, HighLevelRequirementScopeExtender highLevelRequirementPerimeterExtender) {
        super(queryService, columnPrototypeDao, entityManager, projectFinder, filterHandlers, gridFilterValueHandlers, dslContext);
        this.highLevelRequirementPerimeterExtender = highLevelRequirementPerimeterExtender;
    }

    @Override
    protected List<String> getIdentifierColumnName() {
        return ImmutableList.of((Object)"REQUIREMENT_VERSION_ID", (Object)"REQUIREMENT_ID");
    }

    @Override
    protected String getDefaultSortColumnName() {
        return "REQUIREMENT_VERSION_ID";
    }

    @Override
    protected EntityType getLibraryEntityType() {
        return EntityType.REQUIREMENT_LIBRARY;
    }

    @Override
    protected TableField<ProjectRecord, Long> getLibraryIdField() {
        return Tables.PROJECT.RL_ID;
    }

    @Override
    protected List<EntityReference> extendScope(List<EntityReference> initialScope, boolean extendedScope) {
        return extendedScope ? this.highLevelRequirementPerimeterExtender.extendScope(initialScope) : initialScope;
    }

    @Override
    public Map<EntityType, List<Long>> getEntityReferenceFromScope(GridRequest request) {
        return this.computeScope(request).stream().collect(Collectors.groupingBy(EntityReference::getType, Collectors.mapping(EntityReference::getId, Collectors.toList())));
    }
}

