/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;

public class TestPlanItemExecutionGrid
extends AbstractGrid {
    private final Long testPlanItemId;

    public TestPlanItemExecutionGrid(Long testPlanItemId) {
        this.testPlanItemId = testPlanItemId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.EXECUTION.EXECUTION_ID), new GridColumn(Tables.EXECUTION.EXECUTION_ORDER.as("EXECUTION_ORDER")), new GridColumn(Tables.PROJECT.PROJECT_ID.as("PROJECT_ID")), new GridColumn(Tables.EXECUTION.EXECUTION_MODE.as("INFERRED_EXECUTION_MODE")), new GridColumn(Tables.EXECUTION.REFERENCE.as("EXECUTION_REFERENCE")), new GridColumn(Tables.EXECUTION.NAME.as("EXECUTION_NAME")), new LevelEnumColumn(TestCaseImportance.class, (Field<String>)Tables.EXECUTION.IMPORTANCE), new GridColumn(Tables.EXECUTION.DATASET_LABEL.as("DATASET_NAME")), new LevelEnumColumn(ExecutionStatus.class, (Field<String>)Tables.EXECUTION.EXECUTION_STATUS), new GridColumn(Tables.EXECUTION.LAST_EXECUTED_BY.as("USER")), new GridColumn((Field<?>)Tables.EXECUTION.LAST_EXECUTED_ON), new GridColumn(this.countIssue().as("ISSUE_COUNT")), new GridColumn(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("TEST_PLAN_ITEM_ID")));
    }

    private Field<Integer> countIssue() {
        return DSL.selectCount().from((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).asField("ISSUE_COUNT");
    }

    @Override
    protected Table<?> getTable() {
        return Tables.EXECUTION.innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY).on(Tables.TEST_PLAN.CL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY.CL_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY.CL_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Object)this.testPlanItemId));
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.EXECUTION.EXECUTION_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.PROJECT.PROJECT_ID;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return Tables.EXECUTION.EXECUTION_ORDER.desc();
    }
}

