/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.util.Locale;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.impl.DSL;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.utils.RequestAliasesConstants;

public final class TestPlanGridHelpers {
    private TestPlanGridHelpers() {
    }

    public static SelectFieldOrAsterisk formatAssigneeFullName() {
        return DSL.when((Condition)Tables.CORE_USER.FIRST_NAME.isNotNull().and(Tables.CORE_USER.FIRST_NAME.notEqual((Object)"")).and(Tables.CORE_USER.ACTIVE.isTrue()), (Field)Tables.CORE_USER.FIRST_NAME.concat(new Field[]{DSL.val((String)" "), Tables.CORE_USER.LAST_NAME, DSL.val((String)" ("), Tables.CORE_USER.LOGIN, DSL.val((String)")")})).when(Tables.CORE_USER.FIRST_NAME.isNotNull().and(Tables.CORE_USER.FIRST_NAME.notEqual((Object)"")).and(Tables.CORE_USER.ACTIVE.isFalse()), Tables.CORE_USER.FIRST_NAME.concat(new Field[]{DSL.val((String)" "), Tables.CORE_USER.LAST_NAME, DSL.val((String)" (not_active)")})).when(Tables.CORE_USER.FIRST_NAME.isNull().and(Tables.CORE_USER.ACTIVE.isTrue()).or(Tables.CORE_USER.FIRST_NAME.eq((Object)"")).and(Tables.CORE_USER.ACTIVE.isTrue()), Tables.CORE_USER.LAST_NAME.concat(new Field[]{DSL.val((String)" ("), Tables.CORE_USER.LOGIN, DSL.val((String)")")})).otherwise(Tables.CORE_USER.LAST_NAME.concat(new Field[]{DSL.val((String)" (not_active)")})).as("ASSIGNEE_FULL_NAME");
    }

    public static void formatDeactivatedUserNameInRowData(DataRow row, MessageSource messageSource) {
        String assigneeFullName = RequestAliasesConstants.toCamelCase("ASSIGNEE_FULL_NAME");
        String rowUserName = (String)row.getData().get(assigneeFullName);
        if (rowUserName != null && rowUserName.contains("(not_active)")) {
            Locale locale = LocaleContextHolder.getLocale();
            String translatedMessage = messageSource.getMessage("administration-workspace.users.manage.deactivated", null, locale).toLowerCase();
            rowUserName = rowUserName.replace("not_active", translatedMessage);
            row.addData(assigneeFullName, rowUserName);
        }
    }

    public static void addTestCasePath(DataRow row, Map<Long, String> testCasePathById) {
        Long rowTestCaseId = (Long)row.getData().get(RequestAliasesConstants.toCamelCase("TEST_CASE_ID"));
        row.addData(RequestAliasesConstants.toCamelCase("TEST_CASE_PATH"), testCasePathById.get(rowTestCaseId));
    }
}

