/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.TestPlanItemRecord;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;

public class SprintOverallExecPlanGrid
extends AbstractTestPlanGrid {
    private final long sprintId;

    public SprintOverallExecPlanGrid(long sprintId, String userToRestrictTo) {
        super(userToRestrictTo);
        this.sprintId = sprintId;
    }

    protected Table<TestPlanItemRecord> getItemTable() {
        return Tables.TEST_PLAN_ITEM;
    }

    protected TableField<TestPlanItemRecord, Long> getItemIdColumn() {
        return Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID;
    }

    protected TableField<TestPlanItemRecord, Long> getAssigneeIdColumn() {
        return Tables.TEST_PLAN_ITEM.ASSIGNEE_ID;
    }

    protected TableField<TestPlanItemRecord, Long> getTestCaseIdColumn() {
        return Tables.TEST_PLAN_ITEM.TCLN_ID;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("TEST_PLAN_ITEM_ID")), new GridColumn(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID")), new GridColumn((Field<?>)Tables.PROJECT.NAME.as("PROJECT_NAME"), (Field<?>)Tables.PROJECT.NAME), new GridColumn((Field<?>)Tables.TEST_CASE.REFERENCE.as("TEST_CASE_REFERENCE"), (Field<?>)Tables.TEST_CASE.REFERENCE), new GridColumn(Tables.TEST_CASE.TCLN_ID.as("TEST_CASE_ID")), new GridColumn((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("TEST_CASE_NAME"), (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME), new LevelEnumColumn(TestCaseImportance.class, "IMPORTANCE"), new LevelEnumColumn(ExecutionStatus.class, "EXECUTION_STATUS"), new GridColumn(Tables.TEST_PLAN_ITEM.ASSIGNEE_ID.as("ASSIGNEE_ID")), new GridColumn(Tables.CORE_USER.LOGIN.as("ASSIGNEE_LOGIN")), new GridColumn(this.getUser().field("ASSIGNEE_FULL_NAME")), new GridColumn((Field<?>)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON), new GridColumn(this.selectLatestExecutionId()), new GridColumn(Tables.DATASET.DATASET_ID.as("DATASET_ID")), new GridColumn((Field<?>)Tables.DATASET.NAME.as("DATASET_NAME"), (Field<?>)Tables.DATASET.NAME), new GridColumn(Objects.requireNonNull(SprintOverallExecPlanGrid.getInferredExecutionMode().field("INFERRED_EXECUTION_MODE")).as("INFERRED_EXECUTION_MODE")), new GridColumn((Field<?>)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID), new GridColumn((Field<?>)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID), new GridColumn(SprintOverallExecPlanGrid.getSprintReqNameWithRef()));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<Record> getUser = this.getUser();
        SelectHavingStep<Record2<Long, String>> getInferredExecutionMode = SprintOverallExecPlanGrid.getInferredExecutionMode();
        return this.getFilteredTableOnAssigneeIfNotExploratory((Table<Record>)Tables.TEST_PLAN_ITEM.leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT.CLN_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.TEST_PLAN_ITEM.ASSIGNEE_ID)).leftJoin(getUser).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(getUser.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin(getInferredExecutionMode).on(Objects.requireNonNull(getInferredExecutionMode.field("TCLN_ID", Long.class)).eq((Field)Tables.TEST_CASE.TCLN_ID)).asTable());
    }

    private static Field<String> getSprintReqNameWithRef() {
        return DSL.when((Condition)Tables.SPRINT_REQ_VERSION.NAME.isNull(), (Field)DSL.when((Condition)Tables.REQUIREMENT_VERSION.REFERENCE.isNull().or(Tables.REQUIREMENT_VERSION.REFERENCE.eq((Object)"")), (Field)Tables.RESOURCE.NAME).otherwise(DSL.concat((Field[])new Field[]{Tables.REQUIREMENT_VERSION.REFERENCE, DSL.inline((String)" - "), Tables.RESOURCE.NAME}))).otherwise(DSL.when((Condition)Tables.SPRINT_REQ_VERSION.REFERENCE.isNull(), (Field)Tables.SPRINT_REQ_VERSION.NAME).otherwise(DSL.concat((Field[])new Field[]{Tables.SPRINT_REQ_VERSION.REFERENCE, DSL.inline((String)" - "), Tables.SPRINT_REQ_VERSION.NAME}))).as("SPRINT_REQ_VERSION_NAME_WITH_REF");
    }

    private static SelectHavingStep<Record2<Long, String>> getInferredExecutionMode() {
        return DSL.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)DSL.when((Condition)Tables.TEST_CASE.EXECUTION_MODE.eq((Object)TestCaseExecutionMode.EXPLORATORY.name()), (Object)TestCaseExecutionMode.EXPLORATORY.name()).otherwise(DSL.when((Condition)Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NONE.name()).or(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.ne((Object)AutomationWorkflowType.NONE.name()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.AUTOMATED.name()))).and(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.jenkins.name()).and(Tables.TEST_CASE.TA_TEST.isNotNull()).or(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name()).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull()).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull()).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()))), (Object)TestCaseExecutionMode.AUTOMATED.name()).otherwise((Object)TestCaseExecutionMode.MANUAL.name())).as("INFERRED_EXECUTION_MODE")).from((TableLike)Tables.TEST_CASE).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID));
    }

    private Field<Long> selectLatestExecutionId() {
        SelectConditionStep selectLatestExecutedOn = DSL.select((SelectField)DSL.max((Field)Tables.EXECUTION.LAST_EXECUTED_ON)).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID));
        return DSL.select((SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.LAST_EXECUTED_ON.eq((Select)selectLatestExecutedOn)).asField("LATEST_EXECUTION_ID");
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"TEST_PLAN_ITEM_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return DSL.field((String)"PROJECT_ID");
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.field((String)"TEST_PLAN_ITEM_ID").asc();
    }

    @Override
    protected Condition craftInvariantFilter() {
        return Tables.SPRINT.CLN_ID.eq((Object)this.sprintId);
    }
}

