/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.squashtest.tm.domain.execution.Execution;

public abstract class TestPlanResume {
    protected Long testPlanItemId;
    protected Long executionId;
    protected Integer initialStepIndex;
    protected boolean hasNextTestCase = false;
    protected List<Long> partialTestPlanItemIds = new ArrayList<Long>();

    protected TestPlanResume(Execution execution, boolean hasNextTestCase) {
        if (Objects.nonNull(execution)) {
            this.executionId = execution.getId();
            this.testPlanItemId = execution.getTestPlan().getId();
            this.hasNextTestCase = hasNextTestCase;
            if (execution.hasUnexecutedSteps()) {
                this.initialStepIndex = execution.getSteps().indexOf(execution.findFirstUnexecutedStep());
            }
        }
    }

    protected TestPlanResume(Execution execution, boolean hasNextTestCase, List<Long> partialTestPlanItemIds) {
        if (Objects.nonNull(execution)) {
            this.executionId = execution.getId();
            this.testPlanItemId = execution.getTestPlan().getId();
            this.hasNextTestCase = hasNextTestCase;
            if (execution.hasUnexecutedSteps()) {
                this.initialStepIndex = execution.getSteps().indexOf(execution.findFirstUnexecutedStep());
            }
            if (Objects.nonNull(partialTestPlanItemIds)) {
                this.partialTestPlanItemIds = partialTestPlanItemIds;
            }
        }
    }

    public Long getTestPlanItemId() {
        return this.testPlanItemId;
    }

    public Long getExecutionId() {
        return this.executionId;
    }

    public boolean isHasNextTestCase() {
        return this.hasNextTestCase;
    }

    public Integer getInitialStepIndex() {
        return this.initialStepIndex;
    }

    public List<Long> getPartialTestPlanItemIds() {
        return this.partialTestPlanItemIds;
    }

    public static class IterationTestPlanResume
    extends TestPlanResume {
        private final Long iterationId;

        public IterationTestPlanResume(Long iterationId, Execution execution, boolean hasNextTestCase) {
            super(execution, hasNextTestCase);
            this.iterationId = Objects.requireNonNull(iterationId);
        }

        public IterationTestPlanResume(Long iterationId, Execution execution, boolean hasNextTestCase, List<Long> partialTestPlanItemIds) {
            super(execution, hasNextTestCase, partialTestPlanItemIds);
            this.iterationId = Objects.requireNonNull(iterationId);
        }

        public Long getIterationId() {
            return this.iterationId;
        }
    }

    public static class TestSuiteTestPlanResume
    extends TestPlanResume {
        private final Long testSuiteId;

        public TestSuiteTestPlanResume(Long testSuiteId, Execution execution, boolean hasNextTestCase) {
            super(execution, hasNextTestCase);
            this.testSuiteId = Objects.requireNonNull(testSuiteId);
        }

        public TestSuiteTestPlanResume(Long testSuiteId, Execution execution, boolean hasNextTestCase, List<Long> partialTestPlanItemIds) {
            super(execution, hasNextTestCase, partialTestPlanItemIds);
            this.testSuiteId = Objects.requireNonNull(testSuiteId);
        }

        public Long getTestSuiteId() {
            return this.testSuiteId;
        }
    }
}

