/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments;

import java.util.List;
import javax.annotation.Nullable;
import org.springframework.lang.NonNull;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.EnvironmentsInfo;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.ProjectInfo;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.ServerInfo;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;

public class EnvironmentSelectionPanelDto {
    private EnvironmentsInfo environments;
    private ServerInfo server;
    private ProjectInfo project;
    private String errorMessage;

    public EnvironmentSelectionPanelDto() {
    }

    public EnvironmentSelectionPanelDto(@NonNull EnvironmentsInfo environments, @NonNull ServerInfo server, @Nullable ProjectInfo project) {
        this.environments = environments;
        this.server = server;
        this.project = project;
    }

    public EnvironmentSelectionPanelDto(EnvironmentsInfo environments, ServerInfo server, ProjectInfo project, String errorMessage) {
        this.environments = environments;
        this.server = server;
        this.project = project;
        this.errorMessage = errorMessage;
    }

    public static EnvironmentSelectionPanelDto forServer(Long testAutomationServerId, List<String> serverTags, List<AutomatedExecutionEnvironment> allAccessibleEnvironments) {
        return new EnvironmentSelectionPanelDto(new EnvironmentsInfo(allAccessibleEnvironments), new ServerInfo(testAutomationServerId, serverTags, true), null);
    }

    public static EnvironmentSelectionPanelDto forServerWithoutCredentials(Long testAutomationServerId) {
        return new EnvironmentSelectionPanelDto(new EnvironmentsInfo(null), new ServerInfo(testAutomationServerId, null, false), null);
    }

    public static EnvironmentSelectionPanelDto forServerWithError(Long testAutomationServerId, List<String> serverTags, String errorMessage) {
        return new EnvironmentSelectionPanelDto(new EnvironmentsInfo(null), new ServerInfo(testAutomationServerId, serverTags, true), null, errorMessage);
    }

    public static EnvironmentSelectionPanelDto forProject(Long testAutomationServerId, List<String> serverTags, boolean hasServerCredentials, List<AutomatedExecutionEnvironment> allAccessibleEnvironments, Long projectId, boolean hasProjectToken, List<String> projectTags, boolean areProjectTagsInherited, String errorMessage) {
        return new EnvironmentSelectionPanelDto(new EnvironmentsInfo(allAccessibleEnvironments), new ServerInfo(testAutomationServerId, serverTags, hasServerCredentials), new ProjectInfo(projectId, hasProjectToken, projectTags, areProjectTagsInherited), errorMessage);
    }

    public static EnvironmentSelectionPanelDto forProjectWithoutCredentials(Long testAutomationServerId, Long projectId) {
        return new EnvironmentSelectionPanelDto(new EnvironmentsInfo(null), new ServerInfo(testAutomationServerId, null, false), new ProjectInfo(projectId, false, null, false));
    }

    public EnvironmentsInfo getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(EnvironmentsInfo environments) {
        this.environments = environments;
    }

    public ServerInfo getServer() {
        return this.server;
    }

    public void setServer(ServerInfo server) {
        this.server = server;
    }

    public ProjectInfo getProject() {
        return this.project;
    }

    public void setProject(ProjectInfo project) {
        this.project = project;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

