/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.campaign.IterationTestPlanDisplayService;
import org.squashtest.tm.service.internal.display.campaign.ExecutionSuccessRateCalculator;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.IterationTestPlanItemExecutionGrid;

@Service
@Transactional(readOnly=true)
public class IterationTestPlanDisplayServiceImpl
implements IterationTestPlanDisplayService {
    private static final String CAN_READ_ITERATION_TEST_PLAN_ITEM = "hasPermission(#itemId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'READ') or hasRole('ROLE_ADMIN')";
    private final DSLContext dslContext;
    private final ExecutionSuccessRateCalculator rateCalculator;

    public IterationTestPlanDisplayServiceImpl(DSLContext dslContext, ExecutionSuccessRateCalculator rateCalculator) {
        this.dslContext = dslContext;
        this.rateCalculator = rateCalculator;
    }

    @Override
    @PreAuthorize(value="hasPermission(#itemId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'READ') or hasRole('ROLE_ADMIN')")
    public GridResponse getITPIExecutions(Long iterationId, Long itemId, GridRequest gridRequest) {
        IterationTestPlanItemExecutionGrid grid = new IterationTestPlanItemExecutionGrid(iterationId, itemId);
        GridResponse gridResponse = grid.getRows(gridRequest, this.dslContext);
        this.rateCalculator.appendSuccessRate(gridResponse);
        return gridResponse;
    }
}

