/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import java.util.Collection;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcSprintDeletionHandler;

@Component
public class JdbcSprintDeletionHandlerFactory {
    private final DSLContext dslContext;
    private final EntityManager entityManager;
    private final AttachmentRepository attachmentRepository;
    private final JdbcBatchReorderHelper reorderHelper;

    public JdbcSprintDeletionHandlerFactory(DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper) {
        this.dslContext = dslContext;
        this.attachmentRepository = attachmentRepository;
        this.reorderHelper = reorderHelper;
        this.entityManager = entityManager;
    }

    public JdbcSprintDeletionHandler build(Collection<Long> sprintIds) {
        return this.build(sprintIds, UUID.randomUUID().toString());
    }

    public JdbcSprintDeletionHandler build(Collection<Long> sprintIds, String operationId) {
        return new JdbcSprintDeletionHandler(sprintIds, this.dslContext, this.entityManager, this.attachmentRepository, this.reorderHelper, operationId);
    }
}

