/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;

@Component
public class NameResolver {
    @Inject
    private MessageSource messageSource;

    void resolveNewName(CustomReportLibraryNode node, CustomReportLibraryNode target) {
        if (target.childNameAlreadyUsed(node.getName())) {
            this.resolveNameConflict(target, node, 1);
        }
    }

    void resolveNameConflict(CustomReportLibraryNode target, CustomReportLibraryNode node, int i) {
        String copySuffix = this.messageSource.getMessage("label.CopySuffix", null, LocaleContextHolder.getLocale());
        String testedName = String.valueOf(node.getName()) + copySuffix + i;
        if (target.childNameAlreadyUsed(testedName)) {
            this.resolveNameConflict(target, node, i + 1);
        } else {
            node.setName(testedName);
            node.getEntity().setName(testedName);
        }
    }
}

