/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.customreport.CustomReportCustomExportModificationService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomExportWorkbenchData;

@Service
@Transactional
public class CustomReportCustomExportModificationServiceImpl
implements CustomReportCustomExportModificationService {
    @Inject
    private CustomReportLibraryNodeService reportLibraryNodeService;
    @Inject
    private CustomReportCustomExportService customExportService;

    @Override
    @Transactional(readOnly=true)
    public CustomExportWorkbenchData getWorkbenchData(Long customReportLibraryNodeId) {
        CustomExportWorkbenchData data = new CustomExportWorkbenchData();
        CustomReportLibraryNode node = this.reportLibraryNodeService.findCustomReportLibraryNodeById(customReportLibraryNodeId);
        data.setProjectId(node.getLibrary().getProject().getId());
        data.setContainerId(this.findContainerId(node));
        if (node.getEntityType().getTypeName().equals("CUSTOM_EXPORT")) {
            data.setCustomExport(this.customExportService.findCustomExportDtoByNodeId(customReportLibraryNodeId));
        }
        return data;
    }

    private Long findContainerId(final CustomReportLibraryNode node) {
        final Long[] customReportLibraryNodeIds = new Long[1];
        CustomReportTreeEntityVisitor treeEntityVisitor = new CustomReportTreeEntityVisitor(){

            public void visit(CustomReportFolder crf) {
                customReportLibraryNodeIds[0] = node.getId();
            }

            public void visit(CustomReportLibrary crl) {
                customReportLibraryNodeIds[0] = node.getId();
            }

            public void visit(CustomReportDashboard crf) {
                customReportLibraryNodeIds[0] = node.getParent().getId();
            }

            public void visit(ChartDefinition chartDefinition) {
                customReportLibraryNodeIds[0] = node.getParent().getId();
            }

            public void visit(ReportDefinition reportDefinition) {
                customReportLibraryNodeIds[0] = node.getParent().getId();
            }

            public void visit(CustomReportCustomExport crce) {
                customReportLibraryNodeIds[0] = node.getParent().getId();
            }
        };
        node.getEntity().accept(treeEntityVisitor);
        return customReportLibraryNodeIds[0];
    }

    @Override
    public void updateCustomExport(Long customExportId, CustomReportCustomExport updatedCustomExport) {
        CustomReportCustomExport customExport = this.reportLibraryNodeService.findCustomExportByNodeId(customExportId);
        if (!customExport.getName().equals(updatedCustomExport.getName())) {
            this.reportLibraryNodeService.renameNode(customExportId, updatedCustomExport.getName());
        }
        customExport.setScope(updatedCustomExport.getScope());
        customExport.setColumns(updatedCustomExport.getColumns());
    }
}

