/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.customfield.AbstractValueEditionStatusHelper;
import org.squashtest.tm.service.internal.customfield.ValueEditionStatusStrategy;

@Component
class RequirementBoundEditionStatusStrategy
extends AbstractValueEditionStatusHelper
implements ValueEditionStatusStrategy {
    @PersistenceContext
    private EntityManager em;

    @Override
    public boolean isEditable(long boundEntityId, BindableEntity bindableEntity) {
        if (BindableEntity.REQUIREMENT_VERSION != bindableEntity) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " does not handle bindables of type " + bindableEntity.name());
        }
        return this.entityIsEditable(boundEntityId) && this.userHasPermission(boundEntityId, bindableEntity);
    }

    private boolean entityIsEditable(long boundEntityId) {
        RequirementVersion ver = (RequirementVersion)this.em.getReference(RequirementVersion.class, (Object)boundEntityId);
        return ver.isModifiable();
    }
}

