/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.service.customfield.CustomFieldHelper;
import org.squashtest.tm.service.internal.customfield.AbstractCustomFieldHelper;

public class CustomFieldHelperImpl<X extends BoundEntity>
extends AbstractCustomFieldHelper<X>
implements CustomFieldHelper<X> {
    private List<CustomFieldValue> values;
    private final Collection<X> entities;

    public CustomFieldHelperImpl(X entity) {
        this.entities = new ArrayList<X>();
        this.entities.add(entity);
    }

    public CustomFieldHelperImpl(Collection<X> entities) {
        this.entities = entities;
    }

    @Override
    protected List<CustomFieldValue> doGetCustomFieldValues() {
        if (this.values == null) {
            this.values = this.findRestrictedCustomFieldValues(this.entities, this.customFields);
        }
        return this.values;
    }

    protected List<CustomFieldValue> findRestrictedCustomFieldValues(Collection<? extends BoundEntity> entities, Collection<CustomField> customFields) {
        if (entities.isEmpty() || customFields.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getCufValuesService().findAllCustomFieldValues(entities, customFields);
    }

    @Override
    protected void initCustomFields() {
        if (!this.entities.isEmpty()) {
            Collection targets = CollectionUtils.collect(this.entities, (Transformer)new BindingTargetCollector());
            this.retainUniques(targets);
            this.customFields = new ArrayList();
            for (BindingTarget target : targets) {
                this.customFields = this.getAddingStrategy().add(this.customFields, this.findCustomFields(target.getProjectId(), target.getBindableEntity(), this.getLocations()));
            }
            this.retainUniques(this.customFields);
        } else {
            this.customFields = Collections.emptyList();
        }
    }

    private <Y> void retainUniques(Collection<Y> argument) {
        LinkedHashSet<Y> set = new LinkedHashSet<Y>(argument);
        argument.clear();
        argument.addAll(set);
    }

    private static class BindingTarget {
        private Long projectId;
        private BindableEntity bindableEntity;

        BindingTarget(BoundEntity entity) {
            this.projectId = entity.getProject().getId();
            this.bindableEntity = entity.getBoundEntityType();
        }

        public Long getProjectId() {
            return this.projectId;
        }

        public BindableEntity getBindableEntity() {
            return this.bindableEntity;
        }

        public int hashCode() {
            int result = 17;
            result = 73 * result + (this.bindableEntity == null ? 0 : this.bindableEntity.hashCode());
            result = 73 * result + (this.projectId == null ? 0 : this.projectId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BindingTarget other = (BindingTarget)obj;
            if (this.bindableEntity != other.bindableEntity) {
                return false;
            }
            return !(this.projectId == null ? other.projectId != null : !this.projectId.equals(other.projectId));
        }
    }

    private static final class BindingTargetCollector
    implements Transformer {
        private BindingTargetCollector() {
        }

        public Object transform(Object arg0) {
            return new BindingTarget((BoundEntity)arg0);
        }
    }
}

