/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.event.CreateCustomFieldBindingEvent;
import org.squashtest.tm.event.DeleteCustomFieldBindingEvent;
import org.squashtest.tm.exception.project.LockedParameterException;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomFieldCustomExportDto;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;
import org.squashtest.tm.service.internal.repository.CustomFieldBindingDao;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;

@Service(value="squashtest.tm.service.CustomFieldBindingService")
@Transactional
public class CustomFieldBindingModificationServiceImpl
implements CustomFieldBindingModificationService {
    private static final Transformer BINDING_ID_COLLECTOR = new Transformer(){

        public Object transform(Object input) {
            return ((CustomFieldBinding)input).getId();
        }
    };
    @Inject
    private CustomFieldDao customFieldDao;
    @Inject
    private CustomFieldBindingDao customFieldBindingDao;
    @Inject
    private PrivateCustomFieldValueService customValueService;
    @Inject
    private GenericProjectDao genericProjectDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private ApplicationEventPublisher eventPublisher;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;

    @Override
    @Transactional(readOnly=true)
    public List<CustomField> findAvailableCustomFields() {
        return this.customFieldDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomField> findAvailableCustomFields(long projectId, BindableEntity entity) {
        return this.customFieldDao.findAllBindableCustomFields(projectId, entity);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomField> findBoundCustomFields(long projectId, BindableEntity entity) {
        return this.customFieldDao.findAllBoundCustomFields(projectId, entity);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomFieldBinding> findCustomFieldsForGenericProject(long projectId) {
        return this.customFieldBindingDao.findAllForGenericProject(projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomFieldBinding> findCustomFieldsForProjectAndEntity(long projectId, BindableEntity entity) {
        return this.customFieldBindingDao.findAllForProjectAndEntity(projectId, entity);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomFieldBinding> findCustomFieldsForBoundEntity(BoundEntity boundEntity) {
        return this.customFieldBindingDao.findAllForProjectAndEntity(boundEntity.getProject().getId(), boundEntity.getBoundEntityType());
    }

    @Override
    @Transactional(readOnly=true)
    public PagedCollectionHolder<List<CustomFieldBinding>> findCustomFieldsForProjectAndEntity(long projectId, BindableEntity entity, Paging paging) {
        List bindings = this.customFieldBindingDao.findAllForProjectAndEntity(projectId, entity, paging);
        Long count = this.customFieldBindingDao.countAllForProjectAndEntity(projectId, entity);
        return new PagingBackedPagedCollectionHolder(paging, count.longValue(), (Collection)bindings);
    }

    @Override
    public Map<Long, String> findCustomFieldLabelsByIdsFromProjectIds(List<Long> projectIds) {
        HashMap<Long, String> availableCufMap = new HashMap<Long, String>();
        List<CustomFieldCustomExportDto> availableExportCustomFields = this.customValueService.findAllAvailableCufsForCustomExport(projectIds);
        availableExportCustomFields.forEach(availableCuf -> this.appendAvailableCustomFields((Map<Long, String>)availableCufMap, (CustomFieldCustomExportDto)availableCuf));
        return availableCufMap;
    }

    private void appendAvailableCustomFields(Map<Long, String> availableCufMap, CustomFieldCustomExportDto availableCuf) {
        if (!Objects.nonNull(availableCuf.getCufId())) {
            throw new NullPointerException("Custom field id cannot be null in CustomFieldCustomExportDto entity.");
        }
        availableCufMap.put(availableCuf.getCufId(), availableCuf.getLabel());
    }

    @Override
    public void createNewBindings(CustomFieldBindingModel[] bindingModels) {
        if (this.genericProjectDao.isBoundToATemplate(bindingModels[0].getProjectId())) {
            throw new LockedParameterException();
        }
        GenericProject project = (GenericProject)this.genericProjectDao.findById(bindingModels[0].getProjectId()).orElseThrow();
        PermissionsUtils.checkPermission(this.permissionEvaluationService, new SecurityCheckableObject(project, Permissions.MANAGE_PROJECT.name()));
        CustomFieldBindingModel[] customFieldBindingModelArray = bindingModels;
        int n = bindingModels.length;
        int n2 = 0;
        while (n2 < n) {
            CustomFieldBindingModel model = customFieldBindingModelArray[n2];
            long cufId = model.getCustomField().getId();
            BindableEntity entity = model.getBoundEntity().toDomain();
            CustomFieldBinding newBinding = this.createBinding(project, entity, cufId);
            if (!this.genericProjectDao.isProjectTemplate(project.getId())) {
                this.customValueService.cascadeCustomFieldValuesCreation(newBinding);
            } else {
                this.propagateCufBindingCreationToBoundProjects(project, entity, cufId);
            }
            ++n2;
        }
    }

    private void propagateCufBindingCreationToBoundProjects(GenericProject project, BindableEntity entity, long cufId) {
        Collection<Long> boundProjectsIds = this.projectDao.findAllIdsBoundToTemplate(project.getId());
        for (Long boundProjectId : boundProjectsIds) {
            if (this.customFieldBindingDao.cufBindingAlreadyExists(boundProjectId, entity, cufId)) continue;
            this.addNewCustomFieldBinding(boundProjectId, entity, cufId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void addNewCustomFieldBinding(long projectId, BindableEntity entity, long customFieldId) {
        this.addNewCustomFieldBindingUnsecured(projectId, entity, customFieldId);
    }

    @Override
    public void addNewCustomFieldBindingUnsecured(long projectId, BindableEntity entity, long customFieldId) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.findById(projectId).orElseThrow();
        CustomFieldBinding newBinding = this.createBinding(genericProject, entity, customFieldId);
        if (!this.genericProjectDao.isProjectTemplate(projectId)) {
            this.customValueService.cascadeCustomFieldValuesCreation(newBinding);
        }
    }

    @Override
    public void removeCustomFieldBindings(List<Long> bindingIds) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        if (!bindingIds.isEmpty()) {
            if (this.genericProjectDao.oneIsBoundToABoundProject(bindingIds)) {
                throw new LockedParameterException();
            }
            this.doRemoveCustomFieldBindings(bindingIds);
        }
    }

    @Override
    public void doRemoveCustomFieldBindings(List<Long> bindingIds) {
        if (!bindingIds.isEmpty()) {
            ArrayList<Long> bindingIdsToRemove = new ArrayList<Long>(bindingIds);
            bindingIdsToRemove.addAll(this.customFieldBindingDao.findEquivalentBindingsForBoundProjects(bindingIds));
            this.customValueService.cascadeCustomFieldValuesDeletion(bindingIdsToRemove);
            this.customFieldBindingDao.removeCustomFieldBindings(bindingIdsToRemove);
            this.eventPublisher.publishEvent((ApplicationEvent)new DeleteCustomFieldBindingEvent(bindingIdsToRemove));
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeCustomFieldBindings(Long projectId) {
        List<CustomFieldBinding> bindings = this.customFieldBindingDao.findAllForGenericProject(projectId);
        LinkedList<Long> bindingIds = new LinkedList<Long>(CollectionUtils.collect(bindings, (Transformer)BINDING_ID_COLLECTOR));
        this.doRemoveCustomFieldBindings(bindingIds);
    }

    private CustomFieldBinding createBinding(GenericProject genericProject, BindableEntity entity, long customFieldId) {
        CustomFieldBinding newBinding = new CustomFieldBinding();
        CustomField field = (CustomField)this.customFieldDao.getReferenceById(customFieldId);
        long newIndex = this.customFieldBindingDao.countAllForProjectAndEntity(genericProject.getId(), entity) + 1L;
        newBinding.setBoundProject(genericProject);
        newBinding.setBoundEntity(entity);
        newBinding.setCustomField(field);
        newBinding.setPosition((int)newIndex);
        newBinding.setRenderingLocations(null);
        this.customFieldBindingDao.save(newBinding);
        this.eventPublisher.publishEvent((ApplicationEvent)new CreateCustomFieldBindingEvent(newBinding));
        return newBinding;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void copyCustomFieldsSettingsFromTemplate(GenericProject target, GenericProject source) {
        List<CustomFieldBinding> templateCustomFieldBindings = this.findCustomFieldsForGenericProject(source.getId());
        for (CustomFieldBinding templateCustomFieldBinding : templateCustomFieldBindings) {
            long customFieldId;
            BindableEntity entity;
            long projectId = target.getId();
            if (this.customFieldBindingDao.cufBindingAlreadyExists(projectId, entity = templateCustomFieldBinding.getBoundEntity(), customFieldId = templateCustomFieldBinding.getCustomField().getId().longValue())) continue;
            this.addNewCustomFieldBinding(projectId, entity, customFieldId);
        }
    }
}

