/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.IdentifiersOrderComparator;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.campaign.CreatedTestPlanItems;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManagerServiceImpl$AjcClosure11;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManagerServiceImpl$AjcClosure13;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManagerServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManagerServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManagerServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManagerServiceImpl$AjcClosure9;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeWalker;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;

@Service(value="squashtest.tm.service.IterationTestPlanManagerService")
@Transactional
public class IterationTestPlanManagerServiceImpl
implements IterationTestPlanManagerService {
    private static final String LINK_ITERATION_OR_ROLE_ADMIN = "hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')";
    private static final String ITERATION_ID = "iterationId";
    private static final String WRITE = "WRITE";
    @Inject
    private IterationDao iterationDao;
    @Inject
    private IterationTestPlanDao iterationTestPlanDao;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private UserDao userDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private CampaignNodeDeletionHandler deletionHandler;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    @Qualifier(value="squashtest.tm.repository.TestCaseLibraryNodeDao")
    private LibraryNodeDao<TestCaseLibraryNode> testCaseLibraryNodeDao;
    @Inject
    @Qualifier(value="squashtest.core.security.ObjectIdentityRetrievalStrategy")
    private ObjectIdentityRetrievalStrategy objIdRetrievalStrategy;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    private ExecutionModificationService executionModService;
    @Inject
    DSLContext dslContext;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public CreatedTestPlanItems addTestCasesToIteration(List<Long> objectsIds, @Id long iterationId) {
        return this.addTestCasesToIterationUnsecured(objectsIds, iterationId);
    }

    @Override
    public CreatedTestPlanItems addTestCasesToIterationUnsecured(List<Long> objectsIds, @Id long iterationId) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        return this.addTestPlanItemsToIteration(objectsIds, iteration);
    }

    @Override
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    public void copyTestPlanItems(List<Long> iterationTestPlanIds, @Id long iterationId) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List<IterationTestPlanItem> items = this.findTestPlanItems(iterationTestPlanIds);
        for (IterationTestPlanItem item : items) {
            if (item.isTestCaseDeleted()) continue;
            IterationTestPlanItem copy = new IterationTestPlanItem(item.getReferencedTestCase(), item.getReferencedDataset());
            this.iterationTestPlanDao.save(copy);
            iteration.addTestPlan(copy);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#iteration, 'LINK')  or hasRole('ROLE_ADMIN')")
    public CreatedTestPlanItems addTestPlanItemsToIteration(List<Long> testNodesIds, Iteration iteration) {
        List<TestCaseLibraryNode> nodes = this.testCaseLibraryNodeDao.findAllByIds(testNodesIds);
        IdentifiersOrderComparator comparator = new IdentifiersOrderComparator(testNodesIds);
        nodes.sort((Comparator<TestCaseLibraryNode>)comparator);
        List<TestCase> testCases = new TestCaseNodeWalker().walk(nodes);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> CollectionUtils.filter((Collection)testCases, tc -> ((TestCase)tc).getMilestones().contains(milestone)));
        LinkedList<IterationTestPlanItem> testPlan = new LinkedList<IterationTestPlanItem>();
        boolean foundDatasets = false;
        for (TestCase testCase : testCases) {
            boolean thisTestCaseHasDatasets = this.addTestCaseToTestPlan(testCase, testPlan);
            boolean bl = foundDatasets = foundDatasets || thisTestCaseHasDatasets;
        }
        this.addTestPlanToIteration(testPlan, iteration.getId());
        List<Long> ids = testPlan.stream().map(IterationTestPlanItem::getId).toList();
        return new CreatedTestPlanItems(ids, foundDatasets);
    }

    private boolean addTestCaseToTestPlan(TestCase testCase, List<IterationTestPlanItem> testPlan) {
        testPlan.addAll(testCase.createTestPlanItems());
        return !CollectionUtils.isEmpty((Collection)testCase.getDatasets());
    }

    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void addTestPlanToIteration(List<IterationTestPlanItem> testPlan, @Id long iterationId) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        for (IterationTestPlanItem itp : testPlan) {
            iteration.addTestPlan(itp);
            this.iterationTestPlanDao.save(itp);
        }
        this.auditModificationService.updateAuditable((AuditableMixin)iteration);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class)
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeTestPlanPosition(@Id long iterationId, int newPosition, List<Long> itemIds) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List<Long> list = itemIds;
        IterationTestPlanDao iterationTestPlanDao = this.iterationTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        IterationTestPlanManagerServiceImpl$AjcClosure1 iterationTestPlanManagerServiceImpl$AjcClosure1 = new IterationTestPlanManagerServiceImpl$AjcClosure1(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationTestPlanManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        iteration.moveTestPlans(newPosition, items);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public boolean removeTestPlansFromIteration(List<Long> testPlanIds, @Id long iterationId) {
        Iteration it = (Iteration)this.iterationDao.findById(iterationId);
        return this.removeTestPlansFromIterationObj(testPlanIds, it);
    }

    @Override
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void removeExecutionsFromTestPlanItem(List<Long> executionIds, @Id Long iterationId) {
        for (Long executionId : executionIds) {
            this.removeTestPlanExecution(executionId);
        }
    }

    @Override
    public Map<Long, List<ExecutionSummaryDto>> getLastExecutionStatuses(Collection<Long> itemId) {
        return this.executionModService.findIterationTestPlanItemLastExecStatuses(itemId);
    }

    private void removeTestPlanExecution(Long executionId) {
        Execution execution = this.executionModService.findById(executionId);
        IterationTestPlanItem testPlan = execution.getTestPlan();
        this.executionModService.deleteExecution(execution);
        if (testPlan.getExecutions().isEmpty()) {
            this.assignUserToTestPlanItem(testPlan.getId(), 0L);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#iteration, 'LINK')  or hasRole('ROLE_ADMIN')")
    public boolean removeTestPlansFromIterationObj(List<Long> testPlanItemsIds, Iteration iteration) {
        boolean unauthorizedDeletion = false;
        List<Long> list = testPlanItemsIds;
        IterationTestPlanDao iterationTestPlanDao = this.iterationTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        IterationTestPlanManagerServiceImpl$AjcClosure3 iterationTestPlanManagerServiceImpl$AjcClosure3 = new IterationTestPlanManagerServiceImpl$AjcClosure3(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationTestPlanManagerServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        int sizeBeforeDeletion = iteration.getTestPlans().size();
        HashSet<TestSuite> testSuitesToUpdate = new HashSet<TestSuite>();
        for (IterationTestPlanItem item : items) {
            testSuitesToUpdate.addAll(item.getTestSuites());
        }
        for (IterationTestPlanItem item : items) {
            boolean bl = unauthorizedDeletion = this.removeTestPlanItemIfOkWithExecsAndRights(iteration, item) || unauthorizedDeletion;
        }
        if (sizeBeforeDeletion > iteration.getTestPlans().size()) {
            this.customTestSuiteModificationService.updateExecutionStatus(testSuitesToUpdate);
        }
        return unauthorizedDeletion;
    }

    private boolean removeTestPlanItemIfOkWithExecsAndRights(Iteration iteration, IterationTestPlanItem item) {
        boolean unauhorized = false;
        if (item.getExecutions().isEmpty()) {
            this.doRemoveTestPlanItemFromIteration(iteration, item);
        } else {
            try {
                PermissionsUtils.checkPermission(this.permissionEvaluationService, new SecurityCheckableObject(item, "EXTENDED_DELETE"));
                this.doRemoveTestPlanItemFromIteration(iteration, item);
            }
            catch (AccessDeniedException accessDeniedException) {
                unauhorized = true;
            }
        }
        return unauhorized;
    }

    private void doRemoveTestPlanItemFromIteration(Iteration iteration, IterationTestPlanItem item) {
        iteration.removeItemFromTestPlan(item);
        this.deletionHandler.deleteIterationTestPlanItem(item);
        this.auditModificationService.updateAuditable((AuditableMixin)iteration);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItem, 'LINK') or hasRole('ROLE_ADMIN')")
    public boolean removeTestPlanFromIteration(IterationTestPlanItem testPlanItem) {
        Iteration iteration = testPlanItem.getIteration();
        return this.removeTestPlanItemIfOkWithExecsAndRights(iteration, testPlanItem);
    }

    @Override
    @PreAuthorize(value="hasPermission(#item, 'EXECUTE')  or hasRole('ROLE_ADMIN')or hasRole('ROLE_TA_API_CLIENT')")
    public void updateMetadata(IterationTestPlanItem item) {
        Execution execution = item.getLatestExecution();
        if (execution != null) {
            item.setLastExecutedBy(execution.getLastExecutedBy());
            item.setLastExecutedOn(execution.getLastExecutedOn());
            item.setUser(this.userDao.findUserByLogin(execution.getLastExecutedBy()));
        }
    }

    private void arbitraryUpdateMetadata(IterationTestPlanItem item, User user, Date date) {
        item.setLastExecutedBy(user.getLogin());
        item.setLastExecutedOn(date);
        item.setUser(user);
    }

    @Override
    public List<User> findAssignableUsersForTestPlan(long iterationId) {
        List<String> loginList;
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        ArrayList<ObjectIdentity> entityRefs = new ArrayList<ObjectIdentity>();
        ObjectIdentity oid = this.objIdRetrievalStrategy.getObjectIdentity((Object)iteration);
        entityRefs.add(oid);
        List<String> list = loginList = this.aclService.findUsersWithExecutePermission(entityRefs);
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        IterationTestPlanManagerServiceImpl$AjcClosure5 iterationTestPlanManagerServiceImpl$AjcClosure5 = new IterationTestPlanManagerServiceImpl$AjcClosure5(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationTestPlanManagerServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
    }

    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'WRITE')  or hasRole('ROLE_ADMIN')")
    public void assignUserToTestPlanItem(long testPlanItemId, long userId) {
        User user = userId == 0L ? null : (User)this.userDao.getReferenceById(userId);
        IterationTestPlanItem itp = this.iterationTestPlanDao.findByIdWithTestCase(testPlanItemId);
        if (!itp.isTestCaseDeleted()) {
            itp.setUser(user);
        }
    }

    @Override
    public void assignUserToTestPlanItems(List<Long> testPlanIds, long userId) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, testPlanIds, WRITE, IterationTestPlanItem.class.getName());
        List<Long> list = testPlanIds;
        IterationTestPlanDao iterationTestPlanDao = this.iterationTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        IterationTestPlanManagerServiceImpl$AjcClosure7 iterationTestPlanManagerServiceImpl$AjcClosure7 = new IterationTestPlanManagerServiceImpl$AjcClosure7(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationTestPlanManagerServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112));
        User user = userId == 0L ? null : (User)this.userDao.getReferenceById(userId);
        for (IterationTestPlanItem item : items) {
            if (item.isTestCaseDeleted()) continue;
            item.setUser(user);
        }
    }

    @Override
    public void removeTestPlanItemsAssignments(List<Long> testPlanIds) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, testPlanIds, WRITE, IterationTestPlanItem.class.getName());
        List<Long> list = testPlanIds;
        IterationTestPlanDao iterationTestPlanDao = this.iterationTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        IterationTestPlanManagerServiceImpl$AjcClosure9 iterationTestPlanManagerServiceImpl$AjcClosure9 = new IterationTestPlanManagerServiceImpl$AjcClosure9(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationTestPlanManagerServiceImpl$AjcClosure9.linkClosureAndJoinPoint(4112));
        for (IterationTestPlanItem item : items) {
            if (item.isTestCaseDeleted()) continue;
            item.setUser(null);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#itemTestPlanId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'READ')  or hasRole('ROLE_ADMIN')")
    public IterationTestPlanItem findTestPlanItem(long itemTestPlanId) {
        return this.iterationTestPlanDao.findByIdWithTestCase(itemTestPlanId);
    }

    @Override
    public List<IterationTestPlanItem> forceExecutionStatus(List<Long> testPlanIds, String statusName) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, testPlanIds, WRITE, IterationTestPlanItem.class.getName());
        List<Long> list = testPlanIds;
        IterationTestPlanDao iterationTestPlanDao = this.iterationTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        IterationTestPlanManagerServiceImpl$AjcClosure11 iterationTestPlanManagerServiceImpl$AjcClosure11 = new IterationTestPlanManagerServiceImpl$AjcClosure11(objectArray);
        List testPlanItems = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationTestPlanManagerServiceImpl$AjcClosure11.linkClosureAndJoinPoint(4112));
        ExecutionStatus status = ExecutionStatus.valueOf((String)statusName);
        String login = UserContextHolder.getUsername();
        User user = this.userDao.findUserByLogin(login);
        Date date = new Date();
        HashSet<TestSuite> testSuitesToUpdate = new HashSet<TestSuite>();
        for (IterationTestPlanItem item : testPlanItems) {
            item.setExecutionStatus(status);
            this.arbitraryUpdateMetadata(item, user, date);
            testSuitesToUpdate.addAll(item.getTestSuites());
        }
        this.customTestSuiteModificationService.updateExecutionStatus(testSuitesToUpdate);
        return testPlanItems;
    }

    private Collection<IterationTestPlanItem> createTestPlanFragment(TestCase testCase) {
        ArrayList<IterationTestPlanItem> fragment = new ArrayList<IterationTestPlanItem>();
        this.addTestCaseToTestPlan(testCase, fragment);
        return fragment;
    }

    @Override
    public Collection<IterationTestPlanItem> createTestPlanFragment(TestCase testCase, User assignee) {
        Collection<IterationTestPlanItem> fragment = this.createTestPlanFragment(testCase);
        for (IterationTestPlanItem item : fragment) {
            item.setUser(assignee);
        }
        return fragment;
    }

    @Override
    @PreAuthorize(value="hasPermission(#itemId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=IterationTestPlanItem.class)
    public void changeDataset(@Id long itemId, Long datasetId) {
        IterationTestPlanItem item = this.iterationTestPlanDao.findByIdWithTestCase(itemId);
        if (datasetId == null) {
            item.setReferencedDataset(null);
        } else if (!item.isTestCaseDeleted()) {
            TestCase tc = item.getReferencedTestCase();
            Dataset ds = (Dataset)this.datasetDao.getReferenceById(datasetId);
            if (!ds.getTestCase().equals((Object)tc)) {
                throw new IllegalArgumentException("dataset [id:'" + ds.getId() + "', name:'" + ds.getName() + "'] doesn't belong to test case [id:'" + tc.getId() + "', name:'" + tc.getName() + "']");
            }
            item.setReferencedDataset(ds);
        }
    }

    @Override
    public List<IterationTestPlanItem> findTestPlanItems(List<Long> ids) {
        List<Long> list = ids;
        IterationTestPlanDao iterationTestPlanDao = this.iterationTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        IterationTestPlanManagerServiceImpl$AjcClosure13 iterationTestPlanManagerServiceImpl$AjcClosure13 = new IterationTestPlanManagerServiceImpl$AjcClosure13(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationTestPlanManagerServiceImpl$AjcClosure13.linkClosureAndJoinPoint(4112));
    }

    static {
        IterationTestPlanManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody0(IterationTestPlanManagerServiceImpl iterationTestPlanManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody2(IterationTestPlanManagerServiceImpl iterationTestPlanManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    static final /* synthetic */ List findUsersByLoginList_aroundBody4(IterationTestPlanManagerServiceImpl iterationTestPlanManagerServiceImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginList(list);
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody6(IterationTestPlanManagerServiceImpl iterationTestPlanManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody8(IterationTestPlanManagerServiceImpl iterationTestPlanManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody10(IterationTestPlanManagerServiceImpl iterationTestPlanManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody12(IterationTestPlanManagerServiceImpl iterationTestPlanManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IterationTestPlanManagerServiceImpl.java", IterationTestPlanManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "ids", "", "java.util.List"), 225);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "ids", "", "java.util.List"), 268);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findUsersByLoginList", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "loginList", "", "java.util.List"), 365);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "ids", "", "java.util.List"), 391);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "ids", "", "java.util.List"), 407);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "ids", "", "java.util.List"), 434);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "ids", "", "java.util.List"), 515);
    }
}

