/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.RichTextValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.KeywordExecution;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.testcase.ConsumerForScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.execution.ExecutionHasNoStepsException;
import org.squashtest.tm.exception.execution.ExecutionWasDeleted;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.exception.execution.TestSuiteTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.PreventConcurrents;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.IterationStatisticsService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.StrategyCopierService;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManager;
import org.squashtest.tm.service.internal.campaign.coercers.TestSuiteToIterationCoercerForArray;
import org.squashtest.tm.service.internal.campaign.scripted.ScriptedTestCaseExecutionHelper;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.library.PasteStrategy;
import org.squashtest.tm.service.internal.library.TreeNodeCopier;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.service.testcase.TestCaseCyclicCallChecker;

@Service(value="CustomIterationModificationService")
@Transactional
public class CustomIterationModificationServiceImpl
implements CustomIterationModificationService,
IterationTestPlanManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomIterationModificationServiceImpl.class);
    private static final String ITERATION_ID = "iterationId";
    @Inject
    private MessageSource messageSource;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private CustomCampaignModificationService campaignModificationService;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private TestSuiteDao suiteDao;
    @Inject
    private IterationTestPlanDao testPlanDao;
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private TestCaseCyclicCallChecker testCaseCyclicCallChecker;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    @Inject
    private IterationStatisticsService statisticsService;
    @Inject
    private ExecutionModificationService executionModificationService;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToIterationStrategy")
    private Provider<PasteStrategy<Iteration, TestSuite>> pasteToIterationStrategyProvider;
    @Inject
    private Provider<TreeNodeCopier> treeNodeCopierFactory;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;
    @Inject
    private ScriptedTestCaseExecutionHelper scriptedTestCaseExecutionHelper;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    protected PermissionEvaluationService permissionService;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private StrategyCopierService strategyCopierService;

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'CREATE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public Iteration addIterationToCampaign(Iteration iteration, @Id long campaignId, boolean copyTestPlan, Map<Long, RawValue> customFieldValues) {
        return this.addIterationToCampaignUnsecured(iteration, campaignId, copyTestPlan, customFieldValues);
    }

    @Override
    public Iteration addIterationToCampaignUnsecured(Iteration iteration, @Id long campaignId, boolean copyTestPlan, Map<Long, RawValue> customFieldValues) {
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        if (copyTestPlan) {
            this.populateTestPlan(iteration, campaign.getTestPlan());
        }
        this.iterationDao.persistIterationAndTestPlan(iteration);
        campaign.addContent(iteration);
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)iteration, iteration.getProject(), customFieldValues);
        this.createIterationAttachments(iteration);
        return iteration;
    }

    @Override
    public void createIterationWithItemCopies(@Id long campaignId, String name, String description, List<Long> itemTestPlanIds) {
        Iteration iteration = new Iteration();
        iteration.setName(name);
        iteration.setDescription(description);
        this.addIterationToCampaign(iteration, campaignId, false, Collections.emptyMap());
        this.iterationTestPlanManagerService.copyTestPlanItems(itemTestPlanIds, iteration.getId());
    }

    @Override
    public void createIterationAttachments(Iteration iteration) {
        String newDescription;
        Long attachmentListId = iteration.getAttachmentList().getId();
        EntityReference entityReference = iteration.toEntityReference();
        String description = iteration.getDescription();
        this.createAttachmentsFromCuf((BoundEntity)iteration, attachmentListId, entityReference);
        if (description != null && !description.isEmpty() && !(newDescription = this.attachmentManagerService.addAttachmentsFromRichText(description, attachmentListId, entityReference)).equals(description)) {
            iteration.setDescription(newDescription);
        }
    }

    private void createAttachmentsFromCuf(BoundEntity iteration, Long attachmentListId, EntityReference entityReference) {
        List<CustomFieldValue> persistentValues = this.customFieldValueService.findAllCustomFieldValues(iteration);
        persistentValues.forEach(customFieldValue -> {
            String html;
            String value;
            if (customFieldValue instanceof RichTextValue && !(value = customFieldValue.getValue()).equals(html = this.attachmentManagerService.addAttachmentsFromRichText(value, attachmentListId, entityReference))) {
                customFieldValue.setValue(html);
            }
        });
    }

    private void populateTestPlan(Iteration iteration, List<CampaignTestPlanItem> campaignTestPlan) {
        for (CampaignTestPlanItem campaignItem : campaignTestPlan) {
            TestCase testcase = campaignItem.getReferencedTestCase();
            Dataset dataset = campaignItem.getReferencedDataset();
            User assignee = campaignItem.getUser();
            IterationTestPlanItem item = new IterationTestPlanItem(testcase, dataset, assignee);
            iteration.addTestPlan(item);
        }
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject, 'READ')  or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public Iteration findById(long iterationId) {
        return (Iteration)this.iterationDao.findById(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void rename(@Id long iterationId, String newName) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List list = iteration.getCampaign().getIterations();
        String trimedName = newName.trim();
        if (!this.campaignModificationService.checkIterationNameAvailable(trimedName, list)) {
            throw new DuplicateNameException("Cannot rename iteration " + iteration.getName() + " : new name " + trimedName + " already exists in iteration " + this.campaignModificationService);
        }
        iteration.setName(trimedName);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=IterationTestPlanItem.class)
    public Execution addManualExecution(@Id long testPlanItemId) {
        return this.addManualExecutionUnsecured(testPlanItemId);
    }

    @Override
    public Execution addManualExecutionUnsecured(@Id long testPlanItemId) {
        IterationTestPlanItem item = this.testPlanDao.findByIdWithTestCase(testPlanItemId);
        if (item.isTestCaseDeleted()) {
            throw new TestSuiteTestPlanHasDeletedTestCaseException();
        }
        if (item.isExploratory()) {
            return this.addExecution(item);
        }
        if (!item.isGherkin() && item.getReferencedTestCase().getSteps().isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        Locale locale = this.testPlanDao.findProjectBddScriptLanguageByIterationTestPlanItemId(testPlanItemId).getLocale();
        Execution execution = this.addExecution(item, this.messageSource, locale);
        if (execution.getSteps().isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        return execution;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=IterationTestPlanItem.class)
    @CheckBlockingMilestone(entityType=IterationTestPlanItem.class)
    public Execution addExecution(@Id long testPlanItemId) {
        IterationTestPlanItem item = this.testPlanDao.findByIdWithTestCase(testPlanItemId);
        return this.addExecution(item);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class)
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void addTestSuite(@Id long iterationId, TestSuite suite) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        this.addTestSuite(iteration, suite);
    }

    @Override
    public void addTestSuite(Iteration iteration, TestSuite suite) {
        this.suiteDao.save(suite);
        iteration.addContent(suite);
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)suite, suite.getProject());
    }

    @Override
    @Transactional(readOnly=true)
    public List<NamedReference> findAllTestSuitesAsNamedReferences(long iterationId) {
        return this.iterationDao.findAllTestSuitesAsNamedReferences(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class)
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeTestSuitePosition(@Id long iterationId, int newIndex, List<Long> itemIds) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List items = this.suiteDao.findAllById(itemIds);
        iteration.moveTestSuites(newIndex, items);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=Iteration.class, paramName="iterationId")}, batchsLocks={@BatchPreventConcurrent(entityType=Iteration.class, paramName="testSuiteIds", coercer=TestSuiteToIterationCoercerForArray.class)})
    public void copyPasteTestSuitesToIteration(@Ids(value="testSuiteIds") Long[] testSuiteIds, @Id(value="iterationId") long iterationId, ClipboardPayload clipboardPayload) {
        NodeType nodePaste = this.strategyCopierService.verifyPermissionAndGetNodePaste(clipboardPayload);
        this.strategyCopierService.copyNodeToIteration(iterationId, clipboardPayload, nodePaste);
    }

    @Override
    public Execution addExecution(IterationTestPlanItem item) throws TestPlanItemNotExecutableException {
        Execution execution = this.createExec(item, null, null);
        item.addExecution(execution);
        this.customTestSuiteModificationService.updateExecutionStatus(item.getTestSuites());
        this.operationsAfterAddingExec(execution);
        return execution;
    }

    private Execution addExecution(IterationTestPlanItem item, MessageSource messageSource, Locale locale) throws TestPlanItemNotExecutableException {
        Execution execution = this.createExec(item, messageSource, locale);
        item.addExecution(execution);
        this.customTestSuiteModificationService.updateExecutionStatus(item.getTestSuites());
        this.operationsAfterAddingExec(execution);
        return execution;
    }

    private Execution createExec(IterationTestPlanItem item, MessageSource messageSource, Locale locale) {
        TestCase testCase = item.getReferencedTestCase();
        this.testCaseCyclicCallChecker.checkNoCyclicCall(testCase);
        Execution execution = messageSource != null && locale != null ? item.createExecution(messageSource, locale) : item.createExecution(null, null);
        this.executionDao.save(execution);
        this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)execution);
        for (ExecutionStep executionStep : execution.getSteps()) {
            this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)executionStep);
        }
        return execution;
    }

    private void operationsAfterAddingExec(Execution execution) {
        ExecutionVisitor executionVisitor = new ExecutionVisitor(){

            public void visit(Execution execution) {
                CustomIterationModificationServiceImpl.this.performOperationsAfterAddingStandardExecution(execution);
            }

            public void visit(ScriptedExecution scriptedExecution) {
                CustomIterationModificationServiceImpl.this.createCustomAndDenormalizedFieldsForExecution((Execution)scriptedExecution);
                CustomIterationModificationServiceImpl.this.createExecutionStepsForScriptedTestCase(scriptedExecution);
            }

            public void visit(KeywordExecution keywordExecution) {
                CustomIterationModificationServiceImpl.this.createCustomAndDenormalizedFieldsForExecution((Execution)keywordExecution);
            }

            public void visit(ExploratoryExecution exploratoryExecution) {
                CustomIterationModificationServiceImpl.this.createCustomAndDenormalizedFieldsForExecution((Execution)exploratoryExecution);
            }
        };
        execution.accept(executionVisitor);
    }

    private void performOperationsAfterAddingStandardExecution(Execution execution) {
        this.createCustomFieldsForExecutionAndExecutionSteps(execution);
        this.createDenormalizedFieldsForExecutionAndExecutionSteps(execution);
        this.createExecutionAttachments(execution);
    }

    private void createExecutionAttachments(Execution execution) {
        if (Objects.nonNull(execution.getId())) {
            String newDescription;
            Long attachmentListId = execution.getAttachmentList().getId();
            EntityReference entityReference = execution.toEntityReference();
            String description = execution.getDescription();
            this.createAttachmentsFromCuf((BoundEntity)execution, attachmentListId, entityReference);
            if (description != null && !description.isEmpty() && !(newDescription = this.attachmentManagerService.addAttachmentsFromRichText(description, attachmentListId, entityReference)).equals(description)) {
                execution.setDescription(newDescription);
            }
        }
    }

    private void createExecutionStepsForScriptedTestCase(ScriptedExecution scriptedExecution) {
        ConsumerForScriptedTestCaseVisitor testCaseVisitor = new ConsumerForScriptedTestCaseVisitor(scriptedTestCase -> this.scriptedTestCaseExecutionHelper.createExecutionStepsForScriptedTestCase(scriptedExecution));
        scriptedExecution.getReferencedTestCase().accept((TestCaseVisitor)testCaseVisitor);
    }

    private void createCustomFieldsForExecutionAndExecutionSteps(Execution execution) {
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)execution, execution.getProject());
        this.customFieldValueService.createAllCustomFieldValues(execution.getSteps(), execution.getProject());
    }

    private void createCustomAndDenormalizedFieldsForExecution(Execution execution) {
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)execution, execution.getProject());
        this.createDenormalizedFieldsForExecution(execution);
    }

    private void createDenormalizedFieldsForExecutionAndExecutionSteps(Execution execution) {
        this.createDenormalizedFieldsForExecution(execution);
        this.denormalizedFieldValueService.createAllDenormalizedFieldValuesForSteps(execution);
    }

    private void createDenormalizedFieldsForExecution(Execution execution) {
        LOGGER.debug("Create denormalized fields for Execution {}", new Object[]{execution.getId()});
        TestCase sourceTC = execution.getReferencedTestCase();
        this.denormalizedFieldValueService.createAllDenormalizedFieldValues((BoundEntity)sourceTC, (DenormalizedFieldHolder)execution);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public List<Iteration> findIterationContainingTestCase(long testCaseId) {
        return this.iterationDao.findAllIterationContainingTestCase(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration' , 'READ') or hasRole('ROLE_ADMIN')")
    public StatisticsBundle gatherIterationStatisticsBundle(long iterationId, boolean isLastExecutionScope) {
        return this.statisticsService.gatherIterationStatisticsBundle(Arrays.asList(iterationId), isLastExecutionScope);
    }

    @Override
    public Execution updateExecutionFromTc(long executionId) {
        Optional optExec = this.executionDao.findById(executionId);
        if (optExec.isEmpty()) {
            throw new ExecutionWasDeleted();
        }
        Execution exec = (Execution)optExec.get();
        if (exec.getReferencedTestCase() != null && exec.getReferencedTestCase().getSteps().isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        int order = exec.getExecutionOrder();
        IterationTestPlanItem itpi = exec.getTestPlan();
        this.executionModificationService.deleteExecution(exec);
        Execution execution = this.createExec(itpi, null, null);
        itpi.addExecutionAtPos(execution, order);
        this.operationsAfterAddingExec(execution);
        return execution;
    }
}

