/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.CampaignFinder;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.internal.library.NodeManagementService;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;

@Transactional
@Service(value="CustomCampaignModificationService")
public class CustomCampaignModificationServiceImpl
implements CustomCampaignModificationService {
    private static final String READ_CAMPAIGN_OR_ADMIN = "hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ') or hasRole('ROLE_ADMIN')";
    private static final String WRITE_CAMPAIGN_OR_ADMIN = "hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' ,'WRITE') or hasRole('ROLE_ADMIN')";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private MilestoneMembershipManager milestoneService;
    @Inject
    private CampaignFinder campaignFinder;
    @Inject
    @Named(value="squashtest.tm.service.internal.CampaignManagementService")
    private NodeManagementService<Campaign, CampaignLibraryNode, CampaignFolder> campaignManagementService;

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' ,'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void rename(@Id long campaignId, String newName) {
        this.campaignManagementService.renameNode(campaignId, newName);
    }

    @Override
    public boolean checkIterationNameAvailable(String name, List<Iteration> iterations) {
        for (Iteration iteration : iterations) {
            if (!iteration.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ') or hasRole('ROLE_ADMIN')")
    public Integer countIterations(Long campaignId) {
        return this.campaignDao.countIterations(campaignId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' ,'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void bindMilestone(@Id long campaignId, long milestoneId) {
        this.milestoneService.bindCampaignToMilestone(campaignId, milestoneId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' ,'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void unbindMilestones(@Id long campaignId, Collection<Long> milestoneIds) {
        this.milestoneService.unbindCampaignFromMilestones(campaignId, milestoneIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' ,'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void unbindSingleMilestone(@Id long campaignId, Long milestoneId) {
        this.milestoneService.unbindCampaignFromSingleMilestone(campaignId, milestoneId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAllMilestones(long campaignId) {
        return this.milestoneService.findMilestonesForCampaign(campaignId);
    }

    @Override
    public Campaign findCampaigWithExistenceCheck(long campaignId) {
        Campaign campaign = (Campaign)this.em.find(Campaign.class, (Object)campaignId);
        if (campaign == null) {
            return null;
        }
        return this.campaignFinder.findById(campaignId);
    }
}

