/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.service.annotation.CacheScope;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.SimulationFacility;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.InstructionContainer;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ExcelWorkbookParser;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;

public abstract class ExcelBatchImporter {
    @Inject
    private Provider<SimulationFacility> simulatorProvider;
    @Inject
    private Provider<FacilityImpl> facilityImplProvider;
    @Inject
    private EntityManager entityManager;
    protected final Logger LOGGER;

    protected ExcelBatchImporter(Logger logger) {
        this.LOGGER = logger;
    }

    public ImportLog simulateImport(File excelFile) {
        this.LOGGER.debug("beginning import simulation", new Object[0]);
        SimulationFacility simulator = (SimulationFacility)this.simulatorProvider.get();
        ExcelWorkbookParser parser = this.getExcelWorkbookParser(excelFile);
        LogTrain unknownHeaders = parser.logUnknownHeaders();
        List<InstructionContainer<?>> containers = this.buildOrderedInstructionContainers(parser);
        this.LOGGER.trace("running import simulation", new Object[0]);
        ImportLog importLog = this.run(containers, simulator);
        importLog.appendLogTrain(unknownHeaders);
        this.LOGGER.trace("done", new Object[0]);
        return importLog;
    }

    private ExcelWorkbookParser getExcelWorkbookParser(File excelFile) {
        this.LOGGER.trace("parsing excel file", new Object[0]);
        ExcelWorkbookParser parser = ExcelWorkbookParser.createParser(excelFile);
        parser.parse().releaseResources();
        this.LOGGER.trace("parsing done", new Object[0]);
        return parser;
    }

    @CacheScope
    public ImportLog performImport(File excelFile) {
        this.LOGGER.debug("beginning import", new Object[0]);
        FacilityImpl impl = (FacilityImpl)this.facilityImplProvider.get();
        ExcelWorkbookParser parser = this.getExcelWorkbookParser(excelFile);
        LogTrain unknownHeaders = parser.logUnknownHeaders();
        List<InstructionContainer<?>> containers = this.buildOrderedInstructionContainers(parser);
        this.LOGGER.trace("running import", new Object[0]);
        ImportLog importLog = this.run(containers, impl);
        this.LOGGER.trace("post processing", new Object[0]);
        impl.postprocess(containers.stream().map(InstructionContainer::getAllInstructions).flatMap(Collection::stream).collect(Collectors.toList()));
        importLog.appendLogTrain(unknownHeaders);
        this.LOGGER.trace("done", new Object[0]);
        return importLog;
    }

    private ImportLog run(List<InstructionContainer<?>> containers, Facility facility) {
        HibernateConfig.enableBatch(this.entityManager, 30);
        ImportLog importLog = new ImportLog();
        for (InstructionContainer<?> container : containers) {
            Map<?, LogTrain> instructionLogs = container.executeInstructions(facility);
            instructionLogs.forEach((instruction, logs) -> {
                this.handleLogs((Instruction<?>)instruction, (LogTrain)logs);
                logs.setForAll(instruction.getMode());
                logs.setForAll(instruction.getLine());
                importLog.appendLogTrain((LogTrain)logs);
            });
        }
        importLog.packLogs();
        return importLog;
    }

    private void handleLogs(Instruction<?> instruction, LogTrain logs) {
        if (logs.hasNoErrorWhatsoever()) {
            this.LOGGER.debug("No errors when executing instruction : (line {}) {} '{}'", new Object[]{instruction.getLine(), instruction.getMode(), instruction.getTarget()});
            logs.addEntry(LogEntry.ok().forTarget((Target)instruction.getTarget()).build());
        } else {
            this.LOGGER.warn("Errors were encountered for instruction : (line {}) {} '{}', they will be reported to the user.", new Object[]{instruction.getLine(), instruction.getMode(), instruction.getTarget()});
        }
    }

    public List<InstructionContainer<?>> buildOrderedInstructionContainers(ExcelWorkbookParser parser) {
        ArrayList containers = new ArrayList();
        for (EntityType entity : this.getEntityType()) {
            this.LOGGER.debug("building instructions for entity type : '{}'", new Object[]{entity});
            containers.add(this.findInstructionsByEntity(parser, entity));
        }
        return containers;
    }

    public abstract List<EntityType> getEntityType();

    public abstract InstructionContainer<?> findInstructionsByEntity(ExcelWorkbookParser var1, EntityType var2);
}

