/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.batchimport.CustomFieldHolder;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.Milestoned;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;

public class RequirementVersionInstruction
extends Instruction<RequirementVersionTarget>
implements CustomFieldHolder,
Milestoned {
    private RequirementVersion requirementVersion;
    private final Map<String, String> customFields = new HashMap<String, String>();
    private String[] milestones = new String[0];
    private boolean fatalError = false;

    public RequirementVersionInstruction(RequirementVersionTarget target, RequirementVersion requirementVersion) {
        super(target);
        this.requirementVersion = requirementVersion;
    }

    @Override
    protected LogTrain executeUpdate(Facility facility) {
        return facility.updateRequirementVersion(this);
    }

    @Override
    protected LogTrain executeDelete(Facility facility) {
        return facility.deleteRequirementVersion(this);
    }

    @Override
    protected LogTrain executeCreate(Facility facility) {
        return facility.createRequirementVersion(this);
    }

    @Override
    public void addCustomField(String code, String value) {
        this.customFields.put(code, value);
    }

    public RequirementVersion getRequirementVersion() {
        return this.requirementVersion;
    }

    public void setRequirementVersion(RequirementVersion requirementVersion) {
        this.requirementVersion = requirementVersion;
    }

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public List<String> getMilestones() {
        return Arrays.asList(this.milestones);
    }

    public void setMilestones(String[] milestones) {
        this.milestones = milestones;
    }

    public boolean isFatalError() {
        return this.fatalError;
    }

    public void fatalError() {
        this.fatalError = true;
    }
}

