/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;

public class RequirementLinkTarget
implements Target {
    private RequirementVersionTarget sourceVersion;
    private RequirementVersionTarget destVersion;

    public RequirementLinkTarget() {
        this.sourceVersion = new RequirementVersionTarget();
        this.destVersion = new RequirementVersionTarget();
    }

    public RequirementLinkTarget(RequirementVersionTarget source, RequirementVersionTarget dest) {
        this.sourceVersion = source;
        this.destVersion = dest;
    }

    @Override
    public EntityType getType() {
        return EntityType.REQUIREMENT_LINK;
    }

    @Override
    public boolean isWellFormed() {
        return this.sourceVersion.isWellFormed() && this.destVersion.isWellFormed();
    }

    public RequirementVersionTarget getSourceVersion() {
        return this.sourceVersion;
    }

    public void setSourceVersion(RequirementVersionTarget sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public RequirementVersionTarget getDestVersion() {
        return this.destVersion;
    }

    public void setDestVersion(RequirementVersionTarget destVersion) {
        this.destVersion = destVersion;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.destVersion == null ? 0 : this.destVersion.hashCode());
        result = 31 * result + (this.sourceVersion == null ? 0 : this.sourceVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequirementLinkTarget other = (RequirementLinkTarget)obj;
        if (this.destVersion == null ? other.destVersion != null : !this.destVersion.equals(other.destVersion)) {
            return false;
        }
        return !(this.sourceVersion == null ? other.sourceVersion != null : !this.sourceVersion.equals(other.sourceVersion));
    }
}

