/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import javax.validation.constraints.NotNull;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ParameterTarget;

public class ParameterInstruction
extends Instruction<ParameterTarget> {
    private final Parameter parameter;

    public ParameterInstruction(@NotNull ParameterTarget target, @NotNull Parameter parameter) {
        super(target);
        this.parameter = parameter;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    protected LogTrain executeUpdate(Facility facility) {
        this.fillMissingData();
        return facility.updateParameter((ParameterTarget)this.getTarget(), this.parameter);
    }

    @Override
    protected LogTrain executeDelete(Facility facility) {
        this.fillMissingData();
        return facility.deleteParameter((ParameterTarget)this.getTarget());
    }

    @Override
    protected LogTrain executeCreate(Facility facility) {
        throw new UnsupportedOperationException("This operation is no longer supported ");
    }

    private void fillMissingData() {
        ((ParameterTarget)this.getTarget()).setName(this.parameter.getName());
    }
}

