/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.service.milestone.MilestoneManagerService;

@Component
public class MilestoneImportHelper {
    private static final Partition EMPTY_PARTITION = new Partition(Collections.emptyList(), Collections.emptyList());
    private final MilestoneManagerService milestoneFinder;

    @Inject
    protected MilestoneImportHelper(MilestoneManagerService milestoneFinder) {
        this.milestoneFinder = milestoneFinder;
    }

    public Partition partitionExisting(@NotNull Collection<String> names) {
        Collection<String> collection = names;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(collection);
        if (names.isEmpty()) {
            return EMPTY_PARTITION;
        }
        List<String> existing = this.milestoneFinder.findExistingNames(names);
        ArrayList<String> unknown = new ArrayList<String>(names);
        unknown.removeAll(existing);
        return new Partition(unknown, existing);
    }

    public Partition partitionBindable(@NotNull Collection<String> names, @NotNull String projectName) {
        String string = projectName;
        Collection<String> collection = names;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(collection);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        if (names.isEmpty()) {
            return EMPTY_PARTITION;
        }
        List bindableStatus = MilestoneStatus.getAllStatusAllowingObjectBind();
        List<String> bindable = this.milestoneFinder.findBindableExistingNames(names, bindableStatus, projectName);
        ArrayList<String> notBindable = new ArrayList<String>(names);
        notBindable.removeAll(bindable);
        return new Partition(notBindable, bindable);
    }

    public List<Milestone> findBindable(Collection<String> names) {
        List bindableStatus = MilestoneStatus.getAllStatusAllowingObjectBind();
        ArrayList<Milestone> result = new ArrayList<Milestone>();
        for (MilestoneStatus milestoneStatus : bindableStatus) {
            result.addAll(this.milestoneFinder.findAllByNamesAndStatus(names, milestoneStatus));
        }
        return result;
    }

    public List<Milestone> findInProgressAndFinished(Collection<String> names) {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.addAll(this.milestoneFinder.findAllByNamesAndStatus(names, MilestoneStatus.IN_PROGRESS));
        milestones.addAll(this.milestoneFinder.findAllByNamesAndStatus(names, MilestoneStatus.FINISHED));
        return milestones;
    }

    public static final class Partition {
        public final List<String> passing;
        public final List<String> rejected;

        private Partition(List<String> rejected, List<String> passing) {
            this.rejected = Collections.unmodifiableList(rejected);
            this.passing = Collections.unmodifiableList(passing);
        }
    }
}

