/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.Model;
import org.squashtest.tm.service.internal.batchimport.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.TestCaseImportValidationBag;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.ValidationFacilitySubservicesProvider;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseSheetColumn;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;

class EntityValidator {
    private final ValidationFacilitySubservicesProvider subservicesProvider;

    public EntityValidator(ValidationFacilitySubservicesProvider modelProvider) {
        this.subservicesProvider = modelProvider;
    }

    Model getModel() {
        return this.subservicesProvider.getModel();
    }

    InfoListItemFinderService getInfoListItemService() {
        return this.subservicesProvider.getInfoListItemService();
    }

    PluginFinderService getPluginFinderService() {
        return this.subservicesProvider.getPluginFinderService();
    }

    RequirementLibraryFinderService getRequirementLibraryFinderService() {
        return this.subservicesProvider.getRequirementLibraryFinderService();
    }

    HighLevelRequirementService getHighLevelRequirementService() {
        return this.subservicesProvider.getHighLevelRequirementService();
    }

    public LogTrain updateTestCaseChecks(TestCaseTarget target, TestCase testCase, TestCaseImportValidationBag validationBag) {
        LogTrain logs = this.createTestCaseChecks(target, testCase, validationBag);
        String name = testCase.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.mandatoryColumn", TestCaseSheetColumn.TC_NAME.header).build());
        }
        logs.append(this.checkNatureAndTypeAndFixIfNeeded(target, testCase, validationBag));
        return logs;
    }

    public LogTrain createTestCaseChecks(TestCaseTarget target, TestCase testCase, TestCaseImportValidationBag validationBag) {
        String reference;
        ProjectTargetStatus projectStatus;
        String name = testCase.getName();
        LogTrain logs = new LogTrain();
        if (!target.isWellFormed()) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.field.malformedPath", target.getPath()).build());
        }
        if (target.isWellFormed() && (projectStatus = this.getModel().getProjectStatus(target.getProject())).getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        }
        if (name != null && name.length() > 255) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", TestCaseSheetColumn.TC_NAME.header).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
        if (!StringUtils.isBlank((CharSequence)(reference = testCase.getReference())) && reference.length() > 50) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", TestCaseSheetColumn.TC_REFERENCE.header).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
        logs.append(this.checkNatureAndTypeAndFixIfNeeded(target, testCase, validationBag));
        return logs;
    }

    LogTrain basicTestStepChecks(TestStepTarget target) {
        ProjectTargetStatus projectStatus;
        LogTrain logs = new LogTrain();
        TestCaseTarget testCase = target.getTestCase();
        if (!testCase.isWellFormed()) {
            logs.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.field.malformedPath", new String[]{testCase.getPath()}));
        }
        TargetStatus tcStatus = this.getModel().getStatus(testCase);
        if (tcStatus.status == Existence.TO_BE_DELETED || tcStatus.status == Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.notFound", new Object[0]).build());
        }
        if (target.isWellFormed() && (projectStatus = this.getModel().getProjectStatus(target.getProject())).getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        }
        return logs;
    }

    LogTrain validateCallStep(TestStepTarget target, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfos, ImportMode mode) {
        LogTrain logs = new LogTrain();
        String errorMessage = this.checkTestCaseExists(calledTestCase);
        if (errorMessage != null) {
            this.logMustExistAndBeValidCalledTest(target, mode, logs, errorMessage);
        } else {
            if (this.getModel().wouldCreateCycle(target, calledTestCase)) {
                logs.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.tc.callStep.cyclicCalls", new Object[]{target.getTestCase().getPath(), calledTestCase.getPath()}));
            }
            if (paramInfos.getParamMode() == ParameterAssignationMode.CALLED_DATASET) {
                String dsname = paramInfos.getCalledDatasetName();
                if (dsname.length() > 255) {
                    LogEntry entry = LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", StepSheetColumn.TC_STEP_CALL_DATASET.name()).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build();
                    logs.addEntry(entry);
                }
                DatasetTarget dsTarget = new DatasetTarget(calledTestCase, dsname);
                if (!this.getModel().doesDatasetExists(dsTarget)) {
                    logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.callStep.calledDatasetNotFound", new Object[0]).withImpact("message.import.log.impact.callStepCallsNoDataset", new Object[0]).build());
                }
            }
        }
        return logs;
    }

    private String checkTestCaseExists(TestCaseTarget calledTestCase) {
        TargetStatus calledStatus = this.getModel().getStatus(calledTestCase);
        String mustExistAndBeValidMessage = null;
        if (calledStatus.status == Existence.NOT_EXISTS || calledStatus.status == Existence.TO_BE_DELETED) {
            mustExistAndBeValidMessage = "message.import.log.error.tc.callStep.calledTcNotFound";
        } else if (!calledTestCase.isWellFormed()) {
            mustExistAndBeValidMessage = "message.import.log.error.tc.callStep.wrongFormat";
        }
        return mustExistAndBeValidMessage;
    }

    public LogTrain createRequirementVersionChecks(RequirementVersionTarget target, RequirementVersion reqVersion) {
        LogTrain logs = new LogTrain();
        return this.basicReqVersionTests(target, reqVersion, logs);
    }

    public void createHighLevelRequirementChecks(RequirementVersionTarget target, LogTrain logs) {
        this.highLevelRequirementCreateTests(target, logs);
    }

    public LogTrain updateRequirementChecks(RequirementVersionTarget target, RequirementVersion reqVersion) {
        LogTrain logs = new LogTrain();
        this.checkRequirementVersionNumber(target, logs);
        if (logs.hasCriticalErrors()) {
            return logs;
        }
        this.basicReqVersionTests(target, reqVersion, logs);
        return logs;
    }

    private void checkRequirementVersionNumber(RequirementVersionTarget target, LogTrain logs) {
        if (target.getVersion() == null || target.getVersion() < 1) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.invalidVersionNumber", new Object[0]).build());
        }
    }

    private LogTrain basicReqVersionTests(RequirementVersionTarget target, RequirementVersion reqVersion, LogTrain logs) {
        this.checkMalformedPath(target, logs);
        if (logs.hasCriticalErrors()) {
            return logs;
        }
        this.checkProjectExists(target, logs);
        this.checkVersionPath(target, logs);
        this.checkVersionName(target, reqVersion, logs);
        this.checkVersionReference(target, reqVersion, logs);
        logs.append(this.checkCategoryAndFixIfNeeded(target, reqVersion));
        return logs;
    }

    private void highLevelRequirementCreateTests(RequirementVersionTarget target, LogTrain logs) {
        boolean needTestForCreate = target.getRequirement().isHighLevel();
        this.basicHighLevelRequirementTests(target, logs, needTestForCreate, true);
    }

    public void highLevelRequirementUpdateTests(RequirementVersionTarget target, LogTrain logs) {
        Requirement origRequirement;
        if (logs.hasCriticalErrors()) {
            return;
        }
        RequirementTarget reqTarget = target.getRequirement();
        Requirement requirement = origRequirement = reqTarget.getId() != null ? this.getRequirementLibraryFinderService().findRequirement(reqTarget.getId()) : null;
        if (origRequirement != null) {
            boolean needTestForUpdate = reqTarget.isHighLevel() ^ origRequirement.isHighLevel();
            this.basicHighLevelRequirementTests(target, logs, needTestForUpdate, false);
            this.requirementConvertTests(origRequirement, logs, target);
        }
    }

    private void requirementConvertTests(Requirement origRequirement, LogTrain logs, RequirementVersionTarget target) {
        if (!origRequirement.isHighLevel() && target.getRequirement().isHighLevel()) {
            this.checkReqAlreadyLinkedToHighLvlReq(origRequirement, logs, target);
        } else if (origRequirement.isHighLevel() && !target.getRequirement().isHighLevel()) {
            this.checkHighLvlReqHasLinkedLowLvlReqs(origRequirement, logs, target);
        }
    }

    private void checkReqAlreadyLinkedToHighLvlReq(Requirement origRequirement, LogTrain logs, RequirementVersionTarget target) {
        if (origRequirement.getHighLevelRequirement() != null) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warning.reqAlreadyLinkedToHighLvlReq", new Object[0]).withImpact("message.import.log.impact.requirement.highLvlReqReferenceLoss", new Object[0]).build());
        }
    }

    private void checkHighLvlReqHasLinkedLowLvlReqs(Requirement origRequirement, LogTrain logs, RequirementVersionTarget target) {
        List<Requirement> linkedLowLevelReqs = this.getHighLevelRequirementService().findStandardRequirementsByHighLvlReqId(origRequirement.getId());
        if (linkedLowLevelReqs != null && !linkedLowLevelReqs.isEmpty()) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warning.highLvlReqHasLinkedLowLvlReqs", new Object[0]).withImpact("message.import.log.impact.requirement.linkedLowLvlReqsLoss", new Object[0]).build());
        }
    }

    private void basicHighLevelRequirementTests(RequirementVersionTarget target, LogTrain logs, boolean needTest, boolean isCreateReq) {
        RequirementTarget reqTarget = target.getRequirement();
        if (reqTarget != null && needTest) {
            this.checkPremiumPluginIsInstalled(target, logs, isCreateReq);
            if (logs.hasCriticalErrors()) {
                return;
            }
            if (this.isChildRequirementByPath(target.getPath())) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.highLevelReqUnderAnotherReq", RequirementSheetColumn.REQ_PATH.header).build());
            }
        }
    }

    private void checkPremiumPluginIsInstalled(RequirementVersionTarget target, LogTrain logs, boolean isCreateReq) {
        if (!this.getPluginFinderService().isPremiumPluginInstalled()) {
            if (isCreateReq) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.highLevelReqNeedsPremiumPluginForCreate", new Object[0]).build());
            } else {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.highLevelReqNeedsPremiumPluginForUpdate", RequirementSheetColumn.REQ_PATH.header).build());
            }
        }
    }

    public boolean isChildRequirementByPath(String targetPath) {
        List paths = PathUtils.scanPath((String)targetPath);
        if (paths.size() > 2) {
            String parentPath = (String)paths.get(paths.size() - 2);
            RequirementTarget parentTarget = new RequirementTarget(parentPath);
            Long parentId = this.getRequirementLibraryFinderService().findNodeIdByPath(parentPath);
            return this.isReqParentARequirement(parentId, parentTarget);
        }
        return false;
    }

    private boolean isReqParentARequirement(Long parentId, RequirementTarget parentTarget) {
        return parentId != null && this.getRequirementLibraryFinderService().findRequirement(parentId) != null || parentId == null && !this.getModel().isRequirementFolder(parentTarget);
    }

    private void checkVersionPath(RequirementVersionTarget target, LogTrain logs) {
        if (!target.isWellFormed()) {
            return;
        }
        boolean hasTruncate = false;
        String path = target.getRequirement().getPath();
        String[] names = PathUtils.splitPath((String)path);
        int i = 1;
        while (i < names.length) {
            String name = names[i];
            if (name.length() > 255) {
                names[i] = StringUtils.abbreviate((String)name, (int)255);
                hasTruncate = true;
            }
            ++i;
        }
        if (hasTruncate) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", RequirementSheetColumn.REQ_PATH.header).build());
            this.rebuildPathAfterTrucate(target, names);
        }
    }

    private void rebuildPathAfterTrucate(RequirementVersionTarget target, String[] names) {
        target.getRequirement().setPath(PathUtils.buildPathFromParts((String[])names));
    }

    private void checkVersionReference(RequirementVersionTarget target, RequirementVersion reqVersion, LogTrain logs) {
        String reference = reqVersion.getReference();
        if (!StringUtils.isBlank((CharSequence)reference) && reference.length() > 50) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", RequirementSheetColumn.REQ_VERSION_REFERENCE.header).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
    }

    private void checkVersionName(RequirementVersionTarget target, RequirementVersion reqVersion, LogTrain logs) {
        String name = reqVersion.getName();
        if (name != null && name.length() > 255) {
            reqVersion.setName(StringUtils.abbreviate((String)name, (int)255));
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", RequirementSheetColumn.REQ_VERSION_NAME.header).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
    }

    private void checkProjectExists(RequirementVersionTarget target, LogTrain logs) {
        ProjectTargetStatus projectStatus;
        if (target.isWellFormed() && (projectStatus = this.getModel().getProjectStatus(target.getProject())).getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        }
    }

    private void checkMalformedPath(RequirementVersionTarget target, LogTrain logs) {
        if (!target.isWellFormed() || this.pathHasEmptyParts(target.getPath())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.field.malformedPath", target.getPath()).build());
        }
    }

    private boolean pathHasEmptyParts(String path) {
        String[] splits;
        String[] stringArray = splits = PathUtils.splitPath((String)path);
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.length() == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void logMustExistAndBeValidCalledTest(TestStepTarget target, ImportMode mode, LogTrain logs, String message) {
        switch (mode) {
            case CREATE: {
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage(message, new Object[0]).withImpact("message.import.log.impact.callStepImportedAsActionStep", new Object[0]).build());
                break;
            }
            default: {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage(message, new Object[0]).build());
            }
        }
    }

    LogTrain basicParameterChecks(ParameterTarget target) {
        String[] fieldPathErrorArgs = new String[]{"TC_OWNER_PATH"};
        return this.basicParameterChecks(target, fieldPathErrorArgs, "message.import.log.error.tc.tcOwnerNotFound");
    }

    public LogTrain basicParameterValueChecks(ParameterTarget target) {
        String[] fieldPathErrorArgs = new String[]{"TC_PARAMETER_OWNER_PATH"};
        return this.basicParameterChecks(target, fieldPathErrorArgs, "message.import.log.error.tc.paramValueParamOwnerNotFound");
    }

    private LogTrain basicParameterChecks(ParameterTarget target, String[] fieldPathErrorArgs, String ownerNotFoundMessage) {
        LogTrain logs = new LogTrain();
        String[] fieldNameErrorArgs = new String[]{"TC_PARAM_NAME"};
        TestCaseTarget testCase = target.getOwner();
        this.basicTestCaseTargetCheck(testCase, logs, fieldPathErrorArgs, ownerNotFoundMessage, target);
        this.basicParameterChecksValidateName(target, logs, fieldNameErrorArgs);
        return logs;
    }

    LogTrain basicDatasetCheck(DatasetTarget target) {
        LogTrain logs = new LogTrain();
        Object[] fieldNameErrorArgs = new String[]{"TC_DATASET_NAME"};
        TestCaseTarget testCase = target.getTestCase();
        this.basicTestCaseTargetCheck(testCase, logs, new String[]{testCase.getPath()}, "message.import.log.error.tc.notFound", target);
        String name = target.getName();
        if (name != null && name.length() > 255) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", fieldNameErrorArgs).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.mandatoryColumn", fieldNameErrorArgs).build());
        }
        return logs;
    }

    private <T extends Target & WithPath> void basicTestCaseTargetCheck(TestCaseTarget testCase, LogTrain logs, String[] fieldPathErrorArgs, String tcNotFoundMessage, T target) {
        ProjectTargetStatus projectStatus;
        if (!testCase.isWellFormed()) {
            logs.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.field.malformedPath", fieldPathErrorArgs));
        }
        TargetStatus tcStatus = this.getModel().getStatus(testCase);
        if (tcStatus.status == Existence.TO_BE_DELETED || tcStatus.status == Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage(tcNotFoundMessage, new Object[0]).build());
        }
        if (testCase.isWellFormed() && (projectStatus = this.getModel().getProjectStatus(((WithPath)target).getProject())).getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        }
    }

    private void basicParameterChecksValidateName(ParameterTarget target, LogTrain logs, String[] fieldNameErrorArgs) {
        String name = target.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            logs.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.mandatoryColumn", fieldNameErrorArgs));
        } else {
            if (name.length() > 255) {
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", fieldNameErrorArgs).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
            }
            String regex = "^[A-Za-z0-9_-]{1,255}$";
            name = name.trim();
            target.setName(name);
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(name);
            if (!StringUtils.isBlank((CharSequence)name) && !m.matches() && name.length() < 256) {
                logs.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.tc.param.wrongFormat", fieldNameErrorArgs));
            }
        }
    }

    private LogTrain checkNatureAndTypeAndFixIfNeeded(TestCaseTarget target, TestCase testCase, TestCaseImportValidationBag validationBag) {
        ProjectTargetStatus projectStatus;
        LogTrain logs = new LogTrain();
        if (target.isWellFormed() && (projectStatus = this.getModel().getProjectStatus(target.getProject())).getStatus() == Existence.EXISTS) {
            if (!this.natureDefinedAndConsistent(testCase, validationBag.consistentNatures())) {
                testCase.setNature(validationBag.defaultNature());
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.natureinvalid", target.getPath()).withImpact("message.import.log.impact.useDefaultValue", new Object[0]).build());
            }
            if (!this.typeDefinedAndConsistent(testCase, validationBag.consistentTypes())) {
                testCase.setType(validationBag.defaultType());
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.typeinvalid", target.getPath()).withImpact("message.import.log.impact.useDefaultValue", new Object[0]).build());
            }
        }
        return logs;
    }

    private LogTrain checkCategoryAndFixIfNeeded(RequirementVersionTarget target, RequirementVersion reqVersion) {
        ProjectTargetStatus projectStatus;
        LogTrain logs = new LogTrain();
        if (target.isWellFormed() && (projectStatus = this.getModel().getProjectStatus(target.getProject())).getStatus() == Existence.EXISTS && !this.categoryDefinedAndConsistent(projectStatus, reqVersion)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.categoryinvalid", target.getPath()).withImpact("message.import.log.impact.useDefaultValue", new Object[0]).build());
        }
        return logs;
    }

    private boolean categoryDefinedAndConsistent(TargetStatus projectStatus, RequirementVersion reqVersion) {
        InfoListItem category = reqVersion.getCategory();
        boolean isConsistent = category != null ? this.getInfoListItemService().isCategoryConsistent(projectStatus.getId(), category.getCode()) : false;
        return isConsistent;
    }

    private boolean natureDefinedAndConsistent(TestCase testCase, Set<String> consistentNatures) {
        InfoListItem nature = testCase.getNature();
        if (nature == null) {
            return true;
        }
        return consistentNatures.contains(nature.getCode());
    }

    private boolean typeDefinedAndConsistent(TestCase testCase, Set<String> consistentTypes) {
        InfoListItem type = testCase.getType();
        if (type == null) {
            return true;
        }
        return consistentTypes.contains(type.getCode());
    }
}

