/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.gridconfiguration.GridColumnDisplayConfiguration;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.grid.ColumnIds;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.batchexport.models.TestCaseModel;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.project.ProjectFinder;

@Component
@Scope(value="prototype")
class SimpleExcelExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleExcelExporter.class);
    private static final String DATA_EXCEED_MAX_CELL_SIZE_MESSAGE = "some data exceed the maximum size of an excel cell";
    private static final String TC_SHEET = TemplateWorksheet.TEST_CASES_SHEET.sheetName;
    private static final String STATUS = "test-case.status.";
    private static final String IMPORTANCE = "test-case.importance.";
    private static final String AUTOMATABLE = "test-case.automatable.";
    private static final String REQUEST_STATUS = "automation-request.request_status.";
    private static final String LABEL_NO = "label.No";
    private static final String LABEL_YES = "label.Yes";
    List<ColumnIds> customColumnOrder = new ArrayList<ColumnIds>(Arrays.asList(ColumnIds.PROJECT_NAME, ColumnIds.ID, ColumnIds.REFERENCE, ColumnIds.NAME, ColumnIds.TEST_CASE_STATUS, ColumnIds.TEST_CASE_IMPORTANCE, ColumnIds.TEST_CASE_NATURE, ColumnIds.TEST_CASE_TYPE, ColumnIds.TEST_CASE_AUTOMATION_INDICATOR, ColumnIds.CREATED_BY, ColumnIds.LAST_MODIFIED_BY));
    List<ColumnIds> optionalColumns = new ArrayList<ColumnIds>(Arrays.asList(ColumnIds.MILESTONES, ColumnIds.NUMBER_OF_ATTACHMENTS, ColumnIds.COVERAGE_OF_ASSOCIATED_REQUIREMENTS, ColumnIds.NUMBER_OF_TEST_STEPS, ColumnIds.DATASETS, ColumnIds.NUMBER_OF_ASSOCIATED_ITERATIONS));
    List<ColumnIds> premiumColumnList = new ArrayList<ColumnIds>(Arrays.asList(ColumnIds.PROJECT_NAME, ColumnIds.ID, ColumnIds.REFERENCE, ColumnIds.NAME, ColumnIds.TEST_CASE_STATUS, ColumnIds.TEST_CASE_IMPORTANCE, ColumnIds.TEST_CASE_NATURE, ColumnIds.TEST_CASE_TYPE, ColumnIds.TEST_CASE_KIND, ColumnIds.DESCRIPTION, ColumnIds.TEST_CASE_AUTOMATION_INDICATOR, ColumnIds.TEST_CASE_AUTOMATION_PRIORITY, ColumnIds.TRANSMITTED_ON, ColumnIds.REQUEST_STATUS, ColumnIds.TEST_CASE_HASAUTOSCRIPT, ColumnIds.AUTOMATED_TEST_TECHNOLOGY, ColumnIds.TEST_CASE_HAS_BOUND_SCM_REPOSITORY, ColumnIds.TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE, ColumnIds.MILESTONES_LABELS, ColumnIds.MILESTONES_STATUS, ColumnIds.MILESTONES_END_DATE, ColumnIds.CREATED_ON, ColumnIds.CREATED_BY, ColumnIds.LAST_MODIFIED_ON, ColumnIds.LAST_MODIFIED_BY, ColumnIds.MILESTONES, ColumnIds.NUMBER_OF_ATTACHMENTS, ColumnIds.COVERAGE_OF_ASSOCIATED_REQUIREMENTS, ColumnIds.NUMBER_OF_TEST_STEPS, ColumnIds.PARAM_COUNT, ColumnIds.DATASETS, ColumnIds.CALL_STEP_COUNT, ColumnIds.NUMBER_OF_ASSOCIATED_ITERATIONS, ColumnIds.EXECUTION_COUNT, ColumnIds.ISSUE_COUNT, ColumnIds.DRAFTED_BY_AI));
    protected Workbook workbook;
    protected boolean milestonesEnabled;
    private MessageSource messageSource;
    private String errorCellTooLargeMessage;
    private Integer projectsAllowWorkflow;
    @Inject
    private ProjectFinder projectFinder;
    private final GridConfigurationService gridConfigurationService;
    private final PluginFinderService pluginFinderService;
    private final Map<Long, Integer> cufColumnsById = new HashMap<Long, Integer>();

    public SimpleExcelExporter(FeatureManager featureManager, MessageSource messageSource, GridConfigurationService gridConfigurationService, PluginFinderService pluginFinderService) {
        this.milestonesEnabled = featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
        this.gridConfigurationService = gridConfigurationService;
        this.pluginFinderService = pluginFinderService;
        this.getMessageSource(messageSource);
    }

    @PostConstruct
    public void init() {
        this.createWorkbook();
        this.getProjectsAllowWorkflow();
    }

    void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.errorCellTooLargeMessage = this.messageSource.getMessage("test-case.export.errors.celltoolarge", null, LocaleContextHolder.getLocale());
    }

    public void simpleAppendToWorkbook(ExportModel model, boolean keepRteFormat, boolean simplifiedColumnDisplayForTest) {
        if (!keepRteFormat) {
            this.removeRteSimpleFormat(model);
        }
        this.appendSimpleTestCases(model, simplifiedColumnDisplayForTest);
    }

    private void removeRteSimpleFormat(ExportModel model) {
        this.removeRteFormatFromTestCases(model.getTestCases());
    }

    private void removeRteFormatFromTestCases(List<TestCaseModel> testCases) {
        for (TestCaseModel tc : testCases) {
            tc.setDescription(this.removeHtml(tc.getDescription()));
            tc.setPrerequisite(this.removeHtml(tc.getPrerequisite()));
            for (ExportModel.CustomField cf : tc.getCufs()) {
                cf.setValue(this.removeHtml(cf.getValue()));
            }
        }
    }

    private String removeHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        return html.replaceAll("(?s)<[^>]*>(\\s*<[^>]*>)*", "");
    }

    public File print() {
        try {
            File temp = File.createTempFile("tc_export_", "xls");
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            this.workbook.write((OutputStream)fos);
            fos.close();
            return temp;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void appendSimpleTestCases(ExportModel model, boolean simplifiedColumnDisplayForTest) {
        List<TestCaseModel> testCaseModels = model.getTestCases();
        Sheet testCaseSheet = this.workbook.getSheet(TC_SHEET);
        int rowIndex = testCaseSheet.getLastRowNum() + 1;
        List<String> activeColumns = this.gridConfigurationService.findActiveColumnIdsForUser("test-case-search");
        List<ExportModel.CustomField> allCufs = testCaseModels.stream().flatMap(testCaseModel -> testCaseModel.getCufs().stream()).sorted(Comparator.comparing(cuf -> cuf.getLabel().toLowerCase())).toList();
        for (TestCaseModel testCaseModel2 : testCaseModels) {
            Row row = testCaseSheet.createRow(rowIndex);
            try {
                this.insertValues(row, testCaseModel2, activeColumns, simplifiedColumnDisplayForTest);
                this.appendCustomFields(row, testCaseModel2.getCufs(), activeColumns, allCufs);
                ++rowIndex;
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("cannot export content for test case '{}': {}", new Object[]{testCaseModel2.getId(), DATA_EXCEED_MAX_CELL_SIZE_MESSAGE});
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("", (Throwable)e);
                }
                testCaseSheet.removeRow(row);
                row = testCaseSheet.createRow(rowIndex);
                row.createCell(0).setCellValue(this.errorCellTooLargeMessage);
            }
        }
    }

    private void createWorkbook() {
        HSSFWorkbook wb = new HSSFWorkbook();
        wb.createSheet(TC_SHEET);
        this.workbook = wb;
    }

    public void createHeaders(boolean simplifiedColumnDisplayForTest) {
        Sheet dsSheet = this.workbook.getSheet(TC_SHEET);
        Row h = dsSheet.createRow(0);
        int cIdx = 0;
        List<String> activeColumns = this.gridConfigurationService.findActiveColumnIdsForUser("test-case-search");
        List<String> columnsToProcess = this.columnList(activeColumns, simplifiedColumnDisplayForTest);
        Map<String, String> customLabels = this.createColumnIdsMap();
        for (String columnName : columnsToProcess) {
            this.createTcSimpleSheetHeadersForActiveColumns(h, cIdx, columnName, customLabels);
            ++cIdx;
        }
    }

    private List<String> columnList(List<String> activeColumns, boolean simplifiedColumnDisplayForTest) {
        ArrayList<ColumnIds> columnsToProcess = new ArrayList<ColumnIds>(this.customColumnOrder);
        List<ColumnIds> initialList = this.genericColumnList(activeColumns, columnsToProcess, simplifiedColumnDisplayForTest);
        List<String> columnIdStrings = initialList.stream().map(ColumnIds::getColumnId).collect(Collectors.toList());
        if (this.pluginFinderService.isPremiumPluginInstalled() && !activeColumns.isEmpty()) {
            columnIdStrings.retainAll(activeColumns);
            activeColumns.forEach(column -> {
                if (column.startsWith("cuf|")) {
                    columnIdStrings.add((String)column);
                }
            });
        }
        return columnIdStrings;
    }

    private List<ColumnIds> genericColumnList(List<String> activeColumns, List<ColumnIds> columnsToProcess, boolean simplifiedColumnDisplayForTest) {
        if (!this.pluginFinderService.isPremiumPluginInstalled()) {
            if (!simplifiedColumnDisplayForTest) {
                columnsToProcess.addAll(this.optionalColumns);
            }
            columnsToProcess.add(ColumnIds.DRAFTED_BY_AI);
        } else if (!activeColumns.isEmpty()) {
            columnsToProcess = this.premiumColumnList;
        }
        if (this.projectsAllowWorkflow <= 0) {
            columnsToProcess.remove((Object)ColumnIds.TEST_CASE_AUTOMATION_INDICATOR);
        }
        if (!this.milestonesEnabled) {
            columnsToProcess.removeAll(ColumnIds.COLUMN_IDS_LINKED_TO_MILESTONES);
        }
        return columnsToProcess;
    }

    private void createTcSimpleSheetHeadersForActiveColumns(Row h, int cIdx, String activeColumn, Map<String, String> customLabels) {
        if (customLabels.containsKey(activeColumn)) {
            h.createCell(cIdx).setCellValue(this.getMessage(customLabels.get(activeColumn)));
        } else if (activeColumn.startsWith("cuf|")) {
            this.gridConfigurationService.registerCuf(h, cIdx, activeColumn, this.cufColumnsById);
        }
    }

    private Map<String, String> createColumnIdsMap() {
        HashMap<String, String> customLabels = new HashMap<String, String>();
        ArrayList<ColumnIds> columnsToProcess = new ArrayList<ColumnIds>(this.premiumColumnList);
        if (!this.milestonesEnabled) {
            columnsToProcess.removeAll(ColumnIds.COLUMN_IDS_LINKED_TO_MILESTONES);
        }
        if (this.projectsAllowWorkflow <= 0) {
            columnsToProcess.remove((Object)ColumnIds.TEST_CASE_AUTOMATION_INDICATOR);
        }
        for (ColumnIds columnName : columnsToProcess) {
            this.putCustomLabel(customLabels, columnName);
        }
        return customLabels;
    }

    private void putCustomLabel(Map<String, String> customLabels, ColumnIds columnId) {
        customLabels.put(columnId.getColumnId(), columnId.getLabel());
    }

    private void insertValues(Row row, TestCaseModel tcm, List<String> activeColumns, Boolean simplifiedColumnDisplayForTest) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("Importance", this.handleMessages(IMPORTANCE + tcm.getWeight().toString()));
        fieldValues.put("Nature", this.handleMessages(tcm.getNature().getLabel()));
        fieldValues.put("Type", this.handleMessages(tcm.getType().getLabel()));
        fieldValues.put("Status", this.handleMessages(STATUS + tcm.getStatus().toString()));
        fieldValues.put("Automatable", this.handleMessages(AUTOMATABLE + tcm.getAutomatable().name()));
        fieldValues.put("Description", this.handleMessages("".equals(tcm.getDescription()) ? LABEL_NO : LABEL_YES));
        fieldValues.put("RequestStatus", tcm.getAutomationRequestStatus() != null ? this.handleMessages(REQUEST_STATUS + tcm.getAutomationRequestStatus()) : "");
        fieldValues.put("HasAutoScript", this.handleMessages(tcm.getHasAutoScript() != null ? LABEL_YES : LABEL_NO));
        fieldValues.put("AutomatedTestTechno", tcm.getAutomatedTestTechno() != null ? tcm.getAutomatedTestTechno() : this.handleMessages("search.requirement.association.childRequirement.none"));
        fieldValues.put("HasBoundScmRepository", this.handleMessages(tcm.getHasBoundScmRepository() != null ? LABEL_YES : LABEL_NO));
        fieldValues.put("HasBoundAutomatedTestReference", this.handleMessages(tcm.getHasBoundAutomatedTestReference() != null ? LABEL_YES : LABEL_NO));
        fieldValues.put("DraftedByAi", this.handleMessages(tcm.getDraftedByAi() ? LABEL_YES : LABEL_NO));
        Map<String, BiConsumer<Row, Integer>> columnValueHandlers = this.createColumnValueHandlers(tcm, fieldValues);
        List<String> columnsToProcess = this.columnList(activeColumns, simplifiedColumnDisplayForTest);
        int cIdx = 0;
        for (String columnName : columnsToProcess) {
            if (columnValueHandlers.containsKey(columnName)) {
                columnValueHandlers.get(columnName).accept(row, cIdx);
            }
            ++cIdx;
        }
    }

    private Map<String, BiConsumer<Row, Integer>> createColumnValueHandlers(TestCaseModel tcm, Map<String, String> fieldValues) {
        HashMap<String, BiConsumer<Row, Integer>> handlers = new HashMap<String, BiConsumer<Row, Integer>>();
        this.putCustomHandlers(handlers, ColumnIds.PROJECT_NAME, tcm.getProjectName());
        this.putCustomHandlers(handlers, ColumnIds.ID, tcm.getId());
        this.putCustomHandlers(handlers, ColumnIds.REFERENCE, tcm.getReference());
        this.putCustomHandlers(handlers, ColumnIds.NAME, tcm.getName());
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_STATUS, fieldValues.get("Status"));
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_IMPORTANCE, fieldValues.get("Importance"));
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_NATURE, fieldValues.get("Nature"));
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_TYPE, fieldValues.get("Type"));
        this.putCustomHandlers(handlers, ColumnIds.CREATED_ON, this.gridConfigurationService.reformatSimpleDateForExport(tcm.getCreatedOn()));
        this.putCustomHandlers(handlers, ColumnIds.CREATED_BY, tcm.getCreatedBy());
        this.putCustomHandlers(handlers, ColumnIds.LAST_MODIFIED_BY, tcm.getLastModifiedBy());
        this.putCustomHandlers(handlers, ColumnIds.NUMBER_OF_ATTACHMENTS, tcm.getNbAttachments());
        this.putCustomHandlers(handlers, ColumnIds.DATASETS, tcm.getDatasetCount());
        this.putCustomHandlers(handlers, ColumnIds.NUMBER_OF_TEST_STEPS, tcm.getTestStepCount());
        this.putCustomHandlers(handlers, ColumnIds.COVERAGE_OF_ASSOCIATED_REQUIREMENTS, tcm.getNbReq());
        this.putCustomHandlers(handlers, ColumnIds.NUMBER_OF_ASSOCIATED_ITERATIONS, tcm.getNbIterations());
        this.putCustomHandlers(handlers, ColumnIds.PARAM_COUNT, tcm.getParameter());
        this.putCustomHandlers(handlers, ColumnIds.EXECUTION_COUNT, tcm.getExecutionCount());
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_KIND, this.handleMessages(tcm.getTestCaseKind().getI18nKey()));
        this.putCustomHandlers(handlers, ColumnIds.DESCRIPTION, fieldValues.get("Description"));
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_AUTOMATION_PRIORITY, tcm.getPriority());
        this.putCustomHandlers(handlers, ColumnIds.TRANSMITTED_ON, this.gridConfigurationService.reformatSimpleDateForExport(tcm.getTransmissionDate()));
        this.putCustomHandlers(handlers, ColumnIds.REQUEST_STATUS, fieldValues.get("RequestStatus"));
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_HASAUTOSCRIPT, fieldValues.get("HasAutoScript"));
        this.putCustomHandlers(handlers, ColumnIds.AUTOMATED_TEST_TECHNOLOGY, fieldValues.get("AutomatedTestTechno"));
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_HAS_BOUND_SCM_REPOSITORY, fieldValues.get("HasBoundScmRepository"));
        this.putCustomHandlers(handlers, ColumnIds.TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE, fieldValues.get("HasBoundAutomatedTestReference"));
        this.putCustomHandlers(handlers, ColumnIds.LAST_MODIFIED_ON, this.gridConfigurationService.reformatSimpleDateForExport(tcm.getLastModifiedOn()));
        this.putCustomHandlers(handlers, ColumnIds.CALL_STEP_COUNT, tcm.getCalledStepCount());
        this.putCustomHandlers(handlers, ColumnIds.ISSUE_COUNT, tcm.getIssueCount());
        if (this.milestonesEnabled) {
            this.putCustomHandlers(handlers, ColumnIds.MILESTONES_LABELS, this.gridConfigurationService.reformatLabelForExport(tcm.getMilestone()));
            this.putCustomHandlers(handlers, ColumnIds.MILESTONES_STATUS, this.reformatStatusForExport(tcm.getMilestoneStatus()));
            this.putCustomHandlers(handlers, ColumnIds.MILESTONES_END_DATE, this.gridConfigurationService.reformatMultipleDateForExport(tcm.getMilestoneEndDate()));
            this.putCustomHandlers(handlers, ColumnIds.MILESTONES, tcm.getMilestonesCount());
        }
        handlers.put(ColumnIds.TEST_CASE_AUTOMATION_INDICATOR.getColumnId(), (row, colIndex) -> {
            if (this.projectsAllowWorkflow > 0) {
                if (tcm.getAllowAutomationWorkflow()) {
                    row.createCell(colIndex.intValue()).setCellValue((String)fieldValues.get("Automatable"));
                } else {
                    row.createCell(colIndex.intValue()).setCellValue("-");
                }
            }
        });
        this.putCustomHandlers(handlers, ColumnIds.DRAFTED_BY_AI, fieldValues.get("DraftedByAi"));
        return handlers;
    }

    private void appendCustomFields(Row row, List<ExportModel.CustomField> cufs, List<String> activeColumns, List<ExportModel.CustomField> allCufs) {
        for (ExportModel.CustomField allCuf : allCufs) {
            Integer index;
            Long cufId = allCuf.getCufId();
            String columnName = GridColumnDisplayConfiguration.getCufColumnNameFromCufId((Long)cufId);
            if (!activeColumns.contains(columnName) || (index = this.cufColumnsById.get(cufId)) == null) continue;
            this.setCufCellValue(row, cufs, cufId, index);
        }
    }

    private void setCufCellValue(Row row, List<ExportModel.CustomField> cufs, Long cufId, Integer index) {
        ExportModel.CustomField cuf = this.gridConfigurationService.findCufById(cufs, cufId, index);
        if (cuf != null) {
            this.setCellValue(cuf, index, row);
        }
    }

    private void setCellValue(ExportModel.CustomField cuf, Integer idx, Row r) {
        Cell c = r.createCell(idx.intValue());
        String value = this.gridConfigurationService.nullSafeValue(cuf);
        switch (cuf.getType()) {
            case NUMERIC: {
                value = NumericCufHelper.formatOutputNumericCufValue(value);
                break;
            }
            case CHECKBOX: {
                value = this.handleMessages("label." + StringUtils.capitalize((String)value));
                break;
            }
            case TAG: {
                value = this.gridConfigurationService.reformatLabelForExport(value);
                break;
            }
        }
        c.setCellValue(value);
    }

    private void putCustomHandlers(Map<String, BiConsumer<Row, Integer>> handlers, ColumnIds columnId, Object value) {
        handlers.put(columnId.getColumnId(), (row, colIndex) -> {
            Cell cell = row.createCell(colIndex.intValue());
            if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Integer) {
                cell.setCellValue((double)((Integer)value).intValue());
            } else if (value instanceof Long) {
                cell.setCellValue((double)((Long)value).longValue());
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
            }
        });
    }

    private String reformatStatusForExport(String concatenatedStatus) {
        List<Object> formattedStatus = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)concatenatedStatus)) {
            String[] statuses = concatenatedStatus.split("\\|");
            formattedStatus = Arrays.stream(statuses).map(st -> this.handleMessages("milestone.status." + st)).toList();
        }
        return String.join((CharSequence)", ", formattedStatus);
    }

    public void getMessageSource(MessageSource source) {
        this.messageSource = source;
    }

    public Integer getProjectsAllowWorkflow() {
        this.projectsAllowWorkflow = this.projectFinder.countProjectsAllowAutomationWorkflow();
        return this.projectsAllowWorkflow;
    }

    private String getMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, null, locale);
    }

    private String handleMessages(String key) {
        try {
            return this.getMessage(key);
        }
        catch (NoSuchMessageException e) {
            LOGGER.debug("No corresponding message for key: {}", new Object[]{key, e});
            return key;
        }
    }
}

