/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.assistance.candidate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testcase.SuggestionStatus;
import org.squashtest.tm.domain.testcase.TestAutomationCandidate;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.dto.testautomation.AlreadyDecidedTestCandidatesDto;
import org.squashtest.tm.service.internal.dto.testautomation.CandidateApproveRequestDto;
import org.squashtest.tm.service.internal.repository.TestAutomationCandidateDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.testautomation.assistance.candidate.TestCandidateDecisionService;
import org.squashtest.tm.service.testautomation.assistance.candidate.TestCandidatePermissionEvaluationService;

@Service
@Transactional
public class TestCandidateDecisionServiceImpl
implements TestCandidateDecisionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCandidateDecisionServiceImpl.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final TestAutomationCandidateDao testAutomationCandidateDao;
    private final TestCandidatePermissionEvaluationService testCandidatePermissionEvaluationService;

    public TestCandidateDecisionServiceImpl(TestAutomationCandidateDao testAutomationCandidateDao, TestCandidatePermissionEvaluationService testCandidatePermissionEvaluationService) {
        this.testAutomationCandidateDao = testAutomationCandidateDao;
        this.testCandidatePermissionEvaluationService = testCandidatePermissionEvaluationService;
    }

    @Override
    public List<AlreadyDecidedTestCandidatesDto> approveUndecidedCandidates(List<CandidateApproveRequestDto> candidates) {
        List<Long> testCaseIds = candidates.stream().map(CandidateApproveRequestDto::testCaseId).toList();
        if (!this.testCandidatePermissionEvaluationService.hasPermissionsOnTestCases(testCaseIds)) {
            throw new AccessDeniedException("No permission to approve automation candidates on some test cases");
        }
        List<AlreadyDecidedTestCandidatesDto> alreadyDecidedTestCandidates = this.testAutomationCandidateDao.findAlreadyDecidedTests(testCaseIds);
        Set alreadyApprovedIds = alreadyDecidedTestCandidates.stream().map(AlreadyDecidedTestCandidatesDto::testCaseId).collect(Collectors.toSet());
        Map<Long, Integer> manualPriorityByTcId = candidates.stream().filter(req -> !alreadyApprovedIds.contains(req.testCaseId())).filter(req -> req.priority() != null).collect(Collectors.toMap(CandidateApproveRequestDto::testCaseId, CandidateApproveRequestDto::priority));
        List<Long> toApproveTestCaseIds = candidates.stream().map(CandidateApproveRequestDto::testCaseId).filter(id -> !alreadyApprovedIds.contains(id)).toList();
        if (toApproveTestCaseIds.isEmpty()) {
            LOGGER.debug("No undecided candidates to approve", new Object[0]);
            return alreadyDecidedTestCandidates;
        }
        List<TestAutomationCandidate> candidatesToApprove = this.testAutomationCandidateDao.findCandidatesWithRelations(toApproveTestCaseIds);
        String decidedBy = UserContextHolder.getUsername();
        Date now = new Date();
        HibernateConfig.enableBatch(this.entityManager, 50);
        try {
            for (TestAutomationCandidate candidate : candidatesToApprove) {
                TestCase tc = candidate.getTestCase();
                int decidedPriority = manualPriorityByTcId.getOrDefault(tc.getId(), candidate.getPriorityScore());
                if (tc.getProject().isAllowAutomationWorkflow()) {
                    AutomationRequest ar = this.getOrCreateAutomationRequest(tc);
                    ar.setAutomationPriority(Integer.valueOf(decidedPriority));
                    tc.setAutomatable(TestCaseAutomatable.Y);
                }
                this.approve(candidate, decidedBy, now, decidedPriority);
            }
            this.entityManager.flush();
            this.entityManager.clear();
        }
        finally {
            HibernateConfig.disableBatch(this.entityManager);
        }
        return alreadyDecidedTestCandidates;
    }

    @Override
    public void resetDecidedSuggestion(TestCaseAutomatable testCaseAutomatable, long testCaseId) {
        if (testCaseAutomatable != TestCaseAutomatable.M) {
            return;
        }
        this.testAutomationCandidateDao.findCandidateByTestCaseId(testCaseId).ifPresent(candidate -> {
            candidate.setSuggestionStatus(SuggestionStatus.SUGGESTED);
            candidate.setDecidedBy(null);
            candidate.setDecidedOn(null);
            candidate.setDecidedPriority(null);
        });
    }

    @Override
    public List<AlreadyDecidedTestCandidatesDto> rejectUndecidedCandidates(List<Long> testCaseIds) {
        if (!this.testCandidatePermissionEvaluationService.hasPermissionsOnTestCases(testCaseIds)) {
            throw new AccessDeniedException("No permission to reject automation candidates on some test cases");
        }
        List<AlreadyDecidedTestCandidatesDto> alreadyDecidedTestCandidates = this.testAutomationCandidateDao.findAlreadyDecidedTests(testCaseIds);
        Set alreadyRejectedIds = alreadyDecidedTestCandidates.stream().map(AlreadyDecidedTestCandidatesDto::testCaseId).collect(Collectors.toSet());
        List<Long> toRejectTestCaseIds = testCaseIds.stream().filter(id -> !alreadyRejectedIds.contains(id)).toList();
        if (toRejectTestCaseIds.isEmpty()) {
            LOGGER.debug("No undecided candidates to reject", new Object[0]);
            return alreadyDecidedTestCandidates;
        }
        this.testAutomationCandidateDao.rejectCandidates(toRejectTestCaseIds, UserContextHolder.getUsername());
        return alreadyDecidedTestCandidates;
    }

    private AutomationRequest getOrCreateAutomationRequest(TestCase tc) {
        AutomationRequest ar = tc.getAutomationRequest();
        if (ar != null) {
            return ar;
        }
        ar = new AutomationRequest();
        ar.notifyAssociatedWithProject(tc.getProject());
        ar.setTestCase(tc);
        tc.setAutomationRequest(ar);
        this.entityManager.persist((Object)ar);
        return ar;
    }

    private void approve(TestAutomationCandidate candidate, String decidedBy, Date now, int finalPriority) {
        candidate.setSuggestionStatus(SuggestionStatus.APPROVED);
        candidate.setDecidedBy(decidedBy);
        candidate.setDecidedOn(now);
        candidate.setDecidedPriority(Integer.valueOf(finalPriority));
    }
}

