/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Session;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.project.GenericLibrary;
import org.squashtest.tm.service.annotation.CacheScope;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.library.NextLayerFeeder;
import org.squashtest.tm.service.internal.library.NodePairing;
import org.squashtest.tm.service.internal.library.PasteOperation;
import org.squashtest.tm.service.internal.repository.EntityDao;

public class PasteStrategy<CONTAINER extends NodeContainer<NODE>, NODE extends TreeNode> {
    private static final Integer WHATEVER_POSITION = null;
    private static final String UNCHECKED = "unchecked";
    private Provider<? extends PasteOperation> nextLayersOperationFactory;
    private Provider<? extends PasteOperation> firstLayerOperationFactory;
    @Inject
    private Provider<NextLayerFeeder> nextLayerFeederOperationFactory;
    private PasteOperation firstOperation;
    private PasteOperation nextsOperation;
    private EntityDao<CONTAINER> containerDao;
    private Class<NODE> nodeType;
    @PersistenceContext
    private EntityManager em;
    private List<NODE> outputList;
    private Collection<NodePairing> nextLayer;
    private Collection<NodePairing> sourceLayer;
    private List<NODE> pastedNodes;
    private ClipboardPayload clipboardPayload;

    public <R extends EntityDao<CONTAINER>> void setContainerDao(R containerDao) {
        this.containerDao = containerDao;
    }

    public void setNextLayersOperationFactory(Provider<? extends PasteOperation> nextLayersOperationFactory) {
        this.nextLayersOperationFactory = nextLayersOperationFactory;
    }

    public void setFirstLayerOperationFactory(Provider<? extends PasteOperation> firstLayerOperationFactory) {
        this.firstLayerOperationFactory = firstLayerOperationFactory;
    }

    @CacheScope
    public List<NODE> pasteNodes(long containerId, ClipboardPayload clipboardPayload) {
        return this.internalPasteNodes(containerId, clipboardPayload, WHATEVER_POSITION);
    }

    @CacheScope
    public List<NODE> pasteNodes(long containerId, ClipboardPayload clipboardPayload, Integer position) {
        return this.internalPasteNodes(containerId, clipboardPayload, position);
    }

    private List<NODE> internalPasteNodes(long containerId, ClipboardPayload clipboardPayload, Integer position) {
        this.init(containerId, clipboardPayload);
        this.processFirstLayer(position);
        while (!this.nextLayer.isEmpty()) {
            this.removeProcessedNodesFromCache();
            this.shiftToNextLayer();
            this.processLayer();
        }
        this.reindexAfterCopy();
        return this.outputList;
    }

    private void init(long containerId, ClipboardPayload clipboardPayload) {
        this.firstOperation = this.createFirstLayerOperation();
        this.nextsOperation = this.createNextLayerOperation();
        this.outputList = new ArrayList<NODE>(clipboardPayload.getSelectedNodeIds().size());
        this.nextLayer = new ArrayList<NodePairing>();
        this.pastedNodes = new ArrayList<NODE>();
        this.clipboardPayload = clipboardPayload;
        this.sourceLayer = new HashSet<NodePairing>();
        NodeContainer container = (NodeContainer)this.containerDao.loadContainerForPaste(containerId);
        NodePairing pairing = new NodePairing((NodeContainer<TreeNode>)container);
        for (Long contentId : clipboardPayload.getSelectedNodeIds()) {
            TreeNode srcNode = (TreeNode)this.em.find(this.nodeType, (Object)contentId);
            pairing.addContent(srcNode);
        }
        this.sourceLayer.add(pairing);
    }

    private void shiftToNextLayer() {
        this.sourceLayer = this.nextLayer;
        this.nextLayer = new ArrayList<NodePairing>();
    }

    private void processFirstLayer(Integer position) {
        NodePairing pairing = this.sourceLayer.iterator().next();
        NodeContainer<TreeNode> container = pairing.getContainer();
        List<TreeNode> newContent = pairing.getNewContent();
        for (TreeNode srcNode : newContent) {
            TreeNode outputNode = this.firstOperation.performOperation(srcNode, container, position);
            this.outputList.add(outputNode);
            this.pastedNodes.add(outputNode);
            if (position != null) {
                position = position + 1;
            }
            if (!this.firstOperation.isOkToGoDeeper()) continue;
            this.appendNextLayerNodes(srcNode, outputNode);
        }
    }

    private void processLayer() {
        for (NodePairing pairing : this.sourceLayer) {
            NodeContainer<TreeNode> destination = pairing.getContainer();
            List<TreeNode> sources = pairing.getNewContent();
            for (TreeNode source : sources) {
                if (this.nodeWasAlreadyPasted(source)) continue;
                TreeNode outputNode = this.nextsOperation.performOperation(source, destination, WHATEVER_POSITION);
                this.pastedNodes.add(outputNode);
                if (!this.nextsOperation.isOkToGoDeeper()) continue;
                this.appendNextLayerNodes(source, outputNode);
            }
        }
    }

    private PasteOperation createNextLayerOperation() {
        return (PasteOperation)this.nextLayersOperationFactory.get();
    }

    private PasteOperation createFirstLayerOperation() {
        return (PasteOperation)this.firstLayerOperationFactory.get();
    }

    private void appendNextLayerNodes(TreeNode sourceNode, TreeNode destNode) {
        NextLayerFeeder feeder = (NextLayerFeeder)this.nextLayerFeederOperationFactory.get();
        feeder.feedNextLayer(destNode, sourceNode, this.nextLayer, this.outputList, this.clipboardPayload);
    }

    private void reindexAfterCopy() {
        ((Session)this.em.unwrap(Session.class)).flush();
    }

    private void removeProcessedNodesFromCache() {
        this.em.flush();
        HashSet<TreeNode> nextNodes = new HashSet<TreeNode>();
        for (NodePairing nextPairing : this.nextLayer) {
            nextNodes.add((TreeNode)nextPairing.getContainer());
            nextNodes.addAll(nextPairing.getNewContent());
        }
        Session session = (Session)this.em.unwrap(Session.class);
        for (NodePairing processed : this.sourceLayer) {
            HashSet<Object> toEvict = new HashSet<Object>();
            toEvict.add(processed.getContainer());
            toEvict.addAll(processed.getNewContent());
            for (Object e : toEvict) {
                if (nextNodes.contains(e) || GenericLibrary.class.isAssignableFrom(e.getClass())) continue;
                session.evict(e);
            }
        }
    }

    public void setNodeType(Class<NODE> nodeType) {
        this.nodeType = nodeType;
    }

    private boolean nodeWasAlreadyPasted(NODE node) {
        return this.pastedNodes.stream().anyMatch(item -> {
            boolean sameId = item.getId().equals(node.getId());
            boolean assignableFrom = item.getClass().isAssignableFrom(node.getClass());
            return sameId && assignableFrom;
        });
    }
}

