/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Provider;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.hibernate.ContainerIdNameStartParameterCallback;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateCampaignDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintGroupDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateCampaignFolderDao
extends HibernateEntityDao<CampaignFolder>
implements CampaignFolderDao {
    private final Provider<HibernateSprintGroupDao> sprintGroupDaoProvider;
    private final Provider<HibernateSprintDao> sprintDaoProvider;
    private final Provider<HibernateCampaignDao> campaignDaoProvider;

    @Autowired
    public HibernateCampaignFolderDao(Provider<HibernateSprintGroupDao> sprintGroupDaoProvider, Provider<HibernateSprintDao> sprintDaoProvider, Provider<HibernateCampaignDao> campaignDaoProvider) {
        this.sprintGroupDaoProvider = sprintGroupDaoProvider;
        this.sprintDaoProvider = sprintDaoProvider;
        this.campaignDaoProvider = campaignDaoProvider;
    }

    @Override
    public CampaignFolder findByContent(CampaignLibraryNode node) {
        SetNodeContentParameter callback = new SetNodeContentParameter((LibraryNode)node);
        return (CampaignFolder)this.executeEntityNamedQuery("campaignFolder.findByContent", callback);
    }

    @Override
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(libraryId, nameStart);
        return this.executeListNamedQuery("campaignFolder.findNamesInLibraryStartingWith", newCallBack1);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long[]> findPairedContentForList(List<Long> ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> findContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List results = this.entityManager.createNativeQuery("select * from CLN_RELATIONSHIP where ancestor_id in (:folderIds)").setParameter("folderIds", ids).getResultList();
        return results.stream().map(row -> ((Number)row[1]).longValue()).toList();
    }

    @Override
    public CampaignFolder findParentOf(final Long id) {
        SetQueryParametersCallback newCallBack = new SetQueryParametersCallback(){

            @Override
            public void setQueryParameters(Query query) {
                query.setParameter("contentId", (Object)id);
            }
        };
        return (CampaignFolder)this.executeEntityNamedQuery("campaignFolder.findParentOf", newCallBack);
    }

    @Override
    public CampaignFolder loadContainerForPaste(long id) {
        return (CampaignFolder)this.entityManager.createQuery("select cf from CampaignFolder cf left join fetch cf.content where cf.id = :id", CampaignFolder.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<CampaignFolder> loadContainersForPaste(Collection<Long> ids) {
        return this.entityManager.createQuery("select distinct cf from CampaignFolder cf left join fetch cf.content where cf.id in :id", CampaignFolder.class).setParameter("id", ids).getResultList();
    }

    @Override
    public List<CampaignFolder> loadNodeForPaste(Collection<Long> ids) {
        return this.entityManager.createQuery("select distinct cf from CampaignFolder cf left join fetch cf.attachmentList al left join fetch al.attachments a left join fetch a.content c where cf.id in :ids", CampaignFolder.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public ChildEntityDtoResult loadChildForPaste(Collection<Long> ids, int maxResult, int offset, ClipboardPayload clipboardPayload) {
        return this.getChildEntityDtoForPaste("select c, f.id from CampaignFolder f join f.content c where f.id in :ids", ids, maxResult, offset, clipboardPayload, (k, v) -> {
            switch (k) {
                case CAMPAIGN_FOLDER: {
                    this.loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                case CAMPAIGN: {
                    ((HibernateCampaignDao)this.campaignDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                case SPRINT_GROUP: {
                    ((HibernateSprintGroupDao)this.sprintGroupDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                case SPRINT: {
                    ((HibernateSprintDao)this.sprintDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported entity type: " + String.valueOf(k));
                }
            }
        });
    }

    @Override
    public CampaignFolder loadForNodeAddition(Long folderId) {
        return (CampaignFolder)this.entityManager.createQuery("select folder from CampaignFolder folder\njoin fetch folder.project project\nleft join fetch folder.content content\nwhere folder.id in :id", CampaignFolder.class).setParameter("id", (Object)folderId).getSingleResult();
    }

    @Override
    public List<CampaignFolder> loadForNodeAddition(Collection<Long> folderIds) {
        return this.entityManager.createQuery("select distinct folder from CampaignFolder folder\njoin fetch folder.project project\nleft join fetch folder.content content\nwhere folder.id in :ids", CampaignFolder.class).setParameter("ids", folderIds).getResultList();
    }
}

