/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class IterationCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    public IterationCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> iterations = this.collectIterations(ids);
        this.appendMilestonesInheritedFromCampaign(iterations);
        return iterations;
    }

    private Map<Long, DataRow> collectIterations(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.ITERATION.NAME.as("NAME"), (SelectField)Tables.ITERATION.REFERENCE, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("CAMPAIGN_ID"), (SelectField)DSL.count((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID).as("CHILD_COUNT")).from((TableLike)Tables.ITERATION).leftJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.ITERATION.ITERATION_ID.in(ids)).groupBy(new GroupField[]{Tables.ITERATION.ITERATION_ID, Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.ITERATION.ITERATION_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.ITERATION, (Long)tuple.get((Field)Tables.ITERATION.ITERATION_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            if (!Strings.isNullOrEmpty((String)((String)tuple.get((Field)Tables.ITERATION.REFERENCE, String.class)))) {
                dataRow.getData().replace("NAME", (String)tuple.get((Field)Tables.ITERATION.REFERENCE) + " - " + (String)tuple.get((Field)Tables.ITERATION.NAME));
            }
            return dataRow;
        }));
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.ITERATION;
    }
}

