/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.bugtracker.BugTrackerKindNotBindableToProject;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.BugTrackerBindingDto;
import org.squashtest.tm.service.internal.display.dto.BugTrackerDto;
import org.squashtest.tm.service.internal.display.dto.BugTrackerViewDto;
import org.squashtest.tm.service.internal.display.dto.ProjectDto;
import org.squashtest.tm.service.internal.repository.display.BugTrackerDisplayDao;

@Repository
public class BugTrackerDisplayDaoImpl
implements BugTrackerDisplayDao {
    private DSLContext dsl;

    public BugTrackerDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public void appendBugTrackerBindings(List<ProjectDto> projects) {
        Map projectsMap = projects.stream().collect(Collectors.toMap(ProjectDto::getId, Function.identity()));
        Set projectIds = projects.stream().map(ProjectDto::getId).collect(Collectors.toSet());
        this.dsl.select((SelectField)Tables.PROJECT.BUGTRACKER_ID, (SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(projectIds).and(Tables.PROJECT.BUGTRACKER_ID.isNotNull())).forEach(record -> {
            ProjectDto projectDto = (ProjectDto)projectsMap.get(record.get((Field)Tables.PROJECT.PROJECT_ID));
            BugTrackerBindingDto bugTrackerBindingDto = new BugTrackerBindingDto();
            bugTrackerBindingDto.setBugTrackerId((Long)record.get((Field)Tables.PROJECT.BUGTRACKER_ID));
            bugTrackerBindingDto.setProjectId((Long)record.get((Field)Tables.PROJECT.PROJECT_ID));
            projectDto.setBugTrackerBinding(bugTrackerBindingDto);
        });
    }

    @Override
    public List<BugTrackerDto> findAll() {
        return this.dsl.select((SelectField)Tables.BUGTRACKER.BUGTRACKER_ID.as("ID"), (SelectField)Tables.BUGTRACKER.IFRAME_FRIENDLY, (SelectField)Tables.BUGTRACKER.KIND, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_POLICY, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_PROTOCOL, (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.URL).from((TableLike)Tables.BUGTRACKER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).fetchInto(BugTrackerDto.class);
    }

    @Override
    public List<BugTrackerDto> findAllBugtrackerBindableToProject() {
        List<String> allBugtrackerKindNotBindableToProject = Stream.of(BugTrackerKindNotBindableToProject.values()).map(BugTrackerKindNotBindableToProject::getBugTrackerKind).toList();
        return this.dsl.select((SelectField)Tables.BUGTRACKER.BUGTRACKER_ID.as("ID"), (SelectField)Tables.BUGTRACKER.IFRAME_FRIENDLY, (SelectField)Tables.BUGTRACKER.KIND, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_POLICY, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_PROTOCOL, (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.URL).from((TableLike)Tables.BUGTRACKER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).where(Tables.BUGTRACKER.KIND.notIn(allBugtrackerKindNotBindableToProject)).orderBy((OrderField)Tables.THIRD_PARTY_SERVER.NAME).fetchInto(BugTrackerDto.class);
    }

    @Override
    public BugTrackerViewDto getBugTrackerView(Long bugTrackerId) {
        return (BugTrackerViewDto)this.dsl.select((SelectField)Tables.BUGTRACKER.BUGTRACKER_ID.as("ID"), (SelectField)Tables.BUGTRACKER.IFRAME_FRIENDLY, (SelectField)Tables.BUGTRACKER.KIND, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_POLICY, (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_PROTOCOL, (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.URL, (SelectField)Tables.THIRD_PARTY_SERVER.DESCRIPTION, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_ON, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_BY, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_ON, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_BY).from((TableLike)Tables.BUGTRACKER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).where(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Object)bugTrackerId)).fetchOneInto(BugTrackerViewDto.class);
    }
}

