/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.testcase.ActionWordFragmentValueDto;
import org.squashtest.tm.service.internal.display.dto.testcase.ActionWordParameterValueDto;
import org.squashtest.tm.service.internal.display.dto.testcase.ActionWordTextValueDto;
import org.squashtest.tm.service.internal.repository.display.ActionWordDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
public class ActionWordDisplayDaoImpl
implements ActionWordDisplayDao {
    private static final String FRAGMENT_TYPE = "FRAGMENT_TYPE";
    private static final String KEYWORD_STEP_ID = "KEYWORD_STEP_ID";
    private DSLContext dsl;

    public ActionWordDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public List<ActionWordFragmentValueDto> findActionWordFragmentValues(List<Long> keywordStepIds) {
        return this.dsl.select((SelectField)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.as(KEYWORD_STEP_ID), (SelectField)DSL.val((String)"TEXT").as(FRAGMENT_TYPE), (SelectField)Tables.ACTION_WORD_TEXT.TEXT.as("VALUE"), (SelectField)Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID)).join((TableLike)Tables.ACTION_WORD_FRAGMENT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID.eq((Field)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID)).join((TableLike)Tables.ACTION_WORD_TEXT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_TEXT.ACTION_WORD_FRAGMENT_ID)).where(Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.in(keywordStepIds)).and(ConditionsConstants.TCLN_NOT_IN_BIN).union((Select)this.dsl.select((SelectField)Tables.ACTION_WORD_PARAMETER_VALUE.KEYWORD_TEST_STEP_ID.as(KEYWORD_STEP_ID), (SelectField)DSL.val((String)"PARAMETER").as(FRAGMENT_TYPE), (SelectField)Tables.ACTION_WORD_PARAMETER_VALUE.VALUE.as("VALUE"), (SelectField)Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER).from((TableLike)Tables.ACTION_WORD_FRAGMENT).join((TableLike)Tables.ACTION_WORD_PARAMETER_VALUE).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_PARAMETER_VALUE.ACTION_WORD_FRAGMENT_ID)).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.ACTION_WORD_PARAMETER_VALUE.KEYWORD_TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.ACTION_WORD_PARAMETER_VALUE.KEYWORD_TEST_STEP_ID.in(keywordStepIds)).and(ConditionsConstants.TCLN_NOT_IN_BIN)).orderBy((OrderField)DSL.field((String)KEYWORD_STEP_ID), (OrderField)DSL.field((String)"FRAGMENT_ORDER")).fetch().stream().map(record -> {
            if ("TEXT".equals(record.get(FRAGMENT_TYPE))) {
                return new ActionWordTextValueDto((Long)record.get(KEYWORD_STEP_ID), record.get("VALUE").toString());
            }
            return new ActionWordParameterValueDto((Long)record.get(KEYWORD_STEP_ID), record.get("VALUE").toString());
        }).toList();
    }
}

