/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report;

import java.util.List;
import java.util.Objects;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.tools.json.JSONObject;
import org.jooq.tools.json.JSONParser;
import org.jooq.tools.json.ParseException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.report.ReportFinderService;

@Service(value="squashtest.tm.service.ReportFinderService")
@Transactional
public class ReportFinderServiceImpl
implements ReportFinderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportFinderServiceImpl.class);
    private final DSLContext dsl;

    public ReportFinderServiceImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public String fetchTemplateFromParametersByReportDefinitionId(Long reportDefinitionId) throws ParseException {
        String parameters = (String)((Record1)this.dsl.select((SelectField)Tables.REPORT_DEFINITION.PARAMETERS).from((TableLike)Tables.REPORT_DEFINITION).where(Tables.REPORT_DEFINITION.REPORT_ID.eq((Object)reportDefinitionId)).fetchOne()).value1();
        JSONObject templateFileNameObject = this.retrieveTemplateFileNameFromParameters(parameters);
        return Objects.isNull(templateFileNameObject) ? "" : (String)templateFileNameObject.get((Object)"val");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean isTemplateUsedInReport(String templateFileName, String namespace) {
        List parametersList = this.dsl.select((SelectField)Tables.REPORT_DEFINITION.PARAMETERS).from((TableLike)Tables.REPORT_DEFINITION).where(Tables.REPORT_DEFINITION.PLUGIN_NAMESPACE.eq((Object)namespace)).and(Tables.REPORT_DEFINITION.PARAMETERS.contains((Object)templateFileName)).fetchInto(String.class);
        for (String parameters : parametersList) {
            if (!this.checkIfTemplateUsed(templateFileName, parameters)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfTemplateUsed(String templateFileName, String parameters) {
        JSONObject templateFileNameObject = null;
        try {
            templateFileNameObject = this.retrieveTemplateFileNameFromParameters(parameters);
        }
        catch (ParseException e) {
            LOGGER.debug("An error occurred while retrieving template file name from parameters", (Throwable)e);
        }
        return Objects.nonNull(templateFileNameObject) && templateFileName.equals(templateFileNameObject.get((Object)"val"));
    }

    private JSONObject retrieveTemplateFileNameFromParameters(String parameters) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject parametersJson = (JSONObject)parser.parse(parameters);
        return (JSONObject)parametersJson.get((Object)"templateFileName");
    }
}

