/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.xrayimporter.topivot;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import gherkin.ParserException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Record1;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.exception.pivot.projectimporter.xrayimporter.ImportXrayException;
import org.squashtest.tm.service.internal.dto.pivotdefinition.FolderPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.CalledTestCasesPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetParamPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporterxray.XrayField;
import org.squashtest.tm.service.internal.dto.projectimporterxray.convertertopivot.ExtendedTestCasePivot;
import org.squashtest.tm.service.internal.dto.projectimporterxray.convertertopivot.GherkinScriptedStep;
import org.squashtest.tm.service.internal.dto.projectimporterxray.convertertopivot.TreeFolder;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CalledTestXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CustomFieldXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.ItemXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.mapping.XrayTestType;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayImportModel;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayItemStatus;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.SquashRules;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.XrayTablesDao;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.topivot.AbstractImporterXrayHelper;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.topivot.TestCaseToPivotImporterService;

@Service
public class TestCaseToPivotImporterServiceImpl
extends AbstractImporterXrayHelper
implements TestCaseToPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseToPivotImporterServiceImpl.class);
    private final XrayTablesDao xrayTablesDao;
    private final SquashRules squashRules;
    private final PivotFileManager pivotFileManager;
    private final Map<String, String> pivotIdByTestCaseFolderPath = new HashMap<String, String>();
    private String precedingGherkinLanguage;

    public TestCaseToPivotImporterServiceImpl(XrayTablesDao xrayTablesDao, SquashRules squashRules, PivotFileManager pivotFileManager) {
        this.xrayTablesDao = xrayTablesDao;
        this.squashRules = squashRules;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void writeTestCaseFolder(JsonFactory jsonFactory, PrintWriter logWriter, ArchiveOutputStream<ZipArchiveEntry> archive, XrayImportModel xrayImportModel) throws IOException {
        boolean isEmptyEntity = this.xrayTablesDao.isEmptyTestCaseFolder(XrayField.Type.TEST);
        if (isEmptyEntity) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, this::handleTestCaseFolder, JsonImportFile.TEST_CASE_FOLDERS, archive);
    }

    @Override
    public void writeTestCase(JsonFactory jsonFactory, PrintWriter logWriter, ArchiveOutputStream<ZipArchiveEntry> archive, XrayImportModel xrayImportModel, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) throws IOException {
        boolean isEmptyEntity = this.xrayTablesDao.isEmptyItemTable(XrayField.Type.TEST);
        logWriter.write(String.format("%sTest Cases%s", System.lineSeparator(), System.lineSeparator()));
        if (isEmptyEntity) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleTestCase((JsonGenerator)jsonGenerator, logWriter, xrayImportModel, tpiPivotByTestCaseKey), JsonImportFile.TEST_CASES, archive);
    }

    @Override
    public void writeCalledTestCase(JsonFactory jsonFactory, PrintWriter logWriter, ArchiveOutputStream<ZipArchiveEntry> archive, XrayImportModel xrayImportModel) throws IOException {
        boolean isEmptyEntity = this.xrayTablesDao.isEmptyCalledTestCase();
        logWriter.write(String.format("%sCalled Test Cases%s", System.lineSeparator(), System.lineSeparator()));
        if (isEmptyEntity) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleCalledTestCases((JsonGenerator)jsonGenerator, logWriter, xrayImportModel), JsonImportFile.CALLED_TEST_CASES, archive);
    }

    private void handleTestCaseFolder(JsonGenerator jsonGenerator) {
        TreeFolder rootFolder = this.handleTestRepository();
        this.writeEachFolder(jsonGenerator, rootFolder);
    }

    private TreeFolder handleTestRepository() {
        List<String> folders = this.xrayTablesDao.selectTypeRepositoryFolder(XrayField.Type.TEST).map(Record1::value1).map(this::extractFolderPath).flatMap(Collection::stream).distinct().toList();
        return this.createTreeFolder(folders);
    }

    private List<String> extractFolderPath(String path) {
        Document document = Jsoup.parse((String)path);
        return document.body().getAllElements().stream().map(Element::text).toList();
    }

    private TreeFolder createTreeFolder(List<String> folders) {
        TreeFolder rootTree;
        AtomicLong idGenerator = new AtomicLong(0L);
        TreeFolder current = rootTree = new TreeFolder();
        for (String folder : folders) {
            String[] stringArray = folder.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String data = stringArray[n2];
                if (!data.isEmpty()) {
                    current = current.child(data, idGenerator);
                }
                ++n2;
            }
            current = rootTree;
        }
        return rootTree;
    }

    private void writeEachFolder(JsonGenerator jsonGenerator, TreeFolder treeRoot) {
        if (StringUtils.isNotEmpty((CharSequence)treeRoot.getFullPath())) {
            FolderPivot testCaseFolderPivot = new FolderPivot();
            testCaseFolderPivot.setPivotId(treeRoot.getId());
            testCaseFolderPivot.setName(treeRoot.getData());
            testCaseFolderPivot.setParentType(this.getEntityTypeFolder(treeRoot.isRootFolder()));
            testCaseFolderPivot.setKind(EntityType.TEST_CASE_FOLDER);
            if (!treeRoot.isRootFolder()) {
                testCaseFolderPivot.setParentId(treeRoot.getParentId());
            }
            this.pivotIdByTestCaseFolderPath.put(treeRoot.getFullPath(), testCaseFolderPivot.getPivotId());
            this.pivotFileManager.writePivotObject(testCaseFolderPivot, jsonGenerator, JsonImportFile.TEST_CASE_FOLDERS);
        }
        for (TreeFolder child : treeRoot.getChildren()) {
            this.writeEachFolder(jsonGenerator, child);
        }
    }

    public EntityType getEntityTypeFolder(boolean isRootFolder) {
        if (isRootFolder) {
            return EntityType.TEST_CASE_LIBRARY;
        }
        return EntityType.TEST_CASE_FOLDER;
    }

    private void handleTestCase(JsonGenerator jsonGenerator, PrintWriter logWriter, XrayImportModel xrayImportModel, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) {
        this.squashRules.handleDuplicateNameWithParentType(this.xrayTablesDao.selectDuplicateNameGroupBy(XrayField.CustomFieldKey.TEST_REPOSITORY_PATH, XrayField.Type.TEST));
        XrayImportModel.EntityCount entityCount = new XrayImportModel.EntityCount(XrayImportModel.EntityType.TEST_CASE);
        this.xrayTablesDao.selectTest(this.pivotFileManager.consumerThrowingIOException(itemXrayDto -> this.generateTestCase(jsonGenerator, logWriter, (ItemXrayDto)itemXrayDto, entityCount, tpiPivotByTestCaseKey)), XrayField.Type.TEST);
        this.pivotIdByTestCaseFolderPath.clear();
        xrayImportModel.getEntityCounts().add(entityCount);
    }

    private void generateTestCase(JsonGenerator jsonGenerator, PrintWriter logWriter, ItemXrayDto itemXrayDto, XrayImportModel.EntityCount entityCount, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) throws IOException {
        try {
            ExtendedTestCasePivot extendedTestCasePivot = this.handleTypeTestCase(itemXrayDto);
            jsonGenerator.writeObject((Object)extendedTestCasePivot);
            this.generateTestPlanItemPivot(Objects.requireNonNull(extendedTestCasePivot), tpiPivotByTestCaseKey);
            this.squashRules.markWithSuccessIfStatusIsNull(itemXrayDto);
        }
        catch (ImportXrayException importXrayException) {
            LOGGER.error("Error during the generation pivot format: ", (Throwable)importXrayException);
            itemXrayDto.setItemStatus(XrayItemStatus.FAILURE);
        }
        entityCount.countEntity(itemXrayDto);
        this.writeLog(logWriter, itemXrayDto);
    }

    private void generateTestPlanItemPivot(ExtendedTestCasePivot extendedTestCasePivot, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) {
        String reference = extendedTestCasePivot.getXrayKey();
        String testCasePivotId = extendedTestCasePivot.getPivotId();
        if (extendedTestCasePivot.getDatasets().isEmpty()) {
            tpiPivotByTestCaseKey.computeIfAbsent(reference, k -> new ArrayList()).add(this.getTestPlanItemPivot(testCasePivotId, null));
        } else {
            extendedTestCasePivot.getDatasets().forEach(dataset -> {
                boolean bl = tpiPivotByTestCaseKey.computeIfAbsent(reference, k -> new ArrayList()).add(this.getTestPlanItemPivot(testCasePivotId, dataset.getPivotId()));
            });
        }
    }

    private TestPlanItemPivot getTestPlanItemPivot(String testCasePivotId, String datasetPivotId) {
        TestPlanItemPivot testPlanItemPivot = new TestPlanItemPivot();
        testPlanItemPivot.setTestCaseId(testCasePivotId);
        testPlanItemPivot.setDatasetId(datasetPivotId);
        return testPlanItemPivot;
    }

    private ExtendedTestCasePivot handleTypeTestCase(ItemXrayDto itemXrayDto) {
        String testType = itemXrayDto.getFilterCufValue(XrayField.CustomFieldKey.TEST_TYPE);
        XrayTestType xrayTestType = XrayTestType.getTestType(testType);
        return switch (xrayTestType) {
            case XrayTestType.MANUAL -> this.handleGenericManualTestCase(itemXrayDto, false);
            case XrayTestType.GENERIC -> this.handleGenericManualTestCase(itemXrayDto, true);
            case XrayTestType.CUCUMBER -> this.handleCucumberTestCase(itemXrayDto);
            default -> {
                this.squashRules.markWithErrorAndThrow(itemXrayDto, TestCaseToPivotImporterServiceImpl.typeTestCaseError(testType));
                yield null;
            }
        };
    }

    private static String typeTestCaseError(String testType) {
        String message = Objects.isNull(testType) ? String.format("The value of the test type is null. There is no Custom Field containing the key '%s'", XrayField.CustomFieldKey.TEST_TYPE.getKey()) : String.format("The test type '%s' is not equals to %s, %s or %s", testType, XrayTestType.MANUAL.getName(), XrayTestType.GENERIC.getName(), XrayTestType.CUCUMBER.getName());
        return message;
    }

    private ExtendedTestCasePivot handleGenericManualTestCase(ItemXrayDto itemXrayDto, boolean isGeneric) {
        this.squashRules.validateMandatoryCommonField(itemXrayDto);
        ExtendedTestCasePivot extendedTestCasePivot = new ExtendedTestCasePivot();
        extendedTestCasePivot.setXrayKey(itemXrayDto.getKey());
        extendedTestCasePivot.setTestCaseKind(TestCaseKind.STANDARD);
        this.createCommonPartTestCase(extendedTestCasePivot, itemXrayDto);
        extendedTestCasePivot.setDatasetId(new AtomicInteger(0));
        extendedTestCasePivot.setDatasetParamId(new AtomicInteger(0));
        extendedTestCasePivot.setActionStepId(new AtomicInteger(0));
        this.handleTestCaseDataset(extendedTestCasePivot, itemXrayDto);
        if (isGeneric) {
            this.handleTestCaseStepGeneric(extendedTestCasePivot, itemXrayDto.getFilterCufs(XrayField.CustomFieldKey.GENERIC_DEFINITION));
        } else {
            this.handleTestCaseStep(extendedTestCasePivot, itemXrayDto);
        }
        this.handlePrerequisite(itemXrayDto, prerequisites -> extendedTestCasePivot.setPrerequisite(this.generatePrerequisite((Map<String, String>)prerequisites)));
        return extendedTestCasePivot;
    }

    private String generatePrerequisite(Map<String, String> prerequisites) {
        Document document = new Document("");
        Element body = document.body();
        prerequisites.forEach((key, value) -> {
            body.appendElement("p").text(String.format("#%s", key));
            body.appendElement("p").text(value);
        });
        return body.children().stream().map(Node::toString).collect(Collectors.joining());
    }

    private void createCommonPartTestCase(ExtendedTestCasePivot extendedTestCasePivot, ItemXrayDto itemXrayDto) {
        extendedTestCasePivot.setPivotId(itemXrayDto.getPivotId());
        extendedTestCasePivot.setName(itemXrayDto.getSummary());
        String description = this.generateDescription(itemXrayDto, this::addLinkPriorityStatusLabelToDescription);
        extendedTestCasePivot.setDescription(description);
        extendedTestCasePivot.setReference(itemXrayDto.getKey());
        extendedTestCasePivot.setStatus(this.squashRules.checkStatus(itemXrayDto, itemXrayDto.getStatus()));
        extendedTestCasePivot.setImportance(this.squashRules.checkPriority(itemXrayDto, itemXrayDto.getPriority()));
        extendedTestCasePivot.setParentTypeAndId(itemXrayDto.getFilterCufs(XrayField.CustomFieldKey.TEST_REPOSITORY_PATH), this.pivotIdByTestCaseFolderPath);
    }

    private void handlePrerequisite(ItemXrayDto itemXrayDto, Consumer<Map<String, String>> addPrerequisite) {
        List<CustomFieldXrayDto> preconditions = itemXrayDto.getFilterCufs(XrayField.CustomFieldKey.TEST_ASSOCIATED_PRECONDITION);
        Map<String, String> preconditionsMap = itemXrayDto.getAssociatedIssuesWithXrayKey();
        if (preconditions.size() == preconditionsMap.size()) {
            if (!preconditionsMap.isEmpty()) {
                addPrerequisite.accept(preconditionsMap);
            }
        } else {
            this.squashRules.markWithWarning(itemXrayDto, String.format("Not all preconditions were found in the import (%s)", preconditions.stream().map(CustomFieldXrayDto::getValue).collect(Collectors.joining(", "))));
        }
    }

    private void checkingDataset(ExtendedTestCasePivot extendedTestCasePivot, ItemXrayDto itemXrayDto) {
        extendedTestCasePivot.getDatasetParams().forEach(datasetParamPivot -> {
            String datasetParamName = this.squashRules.checkDatasetName(itemXrayDto, datasetParamPivot.getName());
            datasetParamPivot.setName(datasetParamName);
        });
        extendedTestCasePivot.getDatasets().forEach(datasetPivot -> this.checkReferenceDatasetParamInsideDataset((DatasetPivot)datasetPivot, itemXrayDto));
    }

    private void checkReferenceDatasetParamInsideDataset(DatasetPivot datasetPivot, ItemXrayDto itemXrayDto) {
        List<DatasetPivot.ParamValue> paramValues = datasetPivot.getParamValues();
        if (Objects.nonNull(paramValues)) {
            paramValues.removeIf(paramValue -> {
                boolean isNull = Objects.isNull(paramValue.getId());
                if (isNull) {
                    this.squashRules.markWithWarning(itemXrayDto, String.format("The dataset parameter %s is not assigned to the dataset %s because its id is null", paramValue.getName(), datasetPivot.getName()));
                }
                return isNull;
            });
        }
    }

    private void handleTestCaseDataset(ExtendedTestCasePivot extendedTestCasePivot, ItemXrayDto itemXrayDto) {
        List<CustomFieldXrayDto> datasets = itemXrayDto.getDataset();
        datasets.stream().collect(Collectors.groupingBy(CustomFieldXrayDto::getDatasetRow)).forEach((row, datasetXray) -> this.createDatasets(extendedTestCasePivot, (List<CustomFieldXrayDto>)datasetXray));
        if (itemXrayDto.isCalledParameter()) {
            this.correctionAndSaveDatasetWithCalledTc(extendedTestCasePivot);
        }
        this.checkingDataset(extendedTestCasePivot, itemXrayDto);
    }

    private void createDatasets(ExtendedTestCasePivot extendedTestCasePivot, List<CustomFieldXrayDto> dataset) {
        DatasetPivot datasetPivot = new DatasetPivot();
        datasetPivot.setPivotId(extendedTestCasePivot.getPivotId(), extendedTestCasePivot.getDatasetId().incrementAndGet());
        datasetPivot.setName(String.format("Dataset_%s", extendedTestCasePivot.getDatasetId().get()));
        dataset.forEach(datasetParam -> this.createDatasetParamAndValue(extendedTestCasePivot, datasetPivot, (CustomFieldXrayDto)datasetParam));
        extendedTestCasePivot.getDatasets().add(datasetPivot);
    }

    private void createDatasetParamAndValue(ExtendedTestCasePivot extendedTestCasePivot, DatasetPivot datasetPivot, CustomFieldXrayDto datasetParameter) {
        if (!extendedTestCasePivot.isDatasetParamExist(datasetParameter.getDatasetName())) {
            DatasetParamPivot datasetParamPivot = new DatasetParamPivot();
            datasetParamPivot.setPivotId(extendedTestCasePivot.getPivotId(), extendedTestCasePivot.getDatasetParamId().incrementAndGet());
            datasetParamPivot.setName(datasetParameter.getDatasetName());
            extendedTestCasePivot.getDatasetParams().add(datasetParamPivot);
        }
        DatasetPivot.ParamValue paramValue = new DatasetPivot.ParamValue();
        String idDatasetParam = extendedTestCasePivot.getIdDatasetParam(datasetParameter.getDatasetName());
        if (idDatasetParam != null) {
            paramValue.setId(extendedTestCasePivot.getIdDatasetParam(datasetParameter.getDatasetName()));
            paramValue.setName(datasetParameter.getDatasetName());
            paramValue.setValue(datasetParameter.getDatasetValue());
        }
        datasetPivot.getParamValues().add(paramValue);
    }

    private void handleTestCaseStepGeneric(ExtendedTestCasePivot extendedTestCasePivot, List<CustomFieldXrayDto> genericDefinitions) {
        AtomicInteger idGenerator = new AtomicInteger(0);
        ActionStepPivot actionStepPivot = new ActionStepPivot();
        actionStepPivot.setPivotId(extendedTestCasePivot.getPivotId(), idGenerator.incrementAndGet());
        String action = genericDefinitions.stream().map(CustomFieldXrayDto::getValue).collect(Collectors.joining(System.lineSeparator()));
        actionStepPivot.setAction(action);
        extendedTestCasePivot.addActionSteps(actionStepPivot);
    }

    private void handleTestCaseStep(ExtendedTestCasePivot extendedTestCasePivot, ItemXrayDto itemXrayDto) {
        itemXrayDto.getStep().stream().filter(customFieldXray -> Objects.nonNull(customFieldXray.getStepAction()) || Objects.nonNull(customFieldXray.getStepData()) || Objects.nonNull(customFieldXray.getStepExpectedResult())).sorted(Comparator.comparingInt(CustomFieldXrayDto::getStepIndex)).forEach(customFieldXray -> this.createActionStepToPivot(itemXrayDto, extendedTestCasePivot, (CustomFieldXrayDto)customFieldXray, extendedTestCasePivot.getActionStepId()));
    }

    private void createActionStepToPivot(ItemXrayDto itemXrayDto, ExtendedTestCasePivot extendedTestCasePivot, CustomFieldXrayDto customFieldXray, AtomicInteger idGenerator) {
        ActionStepPivot actionStepPivot = new ActionStepPivot();
        actionStepPivot.setPivotId(extendedTestCasePivot.getPivotId(), idGenerator.incrementAndGet());
        String action = customFieldXray.getStepAction();
        if (StringUtils.isNotEmpty((CharSequence)customFieldXray.getStepData())) {
            Document actionDocument = this.normalizeToHTMLDocument(customFieldXray.getStepAction());
            actionDocument.body().appendElement("p").text(customFieldXray.getStepData());
            action = actionDocument.body().children().stream().map(Node::toString).collect(Collectors.joining());
        }
        action = this.checkStep(action, "Action and Data", customFieldXray.getStepIndex(), itemXrayDto);
        String expectedResult = this.checkStep(customFieldXray.getStepExpectedResult(), "Expected Result", customFieldXray.getStepIndex(), itemXrayDto);
        actionStepPivot.setAction(action);
        actionStepPivot.setExpectedResult(expectedResult);
        extendedTestCasePivot.addActionSteps(actionStepPivot);
    }

    private String checkStep(String step, String typeStep, int index, ItemXrayDto itemXrayDto) {
        if (Objects.isNull(step)) {
            return null;
        }
        Matcher datasetParamMatcher = Pattern.compile("\\$\\{(.*?)}|\\{test-param}(.*?)\\{test-param}").matcher(step);
        StringBuilder stepBuilder = new StringBuilder();
        while (datasetParamMatcher.find()) {
            this.replaceDatasetParamInStep(datasetParamMatcher, 1, stepBuilder);
            this.replaceDatasetParamInStep(datasetParamMatcher, 2, stepBuilder);
        }
        datasetParamMatcher.appendTail(stepBuilder);
        return this.squashRules.checkSanitizer(itemXrayDto, stepBuilder.toString(), String.format("%s (index %s)", typeStep, index));
    }

    private void replaceDatasetParamInStep(Matcher datasetParamMatcher, int groupIndex, StringBuilder stepBuilder) {
        String datasetParamRaw = datasetParamMatcher.group(groupIndex);
        if (Objects.isNull(datasetParamRaw)) {
            return;
        }
        String datasetParam = this.squashRules.checkDatasetNameInsideStep(datasetParamRaw);
        datasetParamMatcher.appendReplacement(stepBuilder, String.format("\\$\\{%s\\}", datasetParam));
    }

    private ExtendedTestCasePivot handleCucumberTestCase(ItemXrayDto itemXrayDto) {
        ExtendedTestCasePivot extendedTestCasePivot = new ExtendedTestCasePivot();
        extendedTestCasePivot.setTestCaseKind(TestCaseKind.GHERKIN);
        this.createCommonPartTestCase(extendedTestCasePivot, itemXrayDto);
        GherkinScriptedStep gherkinScriptedStep = new GherkinScriptedStep();
        gherkinScriptedStep.setFeatureName(itemXrayDto.getSummary());
        gherkinScriptedStep.setScenarioName(itemXrayDto.getSummary());
        gherkinScriptedStep.setDatasetTable(itemXrayDto.getDatasetGherkin());
        this.handlePrerequisite(itemXrayDto, preconditions -> this.generateBackgroundInstructions(gherkinScriptedStep, (Map<String, String>)preconditions));
        try {
            String gherkinScript = gherkinScriptedStep.generateGherkinScript(this.precedingGherkinLanguage, itemXrayDto.getFilterCufs(XrayField.CustomFieldKey.TEST_STEP_CUCUMBER));
            extendedTestCasePivot.setScript(gherkinScript);
        }
        catch (ParserException parserException) {
            LOGGER.error("Error on parsing Gherkin script during the generation pivot format:", (Throwable)parserException);
            this.squashRules.markWithErrorAndThrow(itemXrayDto, parserException.getMessage());
        }
        if (Objects.nonNull(gherkinScriptedStep.getGherkinLanguage())) {
            this.precedingGherkinLanguage = gherkinScriptedStep.getGherkinLanguage();
        }
        return extendedTestCasePivot;
    }

    private void generateBackgroundInstructions(GherkinScriptedStep gherkinScriptedStep, Map<String, String> preconditions) {
        ArrayList<String> backgroundInstructions = new ArrayList<String>();
        preconditions.forEach((key, value) -> {
            backgroundInstructions.add(String.format("#@%s", key));
            gherkinScriptedStep.addFormattedBackground((String)value, (List<String>)backgroundInstructions);
        });
        gherkinScriptedStep.setBackgroundInstructions(backgroundInstructions);
    }

    private void correctionAndSaveDatasetWithCalledTc(ExtendedTestCasePivot extendedTestCasePivot) {
        this.xrayTablesDao.selectCalledTestCasesToAssignDataset(extendedTestCasePivot.getXrayKey(), (rawParameters, id) -> {
            String datasetPivotId = this.getDatasetPivotIdForCalledTc((String)rawParameters, extendedTestCasePivot);
            this.xrayTablesDao.updateCustomFieldPivotId(id, datasetPivotId);
        });
    }

    private String getDatasetPivotIdForCalledTc(String rawParameters, ExtendedTestCasePivot extendedTestCasePivot) {
        Map<String, String> calledTestCaseParameters = TestCaseToPivotImporterServiceImpl.convertStringToMap(rawParameters);
        this.correctionDatasetParamIfMissing(extendedTestCasePivot, calledTestCaseParameters);
        String datasetPivotIdTestCase = extendedTestCasePivot.getDatasetPivotForCalledTC(calledTestCaseParameters);
        if (Objects.isNull(datasetPivotIdTestCase)) {
            return this.correctionDataset(extendedTestCasePivot, calledTestCaseParameters);
        }
        return datasetPivotIdTestCase;
    }

    private void correctionDatasetParamIfMissing(ExtendedTestCasePivot extendedTestCasePivot, Map<String, String> calledTestCaseParameters) {
        ArrayList<DatasetParamPivot> datasetParams = new ArrayList<DatasetParamPivot>(extendedTestCasePivot.getDatasetParams());
        List<String> datasetParamNames = datasetParams.stream().map(DatasetParamPivot::getName).toList();
        calledTestCaseParameters.keySet().stream().filter(paramName -> !datasetParamNames.contains(paramName)).forEach(missingParam -> {
            DatasetParamPivot datasetParamPivot = new DatasetParamPivot();
            datasetParamPivot.setName((String)missingParam);
            datasetParamPivot.setPivotId(extendedTestCasePivot.getPivotId(), extendedTestCasePivot.getDatasetParamId().incrementAndGet());
            datasetParams.add(datasetParamPivot);
        });
        extendedTestCasePivot.setDatasetParams(datasetParams);
    }

    private String correctionDataset(ExtendedTestCasePivot extendedTestCasePivot, Map<String, String> calledTestCaseParameters) {
        DatasetPivot datasetPivot = new DatasetPivot();
        datasetPivot.setPivotId(extendedTestCasePivot.getPivotId(), extendedTestCasePivot.getDatasetId().incrementAndGet());
        datasetPivot.setName(String.format("Dataset_Called_%s", extendedTestCasePivot.getDatasetId().get()));
        calledTestCaseParameters.forEach((paramName, paramValue) -> {
            DatasetPivot.ParamValue datasetParamValue = new DatasetPivot.ParamValue();
            datasetParamValue.setId(extendedTestCasePivot.getIdDatasetParam((String)paramName));
            datasetParamValue.setValue((String)paramValue);
            datasetPivot.getParamValues().add(datasetParamValue);
        });
        extendedTestCasePivot.getDatasets().add(datasetPivot);
        return datasetPivot.getPivotId();
    }

    private void handleCalledTestCases(JsonGenerator jsonGenerator, PrintWriter logWriter, XrayImportModel xrayImportModel) {
        XrayImportModel.EntityCount entityCount = new XrayImportModel.EntityCount(XrayImportModel.EntityType.CALLED_TEST_CASE);
        this.xrayTablesDao.selectCalledTestCases(this.pivotFileManager.consumerThrowingRecordAndId((calledTestCaseDtos, id) -> this.handleMultipleCalledInsideTestCase(jsonGenerator, logWriter, (List<CalledTestXrayDto>)calledTestCaseDtos, (AtomicInteger)id, entityCount)));
        xrayImportModel.getEntityCounts().add(entityCount);
    }

    private void handleMultipleCalledInsideTestCase(JsonGenerator jsonGenerator, PrintWriter logWriter, List<CalledTestXrayDto> calledTestXrayDtos, AtomicInteger id, XrayImportModel.EntityCount entityCount) {
        AtomicInteger indexCorrector = new AtomicInteger(1);
        calledTestXrayDtos.forEach(this.pivotFileManager.consumerThrowingIOException(calledTestXrayDto -> this.createCalledTestCase(jsonGenerator, logWriter, (CalledTestXrayDto)calledTestXrayDto, id, entityCount, indexCorrector)));
    }

    private void createCalledTestCase(JsonGenerator jsonGenerator, PrintWriter logWriter, CalledTestXrayDto calledTestXrayDto, AtomicInteger id, XrayImportModel.EntityCount entityCount, AtomicInteger indexCorrector) throws IOException {
        try {
            CalledTestCasesPivot calledTestCasesPivot = this.generateCalledTestCase(calledTestXrayDto, id, indexCorrector);
            jsonGenerator.writeObject((Object)calledTestCasesPivot);
            this.squashRules.markWithSuccessIfStatusIsNull(calledTestXrayDto);
        }
        catch (ImportXrayException importXrayException) {
            LOGGER.error("Error during the generation pivot format: ", (Throwable)importXrayException);
            indexCorrector.set(indexCorrector.get() + 1);
        }
        entityCount.countEntity(calledTestXrayDto);
        this.writeLog(logWriter, calledTestXrayDto);
    }

    private CalledTestCasesPivot generateCalledTestCase(CalledTestXrayDto calledTestXrayDto, AtomicInteger id, AtomicInteger indexCorrector) {
        this.squashRules.checkMandatoryField(calledTestXrayDto, calledTestXrayDto.getPivotId(), "caller_id");
        this.squashRules.checkMandatoryField(calledTestXrayDto, calledTestXrayDto.getStepIndex(), "step_index");
        if (Objects.isNull(calledTestXrayDto.getCalledId())) {
            String message = String.format("The issue %s is called in %s but it doesn't exist in the import.", calledTestXrayDto.getKey(), calledTestXrayDto.getStepCalledTestKey());
            this.squashRules.markWithErrorAndThrow(calledTestXrayDto, message);
            return null;
        }
        CalledTestCasesPivot calledTestCasesPivot = new CalledTestCasesPivot();
        calledTestCasesPivot.setPivotId(id.incrementAndGet());
        calledTestCasesPivot.setCallerId(calledTestXrayDto.getPivotId());
        calledTestCasesPivot.setCalledId(calledTestXrayDto.getCalledId());
        calledTestCasesPivot.setIndex(calledTestXrayDto.getStepIndex() - indexCorrector.get());
        this.handleCalledTestCasesParameters(calledTestXrayDto, calledTestCasesPivot);
        return calledTestCasesPivot;
    }

    private void handleCalledTestCasesParameters(CalledTestXrayDto calledTestXrayDto, CalledTestCasesPivot calledTestCasesPivot) {
        String datasetPivotId = calledTestXrayDto.getCufPivotId();
        if (Objects.nonNull(calledTestXrayDto.getStepCalledTestParameters())) {
            if (Objects.nonNull(datasetPivotId)) {
                calledTestCasesPivot.setParameterAssignationMode(ParameterAssignationMode.CALLED_DATASET);
                calledTestCasesPivot.setDatasetId(datasetPivotId);
            } else {
                calledTestCasesPivot.setParameterAssignationMode(ParameterAssignationMode.NOTHING);
                this.squashRules.markWithWarning(calledTestXrayDto, "The dataset is not assigned to the called test case");
            }
        } else {
            calledTestCasesPivot.setParameterAssignationMode(ParameterAssignationMode.NOTHING);
        }
    }
}

