/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.internal.dto.pivotdefinition.MilestonePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.RequirementLinkTypePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.ServersPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotOptions;

public class PivotMetaDataModel {
    public static final String FILENAME = "metadata.json";
    private List<ReportInfoListConflict> pivotReportInfoListConflicts = new ArrayList<ReportInfoListConflict>();
    private Map<InfoListProjectBindingType, String> pivotIdByInfoListBindingType = new HashMap<InfoListProjectBindingType, String>();
    private Map<InfoListProjectBindingType, String> infoListCodeByBindingType = new HashMap<InfoListProjectBindingType, String>();
    private Set<ExecutionStatus> executionStatusConflicts = new HashSet<ExecutionStatus>();
    private Set<ExecutionStatus> availableExecutionStatus = new HashSet<ExecutionStatus>();
    private Set<String> unauthorizedAttachmentTypes = new HashSet<String>();
    private Long attachmentMaxSize;
    private Long unauthorizedAttachmentTypesCount = 0L;
    private Long attachmentMaxSizeCount = 0L;
    private Long attachmentCount = 0L;
    private String baseUrl;
    private Long currentUserid;
    private boolean isAdmin = false;
    private boolean conflictFeatureMilestone = false;
    private final Map<String, String> milestoneConflictLabelByPivotId = new HashMap<String, String>();
    private final Set<String> milestoneToCreate = new HashSet<String>();
    private Locale locale;
    private final Map<String, RequirementLinkConflict> requirementLinkTypeConflictByPivotId = new HashMap<String, RequirementLinkConflict>();
    private final Set<String> requirementLinkTypeToCreate = new HashSet<String>();
    private final List<BugtrackerConflict> bugtrackerConflicts = new ArrayList<BugtrackerConflict>();
    private PivotOptions pivotOptions = new PivotOptions();

    public List<ReportInfoListConflict> getPivotReportInfoListConflicts() {
        return this.pivotReportInfoListConflicts;
    }

    public void setPivotReportInfoListConflicts(List<ReportInfoListConflict> pivotReportInfoListConflicts) {
        this.pivotReportInfoListConflicts = pivotReportInfoListConflicts;
    }

    public void addPivotReportInfoList(InfoListProjectBindingType type, String label, String code, boolean isSystemInfoList) {
        this.pivotReportInfoListConflicts.add(new ReportInfoListConflict(type, label, code, isSystemInfoList));
    }

    public Map<InfoListProjectBindingType, String> getBindingTypeByPivotId() {
        return this.pivotIdByInfoListBindingType;
    }

    public void setBindingTypeByPivotId(Map<InfoListProjectBindingType, String> bindingTypeByPivotId) {
        this.pivotIdByInfoListBindingType = bindingTypeByPivotId;
    }

    public Map<InfoListProjectBindingType, String> getInfoListCodeByBindingType() {
        return this.infoListCodeByBindingType;
    }

    public void setInfoListCodeByBindingType(Map<InfoListProjectBindingType, String> infoListCodeByBindingType) {
        this.infoListCodeByBindingType = infoListCodeByBindingType;
    }

    public void addInfoListCodeByBindingType(String pivotId, String code) {
        if (this.pivotIdByInfoListBindingType.containsValue(pivotId)) {
            this.pivotIdByInfoListBindingType.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(pivotId)).findFirst().ifPresent(entry -> {
                String string2 = this.infoListCodeByBindingType.put((InfoListProjectBindingType)entry.getKey(), code);
            });
        }
    }

    public Set<ExecutionStatus> getExecutionStatusConflicts() {
        return this.executionStatusConflicts;
    }

    public void setExecutionStatusConflicts(Set<ExecutionStatus> executionStatusConflicts) {
        this.executionStatusConflicts = executionStatusConflicts;
    }

    public void addExecutionStatusConflicts(ExecutionStatus executionStatus) {
        this.executionStatusConflicts.add(executionStatus);
    }

    public void addAllExecutionStatusConflicts(Collection<ExecutionStatus> executionStatus) {
        this.executionStatusConflicts.addAll(executionStatus);
    }

    public Set<ExecutionStatus> getAvailableExecutionStatus() {
        return this.availableExecutionStatus;
    }

    public void setAvailableExecutionStatus(Set<ExecutionStatus> availableExecutionStatus) {
        this.availableExecutionStatus = availableExecutionStatus;
    }

    public void addAllAvailableExecutionStatus(Collection<ExecutionStatus> availableExecutionStatus) {
        this.availableExecutionStatus.addAll(availableExecutionStatus);
    }

    public void mergePivotMetaDataModelAttachment(PivotMetaDataModel other) {
        this.setAttachmentMaxSize(other.getAttachmentMaxSize());
        this.unauthorizedAttachmentTypes.addAll(other.getUnauthorizedAttachmentTypes());
        this.unauthorizedAttachmentTypesCount = this.unauthorizedAttachmentTypesCount + other.getUnauthorizedAttachmentTypesCount();
        this.attachmentMaxSizeCount = this.attachmentMaxSizeCount + other.getAttachmentMaxSizeCount();
        this.attachmentCount = this.attachmentCount + other.getAttachmentCount();
    }

    public Set<String> getUnauthorizedAttachmentTypes() {
        return this.unauthorizedAttachmentTypes;
    }

    public void setUnauthorizedAttachmentTypes(Set<String> unauthorizedAttachmentTypes) {
        this.unauthorizedAttachmentTypes = unauthorizedAttachmentTypes;
    }

    public void addUnauthorizedAttachmentType(String unauthorizedAttachmentType) {
        this.unauthorizedAttachmentTypes.add(unauthorizedAttachmentType);
    }

    public Long getAttachmentMaxSize() {
        return this.attachmentMaxSize;
    }

    public void setAttachmentMaxSize(Long attachmentMaxSize) {
        if (this.attachmentMaxSize == null) {
            this.attachmentMaxSize = attachmentMaxSize;
        } else if (attachmentMaxSize > this.attachmentMaxSize) {
            this.attachmentMaxSize = attachmentMaxSize;
        }
    }

    public Long getUnauthorizedAttachmentTypesCount() {
        return this.unauthorizedAttachmentTypesCount;
    }

    public void setUnauthorizedAttachmentTypesCount(Long unauthorizedAttachmentTypesCount) {
        this.unauthorizedAttachmentTypesCount = unauthorizedAttachmentTypesCount;
    }

    public void incrementUnauthorizedAttachmentTypesCount() {
        this.unauthorizedAttachmentTypesCount = this.unauthorizedAttachmentTypesCount + 1L;
    }

    public Long getAttachmentMaxSizeCount() {
        return this.attachmentMaxSizeCount;
    }

    public void setAttachmentMaxSizeCount(Long attachmentMaxSizeCount) {
        this.attachmentMaxSizeCount = attachmentMaxSizeCount;
    }

    public void incrementAttachmentMaxSizeCount() {
        this.attachmentMaxSizeCount = this.attachmentMaxSizeCount + 1L;
    }

    public Long getAttachmentCount() {
        return this.attachmentCount;
    }

    public void setAttachmentCount(Long attachmentCount) {
        this.attachmentCount = attachmentCount;
    }

    public void incrementAttachmentCount() {
        this.attachmentCount = this.attachmentCount + 1L;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean admin) {
        this.isAdmin = admin;
    }

    public Long getCurrentUserid() {
        return this.currentUserid;
    }

    public void setCurrentUserid(Long currentUserid) {
        this.currentUserid = currentUserid;
    }

    public boolean isConflictFeatureMilestone() {
        return this.conflictFeatureMilestone;
    }

    public void setConflictFeatureMilestone(boolean conflictFeatureMilestone) {
        this.conflictFeatureMilestone = conflictFeatureMilestone;
    }

    public Map<String, String> getMilestoneConflictLabelByPivotId() {
        return this.milestoneConflictLabelByPivotId;
    }

    public void addMilestoneConflict(MilestonePivot milestonePivot) {
        this.milestoneConflictLabelByPivotId.computeIfAbsent(milestonePivot.getPivotId(), k -> milestonePivot.getLabel());
    }

    public Set<String> getMilestoneToCreate() {
        return this.milestoneToCreate;
    }

    public Map<String, RequirementLinkConflict> getRequirementLinkTypeConflictByPivotId() {
        return this.requirementLinkTypeConflictByPivotId;
    }

    public void addRequirementLinkConflict(RequirementLinkTypePivot requirementLinkTypePivot, RequirementVersionLinkType requirementVersionLinkType) {
        this.requirementLinkTypeConflictByPivotId.put(requirementLinkTypePivot.getPivotId(), new RequirementLinkConflict(requirementVersionLinkType.getId(), requirementVersionLinkType.getRole1(), requirementVersionLinkType.getRole2(), requirementLinkTypePivot.getRole1(), requirementLinkTypePivot.getRole2()));
    }

    public Set<String> getRequirementLinkTypeToCreate() {
        return this.requirementLinkTypeToCreate;
    }

    public List<BugtrackerConflict> getBugtrackerConflicts() {
        return this.bugtrackerConflicts;
    }

    public void addBugtrackerConflicts(ServersPivot serversPivot) {
        this.bugtrackerConflicts.add(new BugtrackerConflict(serversPivot.getName(), serversPivot.getKind(), serversPivot.getUrl()));
    }

    public void addBugtrackerConflicts(BugTracker bugTracker) {
        this.bugtrackerConflicts.add(new BugtrackerConflict(bugTracker.getName(), bugTracker.getKind(), bugTracker.getUrl()));
    }

    public PivotOptions getPivotOptions() {
        return this.pivotOptions;
    }

    public void setPivotOptions(PivotOptions pivotOptions) {
        this.pivotOptions = pivotOptions;
    }

    public record BugtrackerConflict(String name, String kind, String url) {
    }

    public record ReportInfoListConflict(InfoListProjectBindingType type, String label, String code, boolean isSystemInfoList) {
    }

    public record RequirementLinkConflict(Long id, String role1, String role2, String importRole1, String importRole2) {
    }
}

