/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.jooq.domain.tables.Milestone;
import org.squashtest.tm.jooq.domain.tables.MilestoneBinding;
import org.squashtest.tm.jooq.domain.tables.MilestoneTestCase;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.jooq.domain.tables.TestCase;
import org.squashtest.tm.service.internal.display.dto.MilestoneAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneBindingDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneProjectViewDto;
import org.squashtest.tm.service.internal.display.dto.ProjectDto;
import org.squashtest.tm.service.internal.display.dto.ProjectInfoForMilestoneAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.ProjectViewDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.hibernate.ProjectDaoImpl;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

@Repository
public class MilestoneDisplayDaoImpl
implements MilestoneDisplayDao {
    private static final String RANGE = "RANGE";
    private static final String OWNER_FIRST_NAME = "OWNER_FIRST_NAME";
    private static final String OWNER_LAST_NAME = "OWNER_LAST_NAME";
    private static final String OWNER_LOGIN = "OWNER_LOGIN";
    private static final String TEMPLATE = "TEMPLATE";
    private final DSLContext dsl;
    private final MilestoneDao milestoneDao;

    public MilestoneDisplayDaoImpl(DSLContext dsl, MilestoneDao milestoneDao) {
        this.dsl = dsl;
        this.milestoneDao = milestoneDao;
    }

    @Override
    public List<MilestoneDto> getMilestonesByTestCaseId(Long id) {
        return this.getMilestoneByTestCaseIds(List.of(id)).getOrDefault(id, Collections.emptyList());
    }

    private Map<Long, List<MilestoneDto>> getMilestoneByTestCaseIds(Collection<Long> testCaseIds) {
        return this.selectMilestoneDto((Field<Long>)TestCase.TEST_CASE.TCLN_ID).from((TableLike)TestCase.TEST_CASE).innerJoin((TableLike)MilestoneTestCase.MILESTONE_TEST_CASE).on(MilestoneTestCase.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)TestCase.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Milestone.MILESTONE).on(MilestoneTestCase.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(TestCase.TEST_CASE.TCLN_ID.in(testCaseIds)).fetchGroups((Field)TestCase.TEST_CASE.TCLN_ID, record -> (MilestoneDto)record.into(MilestoneDto.class));
    }

    @Override
    public List<MilestoneDto> findAll() {
        return this.selectMilestoneDto().from((TableLike)Tables.MILESTONE).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).fetch().into(MilestoneDto.class);
    }

    @Override
    public List<MilestoneDto> findByIds(Set<Long> milestoneIds) {
        return this.selectMilestoneDto().from((TableLike)Tables.MILESTONE).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Milestone.MILESTONE.MILESTONE_ID.in(milestoneIds)).fetch().into(MilestoneDto.class);
    }

    @Override
    public void appendMilestoneBinding(List<ProjectDto> projects, UserDto currentUserDto) {
        Table<Record1<Long>> readableProjectTable = ProjectDaoImpl.selectAllReadableProjectIdsQuery(currentUserDto);
        Map projectsMap = projects.stream().collect(Collectors.toMap(ProjectDto::getId, Function.identity()));
        this.dsl.select(this.getFieldMilestoneBinding()).from(readableProjectTable).join((TableLike)MilestoneBinding.MILESTONE_BINDING).on(MilestoneBinding.MILESTONE_BINDING.PROJECT_ID.eq(readableProjectTable.field("PROJECT_ID", Long.class))).forEach(milestoneRecord -> {
            ProjectDto project = (ProjectDto)projectsMap.get(milestoneRecord.get((Field)MilestoneBinding.MILESTONE_BINDING.PROJECT_ID));
            project.getMilestoneBindings().add(this.getMilestoneBindingRecord((Record)milestoneRecord));
        });
    }

    private List<Field<?>> getFieldMilestoneBinding() {
        return List.of(MilestoneBinding.MILESTONE_BINDING.MILESTONE_BINDING_ID, MilestoneBinding.MILESTONE_BINDING.MILESTONE_ID, MilestoneBinding.MILESTONE_BINDING.PROJECT_ID);
    }

    private MilestoneBindingDto getMilestoneBindingRecord(Record milestoneRecord) {
        MilestoneBindingDto binding = new MilestoneBindingDto();
        binding.setId((Long)milestoneRecord.get((Field)MilestoneBinding.MILESTONE_BINDING.MILESTONE_BINDING_ID));
        binding.setMilestoneId((Long)milestoneRecord.get((Field)MilestoneBinding.MILESTONE_BINDING.MILESTONE_ID));
        binding.setProjectId((Long)milestoneRecord.get((Field)MilestoneBinding.MILESTONE_BINDING.PROJECT_ID));
        return binding;
    }

    @Override
    public void appendBoundMilestoneInformation(List<ProjectViewDto> projects) {
        Map projectsMap = projects.stream().collect(Collectors.toMap(ProjectDto::getId, Function.identity()));
        Set projectIds = projects.stream().map(ProjectDto::getId).collect(Collectors.toSet());
        this.dsl.select((SelectField)Milestone.MILESTONE.MILESTONE_ID, (SelectField)Milestone.MILESTONE.LABEL, (SelectField)Milestone.MILESTONE.STATUS, (SelectField)Milestone.MILESTONE.END_DATE, (SelectField)Milestone.MILESTONE.M_RANGE, (SelectField)CoreUser.CORE_USER.FIRST_NAME, (SelectField)CoreUser.CORE_USER.LAST_NAME, (SelectField)CoreUser.CORE_USER.LOGIN, (SelectField)Milestone.MILESTONE.DESCRIPTION, (SelectField)MilestoneBinding.MILESTONE_BINDING.PROJECT_ID, (SelectField)Milestone.MILESTONE.LAST_MODIFIED_BY, (SelectField)Milestone.MILESTONE.LAST_MODIFIED_ON, (SelectField)Milestone.MILESTONE.CREATED_BY, (SelectField)Milestone.MILESTONE.CREATED_ON).from((TableLike)Milestone.MILESTONE).leftJoin((TableLike)MilestoneBinding.MILESTONE_BINDING).on(MilestoneBinding.MILESTONE_BINDING.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(MilestoneBinding.MILESTONE_BINDING.PROJECT_ID.in(projectIds)).fetch().forEach(record -> {
            Long projectId = (Long)record.get((Field)MilestoneBinding.MILESTONE_BINDING.PROJECT_ID);
            Long milestoneId = (Long)record.get((Field)Milestone.MILESTONE.MILESTONE_ID);
            ProjectViewDto project = (ProjectViewDto)projectsMap.get(projectId);
            MilestoneDto milestone = new MilestoneDto();
            milestone.setId(milestoneId);
            milestone.setLabel((String)record.get((Field)Milestone.MILESTONE.LABEL));
            milestone.setStatus((String)record.get((Field)Milestone.MILESTONE.STATUS));
            milestone.setEndDate((Date)record.get((Field)Milestone.MILESTONE.END_DATE));
            milestone.setRange((String)record.get((Field)Milestone.MILESTONE.M_RANGE));
            milestone.setOwnerFirstName((String)record.get((Field)CoreUser.CORE_USER.FIRST_NAME));
            milestone.setOwnerLastName((String)record.get((Field)CoreUser.CORE_USER.LAST_NAME));
            milestone.setOwnerLogin((String)record.get((Field)CoreUser.CORE_USER.LOGIN));
            String sanitizedDescription = HTMLCleanupUtils.htmlToTrimmedText((String)record.get((Field)Milestone.MILESTONE.DESCRIPTION));
            milestone.setDescription(sanitizedDescription);
            milestone.setCreatedBy((String)record.get((Field)Milestone.MILESTONE.CREATED_BY));
            milestone.setCreatedOn((Date)record.get((Field)Milestone.MILESTONE.CREATED_ON));
            milestone.setLastModifiedBy((String)record.get((Field)Milestone.MILESTONE.LAST_MODIFIED_BY));
            milestone.setLastModifiedOn((Date)record.get((Field)Milestone.MILESTONE.LAST_MODIFIED_ON));
            MilestoneProjectViewDto milestoneProjectViewInformation = new MilestoneProjectViewDto();
            milestoneProjectViewInformation.setMilestone(milestone);
            milestoneProjectViewInformation.setMilestoneBoundToOneObjectOfProject(this.milestoneDao.isMilestoneBoundToOneObjectOfProject(milestoneId, projectId));
            project.getBoundMilestonesInformation().add(milestoneProjectViewInformation);
        });
    }

    @Override
    public void appendBoundProjectsToMilestoneInformation(MilestoneAdminViewDto milestone) {
        Long milestoneId = milestone.getId();
        if (MilestoneRange.GLOBAL.name().equals(milestone.getRange())) {
            Result boundProjects = this.dsl.selectFrom(this.getProjectsBoundToMilestone(milestoneId)).fetch();
            boundProjects.forEach(boundProject -> {
                ProjectInfoForMilestoneAdminViewDto projectInfo = this.createProjectInfo(milestoneId, (Record)boundProject, true);
                milestone.getBoundProjectsInformation().add(projectInfo);
            });
        } else {
            Result projectsInPerimeter = this.dsl.selectFrom(this.getProjectsInMilestonePerimeter(milestoneId)).fetch();
            projectsInPerimeter.forEach(projectInPerimeter -> {
                Long projectId = (Long)projectInPerimeter.get((Field)Tables.PROJECT.PROJECT_ID);
                boolean projectIsBoundToMilestone = this.checkIfProjectInPerimeterIsBoundToMilestone(milestoneId, projectId);
                ProjectInfoForMilestoneAdminViewDto projectInfo = this.createProjectInfo(milestoneId, (Record)projectInPerimeter, projectIsBoundToMilestone);
                milestone.getBoundProjectsInformation().add(projectInfo);
            });
        }
    }

    private ProjectInfoForMilestoneAdminViewDto createProjectInfo(Long milestoneId, Record record, boolean boundToMilestone) {
        Long projectId = (Long)record.get((Field)Tables.PROJECT.PROJECT_ID);
        ProjectInfoForMilestoneAdminViewDto projectInfo = new ProjectInfoForMilestoneAdminViewDto();
        projectInfo.setProjectId(projectId);
        projectInfo.setProjectName((String)record.get((Field)Tables.PROJECT.NAME));
        projectInfo.setTemplate((Boolean)record.get(TEMPLATE, Boolean.class));
        projectInfo.setBoundToMilestone(boundToMilestone);
        projectInfo.setMilestoneBoundToOneObjectOfProject(this.milestoneDao.isMilestoneBoundToOneObjectOfProject(milestoneId, projectId));
        return projectInfo;
    }

    private Table<?> getProjectsBoundToMilestone(long milestoneId) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)DSL.field((Condition)Tables.PROJECT.PROJECT_TYPE.eq((Object)"T")).as(TEMPLATE)).from((TableLike)Tables.PROJECT).leftJoin((TableLike)MilestoneBinding.MILESTONE_BINDING).on(MilestoneBinding.MILESTONE_BINDING.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(MilestoneBinding.MILESTONE_BINDING.MILESTONE_ID.eq((Object)milestoneId)).asTable();
    }

    private Table<?> getProjectsInMilestonePerimeter(long milestoneId) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)DSL.field((Condition)Tables.PROJECT.PROJECT_TYPE.eq((Object)"T")).as(TEMPLATE)).from((TableLike)Tables.PROJECT).leftJoin((TableLike)Tables.MILESTONE_BINDING_PERIMETER).on(Tables.MILESTONE_BINDING_PERIMETER.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.MILESTONE_BINDING_PERIMETER.MILESTONE_ID.eq((Object)milestoneId)).asTable();
    }

    private boolean checkIfProjectInPerimeterIsBoundToMilestone(long milestoneId, long projectId) {
        Result boundProjects = this.dsl.selectFrom(this.getProjectsBoundToMilestone(milestoneId)).fetch();
        return boundProjects.stream().anyMatch(boundProject -> ((Long)boundProject.get((Field)Tables.PROJECT.PROJECT_ID)).equals(projectId));
    }

    @Override
    public Multimap<Long, Long> findMilestonesByTestCaseId(Set<Long> testCaseIds) {
        ArrayListMultimap milestoneIdsByTestCaseIds = ArrayListMultimap.create();
        this.dsl.select((SelectField)MilestoneTestCase.MILESTONE_TEST_CASE.MILESTONE_ID, (SelectField)MilestoneTestCase.MILESTONE_TEST_CASE.TEST_CASE_ID).from((TableLike)MilestoneTestCase.MILESTONE_TEST_CASE).where(MilestoneTestCase.MILESTONE_TEST_CASE.TEST_CASE_ID.in(testCaseIds)).forEach(arg_0 -> MilestoneDisplayDaoImpl.lambda$9((Multimap)milestoneIdsByTestCaseIds, arg_0));
        return milestoneIdsByTestCaseIds;
    }

    @Override
    public Multimap<Long, MilestoneDto> findMilestonesByCampaignId(Set<Long> campaignIds) {
        ArrayListMultimap milestoneIdsByCampaignId = ArrayListMultimap.create();
        this.dsl.select((SelectField)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID, (SelectField)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID, (SelectField)Milestone.MILESTONE.STATUS).from((TableLike)Tables.MILESTONE_CAMPAIGN).innerJoin((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.in(campaignIds)).forEach(arg_0 -> this.lambda$10((Multimap)milestoneIdsByCampaignId, arg_0));
        return milestoneIdsByCampaignId;
    }

    private MilestoneDto createMilestoneDto(Record record) {
        MilestoneDto dto = new MilestoneDto();
        dto.setStatus((String)record.get((Field)Milestone.MILESTONE.STATUS));
        dto.setId((Long)record.get((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID));
        return dto;
    }

    @Override
    public RequirementVersionMilestones findMilestonesByRequirementVersionId(Set<Long> requirementVersionIds) {
        RequirementVersionMilestones requirementVersionMilestones = new RequirementVersionMilestones();
        this.appendDirectlyBoundMilestones(requirementVersionIds, requirementVersionMilestones);
        this.appendIndirectlyBoundMilestone(requirementVersionIds, requirementVersionMilestones);
        return requirementVersionMilestones;
    }

    private void appendIndirectlyBoundMilestone(Set<Long> requirementVersionIds, RequirementVersionMilestones requirementVersionMilestones) {
        Requirement ancestor = Requirement.REQUIREMENT.as("ANCESTORS");
        RequirementVersion ancestorVersion = Tables.REQUIREMENT_VERSION.as("ANCESTORS_VERSION");
        Requirement descendants = Requirement.REQUIREMENT.as("DESCENDANTS");
        RequirementVersion descendantVersion = Tables.REQUIREMENT_VERSION.as("DESCENDANTS_VERSION");
        this.dsl.select((SelectField)ancestorVersion.RES_ID, (SelectField)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID).from((TableLike)ancestorVersion).innerJoin((TableLike)ancestor).on(ancestor.RLN_ID.eq((Field)ancestorVersion.REQUIREMENT_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(ancestor.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)descendants).on(descendants.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)descendantVersion).on(descendants.RLN_ID.eq((Field)descendantVersion.REQUIREMENT_ID)).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)descendantVersion.RES_ID)).where(ancestorVersion.RES_ID.in(requirementVersionIds).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.gt((Object)0))).forEach(record -> requirementVersionMilestones.addIndirectlyBoundMilestone((Long)record.get((Field)requirementVersion.RES_ID), (Long)record.get((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)));
    }

    private void appendDirectlyBoundMilestones(Set<Long> requirementVersionIds, RequirementVersionMilestones requirementVersionMilestones) {
        this.dsl.select((SelectField)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID, (SelectField)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID).from((TableLike)Tables.MILESTONE_REQ_VERSION).where(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.in(requirementVersionIds)).forEach(record -> requirementVersionMilestones.addDirectlyBoundMilestone((Long)record.get((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID), (Long)record.get((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)));
    }

    @Override
    public Multimap<Long, Long> findMilestonesByProjectId(Set<Long> projectIds) {
        ArrayListMultimap map = ArrayListMultimap.create();
        this.dsl.select((SelectField)MilestoneBinding.MILESTONE_BINDING.MILESTONE_ID, (SelectField)MilestoneBinding.MILESTONE_BINDING.PROJECT_ID).from((TableLike)MilestoneBinding.MILESTONE_BINDING).where(MilestoneBinding.MILESTONE_BINDING.PROJECT_ID.in(projectIds)).forEach(arg_0 -> MilestoneDisplayDaoImpl.lambda$13((Multimap)map, arg_0));
        return map;
    }

    @Override
    public List<MilestoneDto> getMilestonesByRequirementVersionId(Long id) {
        return this.selectMilestoneDto().from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)id)).fetch().into(MilestoneDto.class);
    }

    @Override
    public List<MilestoneDto> getMilestonesDtoAssociableToRequirementVersion(long versionId) {
        List milestoneStatuses = MilestoneStatus.getAllStatusAllowingObjectBind();
        List<String> status = milestoneStatuses.stream().map(Enum::name).toList();
        return this.selectMilestoneDto().from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.MILESTONE_BINDING).on(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_BINDING.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).innerJoin((TableLike)Tables.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)versionId).and(Tables.MILESTONE.STATUS.in(status)).and(Tables.MILESTONE.MILESTONE_ID.notIn((Select)this.dsl.select((SelectField)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID).from((TableLike)Tables.REQUIREMENT_VERSION.as("RV")).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.as((String)"RV").REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION.as("RV2")).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.as((String)"RV2").REQUIREMENT_ID)).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.as((String)"RV2").RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).where(Tables.REQUIREMENT_VERSION.as((String)"RV").RES_ID.eq((Object)versionId))))).fetchInto(MilestoneDto.class);
    }

    @Override
    public List<MilestoneDto> getMilestonesByCampaignId(Long campaignId) {
        return this.getMilestonesByCampaignIds(List.of(campaignId)).getOrDefault(campaignId, Collections.emptyList());
    }

    private Map<Long, List<MilestoneDto>> getMilestonesByCampaignIds(Collection<Long> campaignIds) {
        return this.selectMilestoneDto((Field<Long>)Tables.CAMPAIGN.CLN_ID).from((TableLike)Tables.CAMPAIGN).innerJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).innerJoin((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Tables.CAMPAIGN.CLN_ID.in(campaignIds)).fetchGroups((Field)Tables.CAMPAIGN.CLN_ID, record -> (MilestoneDto)record.into(MilestoneDto.class));
    }

    @Override
    public List<MilestoneDto> getMilestonesByIterationId(Long iterationId) {
        return this.getMilestonesByIterationIds(List.of(iterationId)).getOrDefault(iterationId, Collections.emptyList());
    }

    private Map<Long, List<MilestoneDto>> getMilestonesByIterationIds(Collection<Long> iterationIds) {
        return this.selectMilestoneDto((Field<Long>)Tables.ITERATION.ITERATION_ID).from((TableLike)Tables.ITERATION).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)).innerJoin((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Tables.ITERATION.ITERATION_ID.in(iterationIds)).fetchGroups((Field)Tables.ITERATION.ITERATION_ID, record -> (MilestoneDto)record.into(MilestoneDto.class));
    }

    @Override
    public List<MilestoneDto> getMilestonesBySuiteId(Long suiteId) {
        return this.getMilestonesBySuiteIds(List.of(suiteId)).getOrDefault(suiteId, Collections.emptyList());
    }

    private Map<Long, List<MilestoneDto>> getMilestonesBySuiteIds(Collection<Long> suiteIds) {
        return this.selectMilestoneDto((Field<Long>)Tables.TEST_SUITE.ID).from((TableLike)Tables.TEST_SUITE).innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)).innerJoin((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Tables.TEST_SUITE.ID.in(suiteIds)).fetchGroups((Field)Tables.TEST_SUITE.ID, record -> (MilestoneDto)record.into(MilestoneDto.class));
    }

    @Override
    public List<MilestoneDto> getMilestonesByExecutionId(Long executionId) {
        return this.selectMilestoneDto().from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)).innerJoin((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetch().into(MilestoneDto.class);
    }

    @Override
    public List<MilestoneDto> getMilestonesBySessionOverviewId(long sessionOverviewId) {
        return this.selectMilestoneDto().from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)).innerJoin((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)sessionOverviewId)).fetch().into(MilestoneDto.class);
    }

    @Override
    public Map<Long, List<MilestoneDto>> getMilestonesByBoundEntity(List<Long> ids, NodeType handledEntityType) {
        return switch (handledEntityType) {
            case NodeType.CAMPAIGN -> this.getMilestonesByCampaignIds(ids);
            case NodeType.ITERATION -> this.getMilestonesByIterationIds(ids);
            case NodeType.TEST_SUITE -> this.getMilestonesBySuiteIds(ids);
            case NodeType.TEST_CASE -> this.getMilestoneByTestCaseIds(ids);
            case NodeType.REQUIREMENT, NodeType.HIGH_LEVEL_REQUIREMENT -> this.getMilestonesDtoForCurrentVersionByRequirementId(ids);
            default -> Collections.emptyMap();
        };
    }

    @Override
    public boolean areAllMilestoneGlobalOrInOneManageableProjectPerimeterOrOwner(Collection<Long> milestoneIds, Collection<Long> manageableProjectIds, long userId) {
        int ownerCount = (Integer)((Record1)this.dsl.select((SelectField)DSL.countDistinct((Field)Milestone.MILESTONE.MILESTONE_ID)).from((TableLike)Milestone.MILESTONE).where(Milestone.MILESTONE.MILESTONE_ID.in(milestoneIds)).and(Milestone.MILESTONE.USER_ID.eq((Object)userId)).fetchOne()).value1();
        if (ownerCount == milestoneIds.size()) {
            return true;
        }
        int globalCount = (Integer)((Record1)this.dsl.select((SelectField)DSL.countDistinct((Field)Milestone.MILESTONE.MILESTONE_ID)).from((TableLike)Milestone.MILESTONE).where(Milestone.MILESTONE.MILESTONE_ID.in(milestoneIds)).and(Milestone.MILESTONE.M_RANGE.eq((Object)MilestoneRange.GLOBAL.name())).fetchOne()).value1();
        if (ownerCount + globalCount == milestoneIds.size()) {
            return true;
        }
        int perimeterCount = (Integer)((Record1)this.dsl.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE_BINDING_PERIMETER.MILESTONE_ID)).from((TableLike)Tables.MILESTONE_BINDING_PERIMETER).join((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_BINDING_PERIMETER.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_BINDING_PERIMETER.MILESTONE_ID.in(milestoneIds)).and(Tables.MILESTONE_BINDING_PERIMETER.PROJECT_ID.in(manageableProjectIds)).and(Milestone.MILESTONE.M_RANGE.ne((Object)MilestoneRange.GLOBAL.name())).and(Milestone.MILESTONE.USER_ID.ne((Object)userId)).fetchOne()).value1();
        return ownerCount + globalCount + perimeterCount == milestoneIds.size();
    }

    @Override
    public void checkIfAllMilestoneAreGlobalOrInOneManageableProjectPerimeterOrOwner(Collection<Long> milestoneIds, Collection<Long> manageableProjectIds, long userId) {
        if (!this.areAllMilestoneGlobalOrInOneManageableProjectPerimeterOrOwner(milestoneIds, manageableProjectIds, userId)) {
            throw new AccessDeniedException(HttpStatus.FORBIDDEN.getReasonPhrase());
        }
    }

    private Map<Long, List<MilestoneDto>> getMilestonesDtoForCurrentVersionByRequirementId(List<Long> ids) {
        return this.selectMilestoneDto((Field<Long>)Requirement.REQUIREMENT.RLN_ID).from((TableLike)Requirement.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Requirement.REQUIREMENT.CURRENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Milestone.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Milestone.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)CoreUser.CORE_USER).on(CoreUser.CORE_USER.PARTY_ID.eq((Field)Milestone.MILESTONE.USER_ID)).where(Requirement.REQUIREMENT.RLN_ID.in(ids)).fetchGroups((Field)Requirement.REQUIREMENT.RLN_ID, record -> (MilestoneDto)record.into(MilestoneDto.class));
    }

    private SelectSelectStep<?> selectMilestoneDto(Field<Long> primaryKey) {
        return this.dsl.select(primaryKey, (SelectField)Milestone.MILESTONE.MILESTONE_ID.as("ID"), (SelectField)Milestone.MILESTONE.LABEL, (SelectField)Milestone.MILESTONE.DESCRIPTION, (SelectField)Milestone.MILESTONE.STATUS, (SelectField)Milestone.MILESTONE.END_DATE, (SelectField)Milestone.MILESTONE.M_RANGE.as(RANGE), (SelectField)Milestone.MILESTONE.LAST_MODIFIED_BY, (SelectField)Milestone.MILESTONE.LAST_MODIFIED_ON, (SelectField)Milestone.MILESTONE.CREATED_BY, (SelectField)Milestone.MILESTONE.CREATED_ON, (SelectField)CoreUser.CORE_USER.FIRST_NAME.as(OWNER_FIRST_NAME), (SelectField)CoreUser.CORE_USER.LAST_NAME.as(OWNER_LAST_NAME), (SelectField)CoreUser.CORE_USER.LOGIN.as(OWNER_LOGIN));
    }

    private SelectSelectStep<?> selectMilestoneDto() {
        return this.dsl.select((SelectField)Milestone.MILESTONE.MILESTONE_ID.as("ID"), (SelectField)Milestone.MILESTONE.LABEL, (SelectField)Milestone.MILESTONE.DESCRIPTION, (SelectField)Milestone.MILESTONE.STATUS, (SelectField)Milestone.MILESTONE.END_DATE, (SelectField)Milestone.MILESTONE.M_RANGE.as(RANGE), (SelectField)Milestone.MILESTONE.LAST_MODIFIED_BY, (SelectField)Milestone.MILESTONE.LAST_MODIFIED_ON, (SelectField)Milestone.MILESTONE.CREATED_BY, (SelectField)Milestone.MILESTONE.CREATED_ON, (SelectField)CoreUser.CORE_USER.FIRST_NAME.as(OWNER_FIRST_NAME), (SelectField)CoreUser.CORE_USER.LAST_NAME.as(OWNER_LAST_NAME), (SelectField)CoreUser.CORE_USER.LOGIN.as(OWNER_LOGIN));
    }

    private static /* synthetic */ void lambda$9(Multimap multimap, Record2 record) {
        boolean bl = multimap.put((Object)((Long)record.get((Field)MilestoneTestCase.MILESTONE_TEST_CASE.TEST_CASE_ID)), (Object)((Long)record.get((Field)MilestoneTestCase.MILESTONE_TEST_CASE.MILESTONE_ID)));
    }

    private /* synthetic */ void lambda$10(Multimap multimap, Record3 record) {
        boolean bl = multimap.put((Object)((Long)record.get((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)), (Object)this.createMilestoneDto((Record)record));
    }

    private static /* synthetic */ void lambda$13(Multimap multimap, Record2 record) {
        boolean bl = multimap.put((Object)((Long)record.get((Field)MilestoneBinding.MILESTONE_BINDING.PROJECT_ID)), (Object)((Long)record.get((Field)MilestoneBinding.MILESTONE_BINDING.MILESTONE_ID)));
    }

    public class RequirementVersionMilestones {
        private ArrayListMultimap<Long, Long> directlyBoundMilestone = ArrayListMultimap.create();
        private ArrayListMultimap<Long, Long> indirectlyBoundMilestone = ArrayListMultimap.create();

        public void addDirectlyBoundMilestone(Long requirementVersionId, Long milestoneId) {
            this.directlyBoundMilestone.put((Object)requirementVersionId, (Object)milestoneId);
        }

        public void addIndirectlyBoundMilestone(Long ancestorVersionId, Long milestoneId) {
            this.indirectlyBoundMilestone.put((Object)ancestorVersionId, (Object)milestoneId);
        }

        public List<Long> getDirectlyBoundMilestone(Long requirementVersionId) {
            return this.directlyBoundMilestone.get((Object)requirementVersionId);
        }

        public List<Long> getIndirectlyBoundMilestone(Long requirementVersionId) {
            return this.indirectlyBoundMilestone.get((Object)requirementVersionId);
        }

        public List<Long> getAllBoundMilestone(Long requirementVersionId) {
            ArrayList<Long> allMilestones = new ArrayList<Long>();
            allMilestones.addAll(this.getDirectlyBoundMilestone(requirementVersionId));
            allMilestones.addAll(this.getIndirectlyBoundMilestone(requirementVersionId));
            return allMilestones;
        }
    }
}

