/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import jakarta.persistence.EntityManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.springframework.context.MessageSource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.IterationStatisticsService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.display.campaign.IterationDisplayService;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.IterationKnownIssueFinder;
import org.squashtest.tm.service.internal.display.campaign.AvailableDatasetAppender;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.campaign.SprintReqTestPlanItemSuccessRateCalculator;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.campaign.IterationDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.IterationTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AutomatedSuiteDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestSuiteDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.RequestAliasesConstants;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.UserContextService;
import org.squashtest.tm.service.testplanitem.TestPlanItemAssignableUserFinder;
import org.squashtest.tm.service.user.PartyPreferenceService;

@Service
@Transactional(readOnly=true)
public class IterationDisplayServiceImpl
implements IterationDisplayService {
    private static final String CAN_READ_ITERATION = "hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ') or hasRole('ROLE_ADMIN')";
    private final IterationDisplayDao iterationDisplayDao;
    private final DSLContext dslContext;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final CustomFieldValueDisplayDao customFieldValueDisplayDao;
    private final MilestoneDisplayDao milestoneDisplayDao;
    private final IterationKnownIssueFinder iterationKnownIssueFinder;
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final TestSuiteDisplayDao testSuiteDisplayDao;
    private final SprintReqTestPlanItemSuccessRateCalculator rateCalculator;
    private final AutomatedSuiteDisplayDao automatedSuiteDisplayDao;
    private final CustomReportDashboardService customReportDashboardService;
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;
    private final AvailableDatasetAppender availableDatasetAppender;
    private final PartyPreferenceService partyPreferenceService;
    private final UserContextService userContextService;
    private final PermissionEvaluationService permissionEvaluationService;
    private final EntityPathHeaderDao entityPathHeaderDao;
    private final GridConfigurationService gridConfigurationService;
    private final EntityManager entityManager;
    private final MessageSource messageSource;
    private final TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder;
    private final IterationStatisticsService iterationStatisticsService;

    public IterationDisplayServiceImpl(IterationDisplayDao iterationDisplayDao, DSLContext dslContext, AttachmentDisplayDao attachmentDisplayDao, CustomFieldValueDisplayDao customFieldValueDisplayDao, MilestoneDisplayDao milestoneDisplayDao, IterationKnownIssueFinder iterationKnownIssueFinder, IterationTestPlanManagerService iterationTestPlanManagerService, TestSuiteDisplayDao testSuiteDisplayDao, SprintReqTestPlanItemSuccessRateCalculator rateCalculator, AutomatedSuiteDisplayDao automatedSuiteDisplayDao, CustomReportDashboardService customReportDashboardService, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper, AvailableDatasetAppender availableDatasetAppender, PartyPreferenceService partyPreferenceService, UserContextService userContextService, PermissionEvaluationService permissionEvaluationService, EntityPathHeaderDao entityPathHeaderDao, GridConfigurationService gridConfigurationService, EntityManager entityManager, MessageSource messageSource, TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder, IterationStatisticsService iterationStatisticsService) {
        this.iterationDisplayDao = iterationDisplayDao;
        this.dslContext = dslContext;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.customFieldValueDisplayDao = customFieldValueDisplayDao;
        this.milestoneDisplayDao = milestoneDisplayDao;
        this.iterationKnownIssueFinder = iterationKnownIssueFinder;
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.testSuiteDisplayDao = testSuiteDisplayDao;
        this.rateCalculator = rateCalculator;
        this.automatedSuiteDisplayDao = automatedSuiteDisplayDao;
        this.customReportDashboardService = customReportDashboardService;
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
        this.availableDatasetAppender = availableDatasetAppender;
        this.partyPreferenceService = partyPreferenceService;
        this.userContextService = userContextService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.entityPathHeaderDao = entityPathHeaderDao;
        this.gridConfigurationService = gridConfigurationService;
        this.entityManager = entityManager;
        this.messageSource = messageSource;
        this.testPlanItemAssignableUserFinder = testPlanItemAssignableUserFinder;
        this.iterationStatisticsService = iterationStatisticsService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ') or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=Iteration.class)
    public IterationDto findIterationView(@Id Long iterationId) {
        IterationDto iteration = this.iterationDisplayDao.findById(iterationId);
        iteration.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(iteration.getAttachmentListId()));
        iteration.getCustomFieldValues().addAll(this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.ITERATION, iterationId));
        iteration.setTestPlanStatistics(this.iterationStatisticsService.getTestPlanStatistics(iterationId));
        iteration.setNbIssues(this.iterationKnownIssueFinder.countKnownIssues(iterationId));
        iteration.setMilestones(this.milestoneDisplayDao.getMilestonesByIterationId(iterationId));
        iteration.setTestSuites(this.testSuiteDisplayDao.findForIteration(iterationId));
        this.appendUsers(iteration);
        iteration.setExecutionStatusMap(this.iterationDisplayDao.getExecutionStatusMap(iterationId));
        iteration.setNbAutomatedSuites(this.automatedSuiteDisplayDao.countAutomatedSuiteByIterationId(iterationId));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey());
        iteration.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN));
        iteration.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN));
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            iteration.setFavoriteDashboardId(dashboardId);
        }
        this.appendNbTestPlanItems(iteration);
        iteration.setBreadcrumbs(this.entityPathHeaderDao.getIterationBreadcrumbNodes(iterationId));
        iteration.setTestPlanItemExecutors(this.iterationDisplayDao.getTestPlanItemExecutors(iterationId));
        return iteration;
    }

    private void appendUsers(IterationDto iteration) {
        List<User> users = this.testPlanItemAssignableUserFinder.findAssignableUsersByIterationId(iteration.getId());
        iteration.setUsers(UserView.fromEntities(users));
    }

    private void appendNbTestPlanItems(IterationDto iteration) {
        String login = this.userContextService.getUsername();
        int count = this.currentUserCanReadUnassigned(iteration.getId()) ? this.iterationDisplayDao.getTestPlanItemCount(iteration.getTestPlanId(), null) : this.iterationDisplayDao.getTestPlanItemCount(iteration.getTestPlanId(), login);
        iteration.setNbTestPlanItems(count);
    }

    private boolean currentUserCanReadUnassigned(Long iterationId) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), iterationId, "org.squashtest.tm.domain.campaign.Iteration");
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ') or hasRole('ROLE_ADMIN')")
    public GridResponse findTestPlan(Long iterationId, GridRequest gridRequest) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(iterationId, "org.squashtest.tm.domain.campaign.Iteration");
        Long testPlanId = this.iterationDisplayDao.findTestPlanId(iterationId);
        IterationTestPlanGrid testPlanGrid = new IterationTestPlanGrid(testPlanId, userToRestrictTo, this.iterationDisplayDao, this.permissionEvaluationService);
        Iteration iteration = (Iteration)this.entityManager.find(Iteration.class, (Object)iterationId);
        Long projectId = iteration.getProject().getId();
        GridResponse gridResponse = testPlanGrid.getRows(gridRequest, this.dslContext);
        this.appendDataRows(gridResponse);
        this.rateCalculator.appendSuccessRate(gridResponse);
        this.availableDatasetAppender.appendAvailableDatasets(gridResponse);
        gridResponse.setActiveColumnIds(this.gridConfigurationService.findActiveColumnIdsForUserWithProjectId(gridRequest.getGridId(), projectId));
        return gridResponse;
    }

    private void appendDataRows(GridResponse gridResponse) {
        String idKey = RequestAliasesConstants.toCamelCase("TEST_PLAN_ITEM_ID");
        List<Long> itemTestPlanIds = gridResponse.getDataRows().stream().map(row -> (Long)row.getData().get(idKey)).toList();
        Map<Long, List<ExecutionSummaryDto>> executionSummaryDtoMap = this.iterationTestPlanManagerService.getLastExecutionStatuses(itemTestPlanIds);
        Set<Long> testCaseIds = gridResponse.getDataRows().stream().map(row -> (Long)row.getData().get(RequestAliasesConstants.toCamelCase("testCaseId"))).collect(Collectors.toSet());
        Map<Long, String> testCasePathById = this.entityPathHeaderDao.buildTestCasePathByIds(testCaseIds, " / ");
        for (DataRow row2 : gridResponse.getDataRows()) {
            TestPlanGridHelpers.addTestCasePath(row2, testCasePathById);
            TestPlanGridHelpers.formatDeactivatedUserNameInRowData(row2, this.messageSource);
            TestPlanGridHelpers.checkScriptedTestCaseHasScenario(row2);
            this.addLastExecutionStatuses(row2, executionSummaryDtoMap);
        }
    }

    private void addLastExecutionStatuses(DataRow row, Map<Long, List<ExecutionSummaryDto>> executionSummaryDtoMap) {
        Long rowItemTestPlanId = (Long)row.getData().get(RequestAliasesConstants.toCamelCase("TEST_PLAN_ITEM_ID"));
        row.addData(RequestAliasesConstants.toCamelCase("LAST_EXECUTION_STATUSES"), executionSummaryDtoMap.getOrDefault(rowItemTestPlanId, Collections.emptyList()));
    }

    @Override
    public List<String> retrieveFullNameByIterationIds(List<Long> iterationIds, List<Long> projectIds) {
        return this.iterationDisplayDao.retrieveFullNameByIterationIds(iterationIds, projectIds);
    }
}

