/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.JdbcTestCaseNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;

@Component
public class JdbcTestCaseNodeDeletionHandlerFactory {
    private final DSLContext dslContext;
    private final AttachmentRepository attachmentRepository;
    private final JdbcBatchReorderHelper reorderHelper;
    private final EntityManager entityManager;

    public JdbcTestCaseNodeDeletionHandlerFactory(DSLContext dslContext, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, EntityManager entityManager) {
        this.dslContext = dslContext;
        this.attachmentRepository = attachmentRepository;
        this.reorderHelper = reorderHelper;
        this.entityManager = entityManager;
    }

    public JdbcTestCaseNodeDeletionHandler build(NodeScope scope, List<Long> excludedIds) {
        return this.build(scope, false, excludedIds);
    }

    public JdbcTestCaseNodeDeletionHandler buildForBin(NodeScope scope) {
        return this.build(scope, true, List.of());
    }

    public JdbcTestCaseNodeDeletionHandler buildForProjectDeletion(NodeScope scope) {
        return this.build(scope, false, List.of());
    }

    private JdbcTestCaseNodeDeletionHandler build(NodeScope scope, boolean isBinFilterEnabled, List<Long> excludedIds) {
        String operationId = UUID.randomUUID().toString();
        return new JdbcTestCaseNodeDeletionHandler(scope, this.dslContext, this.entityManager, this.attachmentRepository, this.reorderHelper, operationId, isBinFilterEnabled, Objects.requireNonNullElseGet(excludedIds, List::of));
    }
}

