/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CustomRequirementVersionDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Repository(value="squashtest.tm.repository.RequirementVersionDaoImpl")
@Primary
public class RequirementVersionDaoImpl
implements CustomRequirementVersionDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private DSLContext dsl;

    @Override
    public Requirement findRequirementById(long requirementId) {
        return (Requirement)this.em.getReference(Requirement.class, (Object)requirementId);
    }

    @Override
    public RequirementVersion findByRequirementIdAndMilestone(long requirementId) {
        Optional<Milestone> active = this.activeMilestoneHolder.getActiveMilestone();
        if (active.isPresent()) {
            TypedQuery q = this.em.createNamedQuery("requirementVersion.findVersionByRequirementAndMilestone", RequirementVersion.class);
            q.setParameter("requirementId", (Object)requirementId);
            q.setParameter("milestoneId", (Object)active.get().getId());
            return (RequirementVersion)q.getSingleResult();
        }
        TypedQuery q = this.em.createNamedQuery("requirementVersion.findLatestRequirementVersion", RequirementVersion.class);
        q.setParameter("requirementId", (Object)requirementId);
        return (RequirementVersion)q.getSingleResult();
    }

    @Override
    public Map<Long, RequirementStatus> findRequirementStatusesByVersionIds(Collection<Long> versionIds) {
        return this.em.createQuery("select rv.id, rv.requirement.resource.status from RequirementVersion rv where rv.id in :versionIds", Object[].class).setParameter("versionIds", versionIds).getResultStream().collect(Collectors.toMap(r -> (Long)r[0], r -> (RequirementStatus)r[1]));
    }

    @Override
    public Map<Long, RequirementStatus> findRequirementStatusesByRequirementIds(Collection<Long> requirementIds) {
        return this.em.createQuery("select req.id, req.resource.status from Requirement req where req.id in :requirementIds", Object[].class).setParameter("requirementIds", requirementIds).getResultStream().collect(Collectors.toMap(r -> (Long)r[0], r -> (RequirementStatus)r[1]));
    }

    @Override
    public List<RequirementVersion> loadForCoverageAddition(Collection<Long> versionIds) {
        return this.em.createQuery("select rv\nfrom RequirementVersion rv\njoin fetch rv.requirement r\nleft join fetch r.syncExtender\nleft join fetch rv.requirementVersionCoverages where rv.id in :versionIds\n", RequirementVersion.class).setParameter("versionIds", versionIds).getResultList();
    }

    @Override
    public RequirementVersion loadForCoverageAddition(Long versionId) {
        return (RequirementVersion)this.loadForCoverageAddition(List.of(versionId)).stream().findFirst().orElseThrow(NoResultException::new);
    }

    @Override
    public RequirementVersion findByRemoteSyncIdAndIssueKey(Long remoteSyncId, String issueKey) {
        return this.em.createQuery("select reqVersion from RequirementVersion reqVersion\ninner join reqVersion.requirement.syncExtender extender\nwhere extender.remoteSynchronisation.id = :remoteSyncId\nand extender.remoteReqId = :issueKey", RequirementVersion.class).setParameter("remoteSyncId", (Object)remoteSyncId).setParameter("issueKey", (Object)issueKey).getResultStream().findFirst().orElse(null);
    }

    @Override
    public String findDescription(Long requirementVersionId) {
        return (String)this.em.createQuery("select res.description from Resource res\nwhere res.id = :requirementVersionId", String.class).setParameter("requirementVersionId", (Object)requirementVersionId).getSingleResult();
    }

    @Override
    public Long findProjectIdByRequirementVersionId(long requirementVersionId) {
        return (Long)this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.RESOURCE.RES_ID.eq((Object)requirementVersionId)).fetchOneInto(Long.class);
    }
}

