/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.service.internal.repository.CustomCustomFieldDao;

@Repository
public class CustomCustomFieldDaoImpl
implements CustomCustomFieldDao {
    @PersistenceContext
    private EntityManager em;

    @Override
    public Map<String, Map<BindableEntity, List<CustomField>>> findByProjectIdsAndEntities(Collection<Long> projectIds, Collection<BindableEntity> entities) {
        HashMap<String, Map<BindableEntity, List<CustomField>>> result = new HashMap<String, Map<BindableEntity, List<CustomField>>>();
        this.em.createQuery("select binding.boundProject.name, binding.boundEntity, cf\nfrom CustomFieldBinding binding\njoin binding.customField cf\nwhere binding.boundProject.id in :projectIds and binding.boundEntity in :entities", Object[].class).setParameter("projectIds", projectIds).setParameter("entities", entities).getResultStream().forEach(r -> {
            String projectName = (String)r[0];
            BindableEntity entity = (BindableEntity)r[1];
            CustomField cuf = (CustomField)r[2];
            result.computeIfAbsent(projectName, k -> new HashMap()).computeIfAbsent(entity, k -> new ArrayList()).add(cuf);
        });
        return result;
    }
}

