/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.ExploratoryExecutionRunningState;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.execution.SessionNoteKind;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.execution.ExecutionHasNoStepsException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.execution.ExploratoryExecutionService;
import org.squashtest.tm.service.execution.IssueHolder;
import org.squashtest.tm.service.internal.bugtracker.RemoteIssueContextHelper;
import org.squashtest.tm.service.internal.display.dto.execution.SessionNoteDto;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.execution.ExecutionStepModificationHelper;
import org.squashtest.tm.service.internal.repository.AutomatedExecutionExtenderDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.service.internal.repository.SessionNoteDao;
import org.squashtest.tm.service.internal.repository.display.SessionNoteDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.ExecutionModificationService")
@Transactional
public class ExecutionModificationServiceImpl
implements ExecutionModificationService,
IssueHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionModificationServiceImpl.class);
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private ExecutionStepDao executionStepDao;
    @Inject
    private ExecutionStepModificationHelper executionStepModifHelper;
    @Inject
    private SessionNoteDao sessionNoteDao;
    @Inject
    private SessionNoteDisplayDao sessionNoteDisplayDao;
    @Inject
    private ExploratoryExecutionService exploratoryExecutionService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private SprintDisplayDao sprintDisplayDao;
    @Inject
    private AutomatedExecutionExtenderDao automatedExecutionExtenderDao;
    @Inject
    private SprintManagerService sprintManagerService;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Execution findAndInitExecution(Long executionId) {
        return this.executionDao.findAndInit(executionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Execution.class)
    public void setExecutionDescription(@Id Long executionId, String description) {
        this.checkIfParentSprintIsClosed(executionId);
        Execution execution = (Execution)this.executionDao.getReferenceById(executionId);
        execution.setDescription(description);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ExecutionStep> findExecutionSteps(long executionId) {
        return this.executionDao.findSteps(executionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionStepId, 'org.squashtest.tm.domain.execution.ExecutionStep', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=ExecutionStep.class)
    public void setExecutionStepComment(@Id Long executionStepId, String comment) {
        ExecutionStep executionStep = (ExecutionStep)this.executionStepDao.findById(executionStepId);
        this.checkIfParentSprintIsClosed(executionStep.getExecution().getId());
        executionStep.setComment(comment);
    }

    @Override
    public PagedCollectionHolder<List<ExecutionStep>> findExecutionSteps(long executionId, Paging filter) {
        List list = this.executionDao.findStepsFiltered(executionId, filter);
        long count = this.executionDao.countSteps(executionId);
        return new PagingBackedPagedCollectionHolder(filter, count, (Collection)list);
    }

    @Override
    @Transactional(readOnly=true)
    public Execution findById(long id) {
        return (Execution)this.executionDao.getReferenceById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public ExecutionStep findExecutionStepById(long id) {
        return (ExecutionStep)this.executionStepDao.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Execution> findAllById(List<Long> executionIds) {
        return this.executionDao.findAllById(executionIds);
    }

    @Override
    public Map<Long, List<ExecutionSummaryDto>> findIterationTestPlanItemLastExecStatuses(Collection<Long> itemTestPlanIds) {
        return this.executionDao.findIterationTestPlanItemLastExecStatuses(itemTestPlanIds);
    }

    @Override
    public AutomatedExecutionExtender findExecutionExtenderByExtenderId(long extenderId) {
        return this.automatedExecutionExtenderDao.findById(extenderId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Execution.class)
    public void setExecutionStatus(@Id Long executionId, ExecutionStatus status) {
        this.checkIfParentSprintIsClosed(executionId);
        Execution execution = (Execution)this.executionDao.getReferenceById(executionId);
        execution.setExecutionStatus(status);
    }

    @Override
    @PreventConcurrent(entityType=Execution.class)
    public long updateSteps(@Id long executionId) {
        this.checkIfParentSprintIsClosed(executionId);
        Execution execution = this.executionDao.loadWithSteps(executionId);
        List<ExecutionStep> toBeUpdated = this.executionStepModifHelper.findStepsToUpdate(execution);
        long result = this.executionStepModifHelper.doUpdateStep(toBeUpdated, execution);
        if (execution.getSteps().isEmpty()) {
            throw new ExecutionHasNoStepsException();
        }
        return result;
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Execution.class)
    public SessionNoteDto createSessionNote(@Id long executionId, SessionNoteKind noteKind, String noteContent, Integer noteOrder) {
        this.checkIfParentSprintIsClosed(executionId);
        ExploratoryExecutionRunningState currentState = this.exploratoryExecutionService.findExploratoryExecutionRunningState(executionId);
        this.exploratoryExecutionService.checkSessionIsNotPaused(currentState);
        this.exploratoryExecutionService.checkSessionIsNotStopped(currentState);
        Long noteId = this.sessionNoteDao.createSessionNote(executionId, noteKind, noteContent, noteOrder);
        SessionNote sessionNote = (SessionNote)this.sessionNoteDao.findById(noteId);
        this.createAttachments(sessionNote);
        this.exploratoryExecutionService.updateExecutionMetadata(executionId);
        return this.sessionNoteDisplayDao.findById(noteId);
    }

    private void createAttachments(SessionNote sessionNote) {
        if (sessionNote.getId() == null) {
            return;
        }
        String content = sessionNote.getContent();
        if (content == null || content.isEmpty()) {
            return;
        }
        String newContent = this.attachmentManagerService.handleRichTextAttachments(content, sessionNote.getAttachmentList());
        if (!content.equals(newContent)) {
            sessionNote.setContent(newContent);
        }
    }

    @Override
    public SessionNoteDto updateSessionNoteKind(long noteId, SessionNoteKind kind) {
        this.checkPermissionsAndSessionState(noteId);
        this.sessionNoteDao.updateSessionNoteKind(noteId, kind);
        Long executionId = this.sessionNoteDao.findExploratoryExecutionId(noteId);
        this.exploratoryExecutionService.updateExecutionMetadata(executionId);
        return this.sessionNoteDisplayDao.findById(noteId);
    }

    @Override
    public SessionNoteDto updateSessionNoteContent(long noteId, String content) {
        this.checkPermissionsAndSessionState(noteId);
        this.sessionNoteDao.updateSessionNoteContent(noteId, content);
        Long executionId = this.sessionNoteDao.findExploratoryExecutionId(noteId);
        this.exploratoryExecutionService.updateExecutionMetadata(executionId);
        return this.sessionNoteDisplayDao.findById(noteId);
    }

    @Override
    public void deleteSessionNote(long noteId) {
        this.checkPermissionsAndSessionState(noteId);
        this.sessionNoteDao.deleteSessionNote(noteId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Execution.class)
    public void changeNotesIndex(@Id long executionId, Integer newIndex, List<Long> movedNoteIds) {
        ExploratoryExecution execution = (ExploratoryExecution)this.entityManager.find(ExploratoryExecution.class, (Object)executionId);
        List allSessionNotes = execution.getSessionNotes();
        List<SessionNote> movedSessionNotes = movedNoteIds.stream().map(noteId -> allSessionNotes.stream().filter(note -> note.getId().equals(noteId)).findFirst().orElseThrow()).toList();
        execution.moveSessionNotes(newIndex, movedSessionNotes);
    }

    private void checkPermissionsAndSessionState(long noteId) {
        Long executionId = this.sessionNoteDao.findExploratoryExecutionId(noteId);
        this.checkExecutePermissionAndBlockingMilestone(executionId);
        this.checkIfParentSprintIsClosed(executionId);
        ExploratoryExecutionRunningState currentState = this.exploratoryExecutionService.findExploratoryExecutionRunningState(executionId);
        this.exploratoryExecutionService.checkSessionIsNotStopped(currentState);
    }

    @CheckBlockingMilestone(entityType=Execution.class)
    private void checkExecutePermissionAndBlockingMilestone(@Id Long executionId) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(executionId), Permissions.EXECUTE.name(), Execution.class.getName());
    }

    private void checkIfParentSprintIsClosed(Long executionId) {
        if (SprintStatus.CLOSED.equals((Object)this.sprintDisplayDao.getSprintStatusByExecutionId(executionId))) {
            throw new SprintClosedException();
        }
    }

    @Override
    public RemoteIssueContext getRemoteIssueContext(long executionId, String squashPublicUrl, MessageSource messageSource) {
        this.checkCanAddIssue(executionId);
        Execution execution = this.findById(executionId);
        return RemoteIssueContextHelper.getRemoteIssueContext(execution, squashPublicUrl, messageSource);
    }

    @Override
    public BugTracker findBugTrackerByEntityId(long executionId) {
        return this.findById(executionId).getBugTracker();
    }

    @Override
    public void checkCanAddIssue(long executionId) {
        LOGGER.trace("Posting new issue for execution %d".formatted(executionId), new Object[0]);
        if (SprintStatus.CLOSED.equals((Object)this.sprintManagerService.getSprintStatusByExecutionId(executionId))) {
            throw new SprintClosedException();
        }
    }

    @Override
    public IssueDetector fetchIssueDetector(long executionId) {
        return this.findById(executionId);
    }
}

